"use strict";

require("jest-canvas-mock");
require("@testing-library/jest-dom/extend-expect");
var _react = require("@testing-library/react");
var _enzyme = _interopRequireDefault(require("enzyme"));
var _enzymeAdapterReact = _interopRequireDefault(require("enzyme-adapter-react-16"));
var _useContext = require("./mocks/useContext.mock");
var _DataStore = require("../public/store/DataStore");
var _services = _interopRequireDefault(require("./mocks/services"));
var _NotificationsStart = _interopRequireDefault(require("./mocks/services/notifications/NotificationsStart.mock"));
var _stringPrototype = _interopRequireDefault(require("string.prototype.replaceall"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// @ts-ignore

_stringPrototype.default.shim();
_enzyme.default.configure({
  adapter: new _enzymeAdapterReact.default()
});
(0, _react.configure)({
  testIdAttribute: 'data-test-subj'
});
jest.mock('@elastic/eui/lib/eui_components/form/form_row/make_id', () => () => 'some_make_id');
jest.mock('@elastic/eui/lib/services/accessibility/html_id_generator', () => ({
  htmlIdGenerator: () => {
    return () => 'some_html_id';
  }
}));

// @ts-ignore
window.Worker = function () {
  this.postMessage = () => {};
  // @ts-ignore
  this.terminate = () => {};
};

// @ts-ignore
window.URL = {
  createObjectURL: () => {
    return '';
  }
};

// https://github.com/elastic/eui/issues/2530
jest.mock('@elastic/eui/lib/eui_components/icon', () => ({
  EuiIcon: () => 'EuiIconMock',
  __esModule: true,
  IconPropType: require('@elastic/eui/lib/eui_components/icon/icon').IconPropType,
  ICON_TYPES: require('@elastic/eui/lib/eui_components/icon/icon').TYPES,
  ICON_SIZES: require('@elastic/eui/lib/eui_components/icon/icon').SIZES,
  ICON_COLORS: require('@elastic/eui/lib/eui_components/icon/icon').COLORS
}));

/**
 * Moment timezones are not working from jest so here we mock
 * moment.tz.names function
 *
 * Also, format function is mocked to return always the same value so that we can correctly test
 * functions that call this
 */
jest.mock('moment', () => {
  const moment = jest.requireActual('moment');

  // Set moment tz mock
  if (!moment.tz) moment.tz = {};
  moment.tz.names = () => ['Pacific/Tahiti'];
  const momentInstance = moment();
  momentInstance.format = jest.fn().mockReturnValue('2023-01-25T10:05');
  function fakeMoment() {
    return momentInstance;
  }
  Object.assign(fakeMoment, moment);
  return fakeMoment;
});

/**
 * React useContext is mocked to return the mocked services
 * so that this works in all tests
 */
jest.mock('react', () => {
  const ActualReact = jest.requireActual('react');
  return {
    ...ActualReact,
    useContext: () => _useContext.mockContexts
  };
});

/**
 * Mocks the vega view renderer
 */
jest.mock('vega/build-es5/vega.js', () => {
  const vega = jest.requireActual('vega/build-es5/vega.js');
  return {
    ...vega,
    View: jest.fn().mockReturnValue({
      tooltip: jest.fn(),
      runAsync: jest.fn().mockReturnValue(new Promise(jest.fn()))
    })
  };
});
_DataStore.DataStore.init(_services.default, _NotificationsStart.default);
jest.setTimeout(10000); // in milliseconds
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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