"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/polyfills.ts', '<rootDir>/test/setupTests.ts'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.ts'],
  roots: ['<rootDir>'],
  coverageDirectory: './coverage',
  moduleNameMapper: {
    '\\.(css|less|scss)$': '<rootDir>/test/mocks/styleMock.ts',
    '^ui/(.*)': '<rootDir>/../../src/ui/public/$1/'
  },
  coverageReporters: ['lcov', 'text', 'cobertura'],
  testMatch: ['**/*.test.ts', '**/*.test.tsx'],
  collectCoverageFrom: ['!**/*.ts', '**/*.tsx', '!**/*.js', '!**/*.jsx', '!**/models/**', '!**/node_modules/**', '!**/index.ts', '!<rootDir>/index.js', '!<rootDir>/public/app.js', '!<rootDir>/public/temporary/**', '!<rootDir>/babel.config.js', '!<rootDir>/test/**', '!<rootDir>/server/**', '!<rootDir>/coverage/**', '!<rootDir>/scripts/**', '!<rootDir>/build/**', '!**/vendor/**'],
  clearMocks: true,
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  testEnvironment: 'jsdom',
  testTimeout: 20000
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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