/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.transport.WorkflowResponse;
import org.opensearch.rest.RestRequest;

public class TenantAwareHelper {
    private static final ConcurrentHashMap<String, AtomicInteger> activeProvisionsPerTenant = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, AtomicInteger> activeDeprovisionsPerTenant = new ConcurrentHashMap();

    private TenantAwareHelper() {
    }

    public static boolean validateTenantId(boolean isMultiTenancyEnabled, String tenantId, ActionListener<?> listener) {
        if (isMultiTenancyEnabled && tenantId == null) {
            listener.onFailure((Exception)((Object)new FlowFrameworkException("No permission to access this resource", RestStatus.FORBIDDEN)));
            return false;
        }
        return true;
    }

    public static boolean validateTenantResource(boolean isMultiTenancyEnabled, String tenantIdFromRequest, String tenantIdFromResource, ActionListener<?> listener) {
        if (isMultiTenancyEnabled && !Objects.equals(tenantIdFromRequest, tenantIdFromResource)) {
            listener.onFailure((Exception)((Object)new FlowFrameworkException("No permission to access this resource", RestStatus.FORBIDDEN)));
            return false;
        }
        return true;
    }

    public static String getTenantID(Boolean isMultiTenancyEnabled, RestRequest restRequest) {
        if (!isMultiTenancyEnabled.booleanValue()) {
            return null;
        }
        Map headers = restRequest.getHeaders();
        List tenantIdList = (List)headers.get("x-tenant-id");
        if (tenantIdList == null || tenantIdList.isEmpty()) {
            throw new FlowFrameworkException("Tenant ID header is missing or has no value", RestStatus.FORBIDDEN);
        }
        String tenantId = (String)tenantIdList.get(0);
        if (tenantId == null) {
            throw new FlowFrameworkException("Tenant ID can't be null", RestStatus.FORBIDDEN);
        }
        return tenantId;
    }

    public static boolean tryAcquireProvision(int maxExecutions, String tenantId, ActionListener<WorkflowResponse> workflowListener) {
        if (!TenantAwareHelper.tryAcquire(tenantId, activeProvisionsPerTenant, maxExecutions)) {
            workflowListener.onFailure((Exception)((Object)new FlowFrameworkException("Exceeded max simultaneous provisioning requests: " + maxExecutions, RestStatus.TOO_MANY_REQUESTS)));
            return false;
        }
        return true;
    }

    public static boolean tryAcquireDeprovision(int maxExecutions, String tenantId, ActionListener<WorkflowResponse> workflowListener) {
        if (!TenantAwareHelper.tryAcquire(tenantId, activeDeprovisionsPerTenant, maxExecutions)) {
            workflowListener.onFailure((Exception)((Object)new FlowFrameworkException("Exceeded max simultaneous deprovisioning requests: " + maxExecutions, RestStatus.TOO_MANY_REQUESTS)));
            return false;
        }
        return true;
    }

    public static void releaseProvision(String tenantId) {
        TenantAwareHelper.release(tenantId, activeProvisionsPerTenant);
    }

    public static void releaseDeprovision(String tenantId) {
        TenantAwareHelper.release(tenantId, activeDeprovisionsPerTenant);
    }

    private static boolean tryAcquire(String tenantId, ConcurrentHashMap<String, AtomicInteger> executionsMap, int maxExecutions) {
        if (tenantId == null) {
            return true;
        }
        AtomicInteger count = executionsMap.computeIfAbsent(tenantId, k -> new AtomicInteger(0));
        if (count.incrementAndGet() <= maxExecutions) {
            return true;
        }
        count.decrementAndGet();
        return false;
    }

    private static void release(String tenantId, ConcurrentHashMap<String, AtomicInteger> executionsMap) {
        if (tenantId == null) {
            return;
        }
        executionsMap.computeIfPresent(tenantId, (key, count) -> {
            int newValue = count.decrementAndGet();
            return newValue > 0 ? count : null;
        });
    }

    public static ActionListener<WorkflowResponse> releaseProvisionOnFailureListener(final String tenantId, final ActionListener<WorkflowResponse> delegate) {
        return ActionListener.notifyOnce((ActionListener)new ActionListener<WorkflowResponse>(){

            public void onResponse(WorkflowResponse response) {
                delegate.onResponse((Object)response);
            }

            public void onFailure(Exception e) {
                try {
                    TenantAwareHelper.releaseProvision(tenantId);
                }
                finally {
                    delegate.onFailure(e);
                }
            }
        });
    }

    public static ActionListener<WorkflowResponse> releaseDeprovisionListener(String tenantId, ActionListener<WorkflowResponse> delegate) {
        return ActionListener.notifyOnce((ActionListener)ActionListener.runBefore(delegate, () -> TenantAwareHelper.releaseDeprovision(tenantId)));
    }
}

