/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchResult;
import org.ldaptive.SearchScope;
import org.ldaptive.io.LdifReader;
import org.ldaptive.schema.Schema;
import org.ldaptive.schema.io.AttributeTypeValueTranscoder;
import org.ldaptive.schema.io.DITContentRuleValueTranscoder;
import org.ldaptive.schema.io.DITStructureRuleValueTranscoder;
import org.ldaptive.schema.io.MatchingRuleUseValueTranscoder;
import org.ldaptive.schema.io.MatchingRuleValueTranscoder;
import org.ldaptive.schema.io.NameFormValueTranscoder;
import org.ldaptive.schema.io.ObjectClassValueTranscoder;
import org.ldaptive.schema.io.SyntaxValueTranscoder;

public final class SchemaFactory {
    private static final String SUBSCHEMA_SUBENTRY_ATTR_NAME = "subschemaSubentry";
    private static final String ATTRIBUTE_TYPES_ATTR_NAME = "attributeTypes";
    private static final String DIT_CONTENT_RULES_ATTR_NAME = "dITContentRules";
    private static final String DIT_STRUCTURE_RULES_ATTR_NAME = "dITStructureRules";
    private static final String LDAP_SYNTAXES_ATTR_NAME = "ldapSyntaxes";
    private static final String MATCHING_RULES_ATTR_NAME = "matchingRules";
    private static final String MATCHING_RULE_USE_ATTR_NAME = "matchingRuleUse";
    private static final String NAME_FORMS_ATTR_NAME = "nameForms";
    private static final String OBJECT_CLASS_ATTR_NAME = "objectClasses";

    private SchemaFactory() {
    }

    public static Schema createSchema(InputStream is) throws IOException {
        LdifReader reader = new LdifReader(new InputStreamReader(is));
        return SchemaFactory.createSchema(reader.read().getEntry());
    }

    public static Schema createSchema(ConnectionFactory factory) throws LdapException {
        LdapEntry rootDSE = SchemaFactory.getLdapEntry(factory, "", "(objectClass=*)", new String[]{SUBSCHEMA_SUBENTRY_ATTR_NAME});
        String entryDn = rootDSE.getAttribute(SUBSCHEMA_SUBENTRY_ATTR_NAME).getStringValue();
        return SchemaFactory.createSchema(SchemaFactory.getLdapEntry(factory, entryDn, "(objectClass=subSchema)", ReturnAttributes.ALL.value()));
    }

    public static Schema createSchema(ConnectionFactory factory, String entryDn) throws LdapException {
        return SchemaFactory.createSchema(SchemaFactory.getLdapEntry(factory, entryDn, "(objectClass=subSchema)", ReturnAttributes.ALL.value()));
    }

    public static Schema createSchema(LdapEntry schemaEntry) {
        LdapAttribute ocAttr;
        LdapAttribute nfAttr;
        LdapAttribute mruAttr;
        LdapAttribute mrAttr;
        LdapAttribute sAttr;
        LdapAttribute dsrAttr;
        LdapAttribute dcrAttr;
        if (schemaEntry == null) {
            throw new IllegalArgumentException("Schema entry cannot be null");
        }
        Schema schema = new Schema();
        LdapAttribute atAttr = schemaEntry.getAttribute(ATTRIBUTE_TYPES_ATTR_NAME);
        if (atAttr != null) {
            schema.setAttributeTypes(atAttr.getValues(new AttributeTypeValueTranscoder()));
        }
        if ((dcrAttr = schemaEntry.getAttribute(DIT_CONTENT_RULES_ATTR_NAME)) != null) {
            schema.setDitContentRules(dcrAttr.getValues(new DITContentRuleValueTranscoder()));
        }
        if ((dsrAttr = schemaEntry.getAttribute(DIT_STRUCTURE_RULES_ATTR_NAME)) != null) {
            schema.setDitStructureRules(dsrAttr.getValues(new DITStructureRuleValueTranscoder()));
        }
        if ((sAttr = schemaEntry.getAttribute(LDAP_SYNTAXES_ATTR_NAME)) != null) {
            schema.setSyntaxes(sAttr.getValues(new SyntaxValueTranscoder()));
        }
        if ((mrAttr = schemaEntry.getAttribute(MATCHING_RULES_ATTR_NAME)) != null) {
            schema.setMatchingRules(mrAttr.getValues(new MatchingRuleValueTranscoder()));
        }
        if ((mruAttr = schemaEntry.getAttribute(MATCHING_RULE_USE_ATTR_NAME)) != null) {
            schema.setMatchingRuleUses(mruAttr.getValues(new MatchingRuleUseValueTranscoder()));
        }
        if ((nfAttr = schemaEntry.getAttribute(NAME_FORMS_ATTR_NAME)) != null) {
            schema.setNameForms(nfAttr.getValues(new NameFormValueTranscoder()));
        }
        if ((ocAttr = schemaEntry.getAttribute(OBJECT_CLASS_ATTR_NAME)) != null) {
            schema.setObjectClasses(ocAttr.getValues(new ObjectClassValueTranscoder()));
        }
        return schema;
    }

    protected static LdapEntry getLdapEntry(ConnectionFactory factory, String dn, String filter, String[] retAttrs) throws LdapException {
        SearchExecutor executor = new SearchExecutor();
        executor.setBaseDn(dn);
        executor.setSearchScope(SearchScope.OBJECT);
        executor.setReturnAttributes(retAttrs);
        SearchResult result = executor.search(factory, filter).getResult();
        return result.getEntry();
    }
}

