/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.common.UUIDs;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.jobscheduler.spi.schedule.ScheduleParser;
import org.opensearch.securityanalytics.threatIntel.common.RefreshType;
import org.opensearch.securityanalytics.threatIntel.common.SourceConfigType;
import org.opensearch.securityanalytics.threatIntel.common.TIFJobState;
import org.opensearch.securityanalytics.threatIntel.model.IocSchema;
import org.opensearch.securityanalytics.threatIntel.model.IocUploadSource;
import org.opensearch.securityanalytics.threatIntel.model.S3Source;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfig;
import org.opensearch.securityanalytics.threatIntel.model.Source;
import org.opensearch.securityanalytics.threatIntel.sacommons.TIFSourceConfigDto;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public class SATIFSourceConfigDto
implements Writeable,
ToXContentObject,
TIFSourceConfigDto {
    private static final Logger log = LogManager.getLogger(SATIFSourceConfigDto.class);
    public static final String SOURCE_CONFIG_FIELD = "source_config";
    public static final String NO_ID = "";
    public static final Long NO_VERSION = 1L;
    public static final String VERSION_FIELD = "version";
    public static final String NAME_FIELD = "name";
    public static final String FORMAT_FIELD = "format";
    public static final String TYPE_FIELD = "type";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String CREATED_BY_USER_FIELD = "created_by_user";
    public static final String CREATED_AT_FIELD = "created_at";
    public static final String SOURCE_FIELD = "source";
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    public static final String ENABLED_FOR_SCAN_FIELD = "enabled_for_scan";
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String SCHEDULE_FIELD = "schedule";
    public static final String STATE_FIELD = "state";
    public static final String REFRESH_TYPE_FIELD = "refresh_type";
    public static final String LAST_REFRESHED_TIME_FIELD = "last_refreshed_time";
    public static final String LAST_REFRESHED_USER_FIELD = "last_refreshed_user";
    public static final String ENABLED_FIELD = "enabled";
    public static final String IOC_TYPES_FIELD = "ioc_types";
    public static final String IOC_SCHEMA_FIELD = "ioc_schema";
    private String id;
    private Long version;
    private String name;
    private String format;
    private SourceConfigType type;
    private String description;
    private User createdByUser;
    private Instant createdAt;
    private Source source;
    private Instant enabledTime;
    private Instant lastUpdateTime;
    private Schedule schedule;
    private TIFJobState state;
    public RefreshType refreshType;
    public Instant lastRefreshedTime;
    public User lastRefreshedUser;
    private Boolean isEnabled;
    private List<String> iocTypes;
    private final boolean enabledForScan;
    private final IocSchema iocSchema;

    public SATIFSourceConfigDto(SATIFSourceConfig saTifSourceConfig) {
        this.id = saTifSourceConfig.getId();
        this.version = saTifSourceConfig.getVersion();
        this.name = saTifSourceConfig.getName();
        this.format = saTifSourceConfig.getFormat();
        this.type = saTifSourceConfig.getType();
        this.description = saTifSourceConfig.getDescription();
        this.createdByUser = saTifSourceConfig.getCreatedByUser();
        this.createdAt = saTifSourceConfig.getCreatedAt();
        this.source = saTifSourceConfig.getSource();
        this.enabledTime = saTifSourceConfig.getEnabledTime();
        this.lastUpdateTime = saTifSourceConfig.getLastUpdateTime();
        this.schedule = saTifSourceConfig.getSchedule();
        this.state = saTifSourceConfig.getState();
        this.refreshType = saTifSourceConfig.getRefreshType();
        this.lastRefreshedTime = saTifSourceConfig.getLastRefreshedTime();
        this.lastRefreshedUser = saTifSourceConfig.getLastRefreshedUser();
        this.isEnabled = saTifSourceConfig.isEnabled();
        this.iocTypes = saTifSourceConfig.getIocTypes();
        this.enabledForScan = saTifSourceConfig.isEnabledForScan();
        this.iocSchema = saTifSourceConfig.getIocSchema();
    }

    public SATIFSourceConfigDto(String id, Long version, String name, String format, SourceConfigType type, String description, User createdByUser, Instant createdAt, Source source, Instant enabledTime, Instant lastUpdateTime, Schedule schedule, TIFJobState state, RefreshType refreshType, Instant lastRefreshedTime, User lastRefreshedUser, boolean isEnabled, List<String> iocTypes, boolean enabledForScan, IocSchema iocSchema) {
        this.id = id == null ? UUIDs.base64UUID() : id;
        this.version = version != null ? version : NO_VERSION;
        this.name = name;
        this.format = format;
        this.type = type;
        this.description = description;
        this.createdByUser = createdByUser;
        this.source = source;
        this.createdAt = createdAt != null ? createdAt : Instant.now();
        this.iocSchema = iocSchema;
        this.enabledTime = isEnabled && enabledTime == null ? Instant.now() : (!isEnabled ? null : enabledTime);
        this.lastUpdateTime = lastUpdateTime != null ? lastUpdateTime : Instant.now();
        this.schedule = schedule;
        this.state = state != null ? state : TIFJobState.CREATING;
        this.refreshType = refreshType != null ? refreshType : RefreshType.FULL;
        this.lastRefreshedTime = lastRefreshedTime;
        this.lastRefreshedUser = lastRefreshedUser;
        this.isEnabled = isEnabled;
        this.iocTypes = iocTypes;
        this.enabledForScan = enabledForScan;
    }

    public SATIFSourceConfigDto(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readLong(), sin.readString(), sin.readString(), (SourceConfigType)sin.readEnum(SourceConfigType.class), sin.readOptionalString(), sin.readBoolean() ? new User(sin) : null, sin.readInstant(), Source.readFrom(sin), sin.readOptionalInstant(), sin.readInstant(), (Schedule)(sin.readBoolean() ? new IntervalSchedule(sin) : null), (TIFJobState)sin.readEnum(TIFJobState.class), (RefreshType)sin.readEnum(RefreshType.class), sin.readOptionalInstant(), sin.readBoolean() ? new User(sin) : null, sin.readBoolean(), sin.readStringList(), sin.readBoolean(), sin.readBoolean() ? IocSchema.readFrom(sin) : null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.version.longValue());
        out.writeString(this.name);
        out.writeString(this.format);
        out.writeEnum((Enum)this.type);
        out.writeOptionalString(this.description);
        out.writeBoolean(this.createdByUser != null);
        if (this.createdByUser != null) {
            this.createdByUser.writeTo(out);
        }
        out.writeInstant(this.createdAt);
        if (this.source instanceof S3Source) {
            out.writeEnum((Enum)Source.Type.S3);
        } else if (this.source instanceof IocUploadSource) {
            out.writeEnum((Enum)Source.Type.IOC_UPLOAD);
        }
        this.source.writeTo(out);
        out.writeOptionalInstant(this.enabledTime);
        out.writeInstant(this.lastUpdateTime);
        out.writeBoolean(this.schedule != null);
        if (this.schedule != null) {
            this.schedule.writeTo(out);
        }
        out.writeEnum((Enum)this.state);
        out.writeEnum((Enum)this.refreshType);
        out.writeOptionalInstant(this.lastRefreshedTime);
        out.writeBoolean(this.lastRefreshedUser != null);
        if (this.lastRefreshedUser != null) {
            this.lastRefreshedUser.writeTo(out);
        }
        out.writeBoolean(this.isEnabled.booleanValue());
        out.writeStringCollection(this.iocTypes);
        out.writeBoolean(this.enabledForScan);
        out.writeBoolean(this.iocSchema != null);
        if (this.iocSchema != null) {
            out.writeBoolean(true);
            this.iocSchema.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerXcontent(builder);
        builder.endObject();
        return builder;
    }

    public XContentBuilder innerXcontent(XContentBuilder builder) throws IOException {
        builder.startObject(SOURCE_CONFIG_FIELD);
        builder.field(NAME_FIELD, this.name).field(FORMAT_FIELD, this.format).field(TYPE_FIELD, this.type.name()).field(DESCRIPTION_FIELD, this.description);
        if (this.createdByUser == null) {
            builder.nullField(CREATED_BY_USER_FIELD);
        } else {
            builder.field(CREATED_BY_USER_FIELD, (ToXContent)this.createdByUser);
        }
        if (this.source == null) {
            builder.nullField(SOURCE_FIELD);
        } else {
            builder.field(SOURCE_FIELD, (Object)this.source);
        }
        if (this.iocSchema == null) {
            builder.nullField(IOC_SCHEMA_FIELD);
        } else {
            builder.field(IOC_SCHEMA_FIELD, (ToXContent)this.iocSchema);
        }
        if (this.createdAt == null) {
            builder.nullField(CREATED_AT_FIELD);
        } else {
            builder.timeField(CREATED_AT_FIELD, String.format(Locale.getDefault(), "%s_in_millis", CREATED_AT_FIELD), this.createdAt.toEpochMilli());
        }
        if (this.enabledTime == null) {
            builder.nullField(ENABLED_TIME_FIELD);
        } else {
            builder.timeField(ENABLED_TIME_FIELD, String.format(Locale.getDefault(), "%s_in_millis", ENABLED_TIME_FIELD), this.enabledTime.toEpochMilli());
        }
        if (this.lastUpdateTime == null) {
            builder.nullField(LAST_UPDATE_TIME_FIELD);
        } else {
            builder.timeField(LAST_UPDATE_TIME_FIELD, String.format(Locale.getDefault(), "%s_in_millis", LAST_UPDATE_TIME_FIELD), this.lastUpdateTime.toEpochMilli());
        }
        if (this.schedule == null) {
            builder.nullField(SCHEDULE_FIELD);
        } else {
            builder.field(SCHEDULE_FIELD, (ToXContent)this.schedule);
        }
        builder.field(STATE_FIELD, this.state.name());
        builder.field(REFRESH_TYPE_FIELD, this.refreshType.name());
        if (this.lastRefreshedTime == null) {
            builder.nullField(LAST_REFRESHED_TIME_FIELD);
        } else {
            builder.timeField(LAST_REFRESHED_TIME_FIELD, String.format(Locale.getDefault(), "%s_in_millis", LAST_REFRESHED_TIME_FIELD), this.lastRefreshedTime.toEpochMilli());
        }
        if (this.lastRefreshedUser == null) {
            builder.nullField(LAST_REFRESHED_USER_FIELD);
        } else {
            builder.field(LAST_REFRESHED_USER_FIELD, (ToXContent)this.lastRefreshedUser);
        }
        builder.field(ENABLED_FIELD, this.isEnabled);
        builder.field(ENABLED_FOR_SCAN_FIELD, this.enabledForScan);
        builder.field(IOC_TYPES_FIELD, this.iocTypes);
        builder.endObject();
        return builder;
    }

    public static SATIFSourceConfigDto docParse(XContentParser xcp, String id, Long version) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        SATIFSourceConfigDto saTifSourceConfigDto = SATIFSourceConfigDto.parse(xcp, id, version);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        saTifSourceConfigDto.setId(id);
        saTifSourceConfigDto.setVersion(version);
        return saTifSourceConfigDto;
    }

    public static SATIFSourceConfigDto parse(XContentParser xcp, String id, Long version) throws IOException {
        if (version == null) {
            version = NO_VERSION;
        }
        String name = null;
        String format = null;
        SourceConfigType sourceConfigType = null;
        String description = null;
        User createdByUser = null;
        Instant createdAt = null;
        Source source = null;
        Instant enabledTime = null;
        Instant lastUpdateTime = null;
        Schedule schedule = null;
        TIFJobState state = null;
        RefreshType refreshType = null;
        Instant lastRefreshedTime = null;
        User lastRefreshedUser = null;
        boolean isEnabled = true;
        ArrayList<String> iocTypes = new ArrayList<String>();
        boolean enabledForScan = true;
        IocSchema iocSchema = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block42: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "source_config": {
                    continue block42;
                }
                case "name": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        name = null;
                        continue block42;
                    }
                    name = xcp.text();
                    continue block42;
                }
                case "format": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        format = null;
                        continue block42;
                    }
                    format = xcp.text();
                    continue block42;
                }
                case "type": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        sourceConfigType = null;
                        continue block42;
                    }
                    sourceConfigType = SATIFSourceConfigDto.toSourceConfigType(xcp.text());
                    continue block42;
                }
                case "description": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        description = null;
                        continue block42;
                    }
                    description = xcp.text();
                    continue block42;
                }
                case "created_by_user": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        createdByUser = null;
                        continue block42;
                    }
                    createdByUser = User.parse((XContentParser)xcp);
                    continue block42;
                }
                case "created_at": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        createdAt = null;
                        continue block42;
                    }
                    if (xcp.currentToken().isValue()) {
                        createdAt = Instant.ofEpochMilli(xcp.longValue());
                        continue block42;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    createdAt = null;
                    continue block42;
                }
                case "source": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        source = null;
                        continue block42;
                    }
                    source = Source.parse(xcp);
                    continue block42;
                }
                case "ioc_schema": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        iocSchema = null;
                        continue block42;
                    }
                    iocSchema = IocSchema.parse(xcp);
                    continue block42;
                }
                case "enabled_time": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        enabledTime = null;
                        continue block42;
                    }
                    if (xcp.currentToken().isValue()) {
                        enabledTime = Instant.ofEpochMilli(xcp.longValue());
                        continue block42;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    enabledTime = null;
                    continue block42;
                }
                case "last_update_time": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        lastUpdateTime = null;
                        continue block42;
                    }
                    if (xcp.currentToken().isValue()) {
                        lastUpdateTime = Instant.ofEpochMilli(xcp.longValue());
                        continue block42;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    lastUpdateTime = null;
                    continue block42;
                }
                case "schedule": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        schedule = null;
                        continue block42;
                    }
                    schedule = ScheduleParser.parse((XContentParser)xcp);
                    continue block42;
                }
                case "state": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        state = TIFJobState.CREATING;
                        continue block42;
                    }
                    state = SATIFSourceConfigDto.toState(xcp.text());
                    continue block42;
                }
                case "refresh_type": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        refreshType = null;
                        continue block42;
                    }
                    refreshType = SATIFSourceConfigDto.toRefreshType(xcp.text());
                    continue block42;
                }
                case "last_refreshed_time": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        lastRefreshedTime = null;
                        continue block42;
                    }
                    if (xcp.currentToken().isValue()) {
                        lastRefreshedTime = Instant.ofEpochMilli(xcp.longValue());
                        continue block42;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    lastRefreshedTime = null;
                    continue block42;
                }
                case "last_refreshed_user": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        lastRefreshedUser = null;
                        continue block42;
                    }
                    lastRefreshedUser = User.parse((XContentParser)xcp);
                    continue block42;
                }
                case "enabled": {
                    isEnabled = xcp.booleanValue();
                    continue block42;
                }
                case "enabled_for_scan": {
                    enabledForScan = xcp.booleanValue();
                    continue block42;
                }
                case "ioc_types": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        iocTypes.add(xcp.text());
                    }
                    continue block42;
                }
            }
            xcp.skipChildren();
        }
        if (isEnabled && enabledTime == null) {
            enabledTime = Instant.now();
        } else if (!isEnabled) {
            enabledTime = null;
        }
        return new SATIFSourceConfigDto(id, version, name, format, sourceConfigType, description, createdByUser, createdAt != null ? createdAt : Instant.now(), source, enabledTime, lastUpdateTime != null ? lastUpdateTime : Instant.now(), schedule, state, refreshType, lastRefreshedTime, lastRefreshedUser, isEnabled, iocTypes, enabledForScan, iocSchema);
    }

    public static TIFJobState toState(String stateName) {
        try {
            return TIFJobState.valueOf(stateName);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid state, cannot be parsed.", (Throwable)e);
            throw SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("Invalid state, cannot be parsed.", RestStatus.BAD_REQUEST, new Object[0]));
        }
    }

    public static SourceConfigType toSourceConfigType(String type) {
        try {
            return SourceConfigType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid source config type, cannot be parsed.", (Throwable)e);
            throw SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("Invalid source config type, cannot be parsed.", RestStatus.BAD_REQUEST, new Object[0]));
        }
    }

    public static RefreshType toRefreshType(String stateName) {
        try {
            return RefreshType.valueOf(stateName);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid refresh type, cannot be parsed.", (Throwable)e);
            throw SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("Invalid refresh type, cannot be parsed.", RestStatus.BAD_REQUEST, new Object[0]));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public SourceConfigType getType() {
        return this.type;
    }

    @Override
    public void setType(SourceConfigType type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public User getCreatedByUser() {
        return this.createdByUser;
    }

    @Override
    public void setCreatedByUser(User createdByUser) {
        this.createdByUser = createdByUser;
    }

    @Override
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    @Override
    public Instant getEnabledTime() {
        return this.enabledTime;
    }

    @Override
    public void setEnabledTime(Instant enabledTime) {
        this.enabledTime = enabledTime;
    }

    @Override
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Override
    public Schedule getSchedule() {
        return this.schedule;
    }

    @Override
    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    @Override
    public TIFJobState getState() {
        return this.state;
    }

    @Override
    public void setState(TIFJobState previousState) {
        this.state = previousState;
    }

    public User getLastRefreshedUser() {
        return this.lastRefreshedUser;
    }

    public void setLastRefreshedUser(User lastRefreshedUser) {
        this.lastRefreshedUser = lastRefreshedUser;
    }

    public Instant getLastRefreshedTime() {
        return this.lastRefreshedTime;
    }

    public void setLastRefreshedTime(Instant lastRefreshedTime) {
        this.lastRefreshedTime = lastRefreshedTime;
    }

    public RefreshType getRefreshType() {
        return this.refreshType;
    }

    public void setRefreshType(RefreshType refreshType) {
        this.refreshType = refreshType;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public IocSchema getIocSchema() {
        return this.iocSchema;
    }

    @Override
    public void enable() {
        if (this.isEnabled.booleanValue()) {
            return;
        }
        this.enabledTime = Instant.now();
        this.isEnabled = true;
    }

    @Override
    public void disable() {
        this.enabledTime = null;
        this.isEnabled = false;
    }

    @Override
    public List<String> getIocTypes() {
        return this.iocTypes;
    }

    @Override
    public void setIocTypes(List<String> iocTypes) {
        this.iocTypes = iocTypes;
    }

    public static SATIFSourceConfigDto readFrom(StreamInput sin) throws IOException {
        return new SATIFSourceConfigDto(sin);
    }

    public boolean isEnabledForScan() {
        return this.enabledForScan;
    }
}

