/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model.threatintel;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class IocWithFeeds
implements Writeable,
ToXContent {
    private static final String FEED_ID_FIELD = "feed_id";
    private static final String FEED_NAME_FIELD = "feed_name";
    private static final String IOC_ID_FIELD = "ioc_id";
    private static final String INDEX_FIELD = "index";
    private final String feedId;
    private final String feedName;
    private final String iocId;
    private final String index;

    public IocWithFeeds(String iocId, String feedId, String feedName, String index) {
        this.iocId = iocId;
        this.feedId = feedId;
        this.feedName = feedName;
        this.index = index;
    }

    public IocWithFeeds(StreamInput sin) throws IOException {
        this.iocId = sin.readString();
        this.feedId = sin.readString();
        this.feedName = sin.readString();
        this.index = sin.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.iocId);
        out.writeString(this.feedId);
        out.writeString(this.feedName);
        out.writeString(this.index);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(IOC_ID_FIELD, this.iocId).field(FEED_ID_FIELD, this.feedId).field(FEED_NAME_FIELD, this.feedName).field(INDEX_FIELD, this.index).endObject();
        return builder;
    }

    public Map<String, Object> asTemplateArg() {
        return Map.of(FEED_ID_FIELD, this.feedId, FEED_NAME_FIELD, this.feedId, IOC_ID_FIELD, this.iocId, INDEX_FIELD, this.index);
    }

    public String getIocId() {
        return this.iocId;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public String getIndex() {
        return this.index;
    }

    public static IocWithFeeds parse(XContentParser xcp) throws IOException {
        String iocId = null;
        String feedId = null;
        String feedName = null;
        String index = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block12: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "ioc_id": {
                    iocId = xcp.text();
                    continue block12;
                }
                case "feed_id": {
                    feedId = xcp.text();
                    continue block12;
                }
                case "feed_name": {
                    feedName = xcp.text();
                    continue block12;
                }
                case "index": {
                    index = xcp.text();
                    continue block12;
                }
            }
            xcp.skipChildren();
        }
        return new IocWithFeeds(iocId, feedId, feedName, index);
    }

    public static IocWithFeeds readFrom(StreamInput sin) throws IOException {
        return new IocWithFeeds(sin);
    }

    public int hashCode() {
        return Objects.hash(this.feedId, this.feedName, this.index, this.iocId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IocWithFeeds that = (IocWithFeeds)o;
        if (this.feedId != null ? !this.feedId.equals(that.feedId) : that.feedId != null) {
            return false;
        }
        if (this.iocId != null ? !this.iocId.equals(that.iocId) : that.iocId != null) {
            return false;
        }
        return this.index != null ? this.index.equals(that.index) : that.index == null;
    }

    public String toString() {
        return "IocWithFeeds{feedId='" + this.feedId + "'feedName='" + this.feedName + "', iocId='" + this.iocId + "', index='" + this.index + "'}";
    }
}

