/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.profile;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.profile.MLProfileInput;

public class MLProfileRequest
extends BaseNodesRequest<MLProfileRequest> {
    private MLProfileInput mlProfileInput;
    private Set<String> hiddenModelIds = Collections.emptySet();

    public MLProfileRequest(StreamInput input) throws IOException {
        super(input);
        Version streamInputVersion = input.getVersion();
        this.mlProfileInput = new MLProfileInput(input);
        if (streamInputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            this.hiddenModelIds = input.readSet(StreamInput::readString);
        }
    }

    public MLProfileRequest(String[] nodeIds, MLProfileInput mlProfileInput) {
        super(nodeIds);
        this.mlProfileInput = mlProfileInput;
    }

    public void writeTo(StreamOutput output) throws IOException {
        Version streamOutputVersion = output.getVersion();
        super.writeTo(output);
        this.mlProfileInput.writeTo(output);
        if (streamOutputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            output.writeCollection(this.hiddenModelIds, StreamOutput::writeString);
        }
    }

    @Generated
    public MLProfileInput getMlProfileInput() {
        return this.mlProfileInput;
    }

    @Generated
    public Set<String> getHiddenModelIds() {
        return this.hiddenModelIds;
    }

    @Generated
    public void setHiddenModelIds(Set<String> hiddenModelIds) {
        this.hiddenModelIds = hiddenModelIds;
    }
}

