/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ubi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.io.Streams;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.transport.client.node.NodeClient;
import org.opensearch.ubi.UbiActionFilter;

public class UbiRestHandler
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(UbiRestHandler.class);
    public static final String INITIALIZE_URL = "/_plugins/ubi/initialize";

    public String getName() {
        return "User Behavior Insights";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, INITIALIZE_URL));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, final NodeClient client) throws IOException {
        if (request.path().equalsIgnoreCase(INITIALIZE_URL)) {
            if (request.method().equals((Object)RestRequest.Method.POST)) {
                IndicesExistsRequest indicesExistsRequest = new IndicesExistsRequest(new String[]{"ubi_events", "ubi_queries"});
                client.admin().indices().exists(indicesExistsRequest, (ActionListener)new ActionListener<IndicesExistsResponse>(this){

                    public void onResponse(IndicesExistsResponse indicesExistsResponse) {
                        if (!indicesExistsResponse.isExists()) {
                            Settings indexSettings = Settings.builder().put(IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.getKey(), 1).put(IndexMetadata.INDEX_AUTO_EXPAND_REPLICAS_SETTING.getKey(), "0-2").put("index.priority", Integer.MAX_VALUE).build();
                            CreateIndexRequest createEventsIndexRequest = new CreateIndexRequest("ubi_events").mapping(UbiRestHandler.getResourceFile("/events-mapping.json")).settings(indexSettings);
                            client.admin().indices().create(createEventsIndexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(this){

                                public void onResponse(CreateIndexResponse createIndexResponse) {
                                    LOGGER.debug("ubi_queries index created.");
                                }

                                public void onFailure(Exception e) {
                                    LOGGER.error("Unable to create ubi_queries index", (Throwable)e);
                                }
                            });
                            CreateIndexRequest createQueriesIndexRequest = new CreateIndexRequest("ubi_queries").mapping(UbiRestHandler.getResourceFile("/queries-mapping.json")).settings(indexSettings);
                            client.admin().indices().create(createQueriesIndexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(this){

                                public void onResponse(CreateIndexResponse createIndexResponse) {
                                    LOGGER.debug("ubi_events index created.");
                                }

                                public void onFailure(Exception e) {
                                    LOGGER.error("Unable to create ubi_events index", (Throwable)e);
                                }
                            });
                        } else {
                            LOGGER.debug("UBI indexes already exist.");
                        }
                    }

                    public void onFailure(Exception ex) {
                        LOGGER.error("Error determining if UBI indexes exist.", (Throwable)ex);
                    }
                });
                return restChannel -> restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "{\"message\": \"UBI indexes created.\"}"));
            }
            return restChannel -> restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, "{\"error\": \"" + String.valueOf(request.method()) + " is not allowed.\"}"));
        }
        return restChannel -> restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NOT_FOUND, "{\"error\": \"" + request.path() + " was not found.\"}"));
    }

    private static String getResourceFile(String fileName) {
        String string;
        block8: {
            InputStream is = UbiActionFilter.class.getResourceAsStream(fileName);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Streams.copy((InputStream)is, (OutputStream)out);
                string = out.toString(StandardCharsets.UTF_8);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to get mapping from resource [" + fileName + "]", e);
                }
            }
            is.close();
        }
        return string;
    }
}

