/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.pagination.ColorProfile;
import org.apache.fop.fo.pagination.Declarations;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.Property;

class ICCColorFunction
extends FunctionBase {
    ICCColorFunction() {
    }

    public int nbArgs() {
        return -4;
    }

    public Property eval(Property[] args, PropertyInfo pInfo) throws PropertyException {
        StringBuffer sb = new StringBuffer();
        String colorProfileName = args[3].getString();
        Declarations decls = pInfo.getFO().getRoot().getDeclarations();
        ColorProfile cp = decls.getColorProfile(colorProfileName);
        if (cp == null) {
            PropertyException pe = new PropertyException("The " + colorProfileName + " color profile was not declared");
            pe.setPropertyInfo(pInfo);
            throw pe;
        }
        String src = cp.getSrc();
        sb.append("fop-rgb-icc(" + args[0]);
        for (int ix = 1; ix < args.length; ++ix) {
            if (ix == 3) {
                sb.append("," + colorProfileName);
                sb.append(",\"" + src + "\"");
                continue;
            }
            sb.append("," + args[ix]);
        }
        sb.append(")");
        FOUserAgent ua = pInfo == null ? null : (pInfo.getFO() == null ? null : pInfo.getFO().getUserAgent());
        return new ColorProperty(ua, sb.toString());
    }
}

