/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.hll;

import org.apache.solr.util.hll.IWordDeserializer;

class BigEndianAscendingWordDeserializer
implements IWordDeserializer {
    private static final int BITS_PER_BYTE = 8;
    private static final long BYTE_MASK = 255L;
    private final int wordLength;
    private final byte[] bytes;
    private final int bytePadding;
    private final int wordCount;
    private int currentWordIndex;

    public BigEndianAscendingWordDeserializer(int wordLength, int bytePadding, byte[] bytes) {
        if (wordLength < 1 || wordLength > 64) {
            throw new IllegalArgumentException("Word length must be >= 1 and <= 64. (was: " + wordLength + ")");
        }
        if (bytePadding < 0) {
            throw new IllegalArgumentException("Byte padding must be >= zero. (was: " + bytePadding + ")");
        }
        this.wordLength = wordLength;
        this.bytes = bytes;
        this.bytePadding = bytePadding;
        int dataBytes = bytes.length - bytePadding;
        long dataBits = (long)dataBytes * 8L;
        this.wordCount = (int)(dataBits / (long)wordLength);
        this.currentWordIndex = 0;
    }

    @Override
    public long readWord() {
        long word = this.readWord(this.currentWordIndex);
        ++this.currentWordIndex;
        return word;
    }

    private long readWord(int position) {
        if (position < 0) {
            throw new ArrayIndexOutOfBoundsException(position);
        }
        long firstBitIndex = (long)position * (long)this.wordLength;
        int firstByteIndex = this.bytePadding + (int)(firstBitIndex / 8L);
        int firstByteSkipBits = (int)(firstBitIndex % 8L);
        long lastBitIndex = firstBitIndex + (long)this.wordLength - 1L;
        int lastByteIndex = this.bytePadding + (int)(lastBitIndex / 8L);
        int bitsAfterByteBoundary = (int)((lastBitIndex + 1L) % 8L);
        int lastByteBitsToConsume = bitsAfterByteBoundary == 0 ? 8 : bitsAfterByteBoundary;
        if (lastByteIndex >= this.bytes.length) {
            throw new ArrayIndexOutOfBoundsException("Word out of bounds of backing array.");
        }
        long value = 0L;
        int bitsRemainingInFirstByte = 8 - firstByteSkipBits;
        int bitsToConsumeInFirstByte = Math.min(bitsRemainingInFirstByte, this.wordLength);
        long firstByte = this.bytes[firstByteIndex];
        long firstByteMask = (1L << bitsRemainingInFirstByte) - 1L;
        firstByte &= firstByteMask;
        value |= (firstByte >>>= bitsRemainingInFirstByte - bitsToConsumeInFirstByte);
        if (firstByteIndex == lastByteIndex) {
            return value;
        }
        int middleByteCount = lastByteIndex - firstByteIndex - 1;
        for (int i = 0; i < middleByteCount; ++i) {
            long middleByte = (long)this.bytes[firstByteIndex + i + 1] & 0xFFL;
            value <<= 8;
            value |= middleByte;
        }
        long lastByte = (long)this.bytes[lastByteIndex] & 0xFFL;
        value <<= lastByteBitsToConsume;
        return value |= (lastByte >>= 8 - lastByteBitsToConsume);
    }

    @Override
    public int totalWordCount() {
        return this.wordCount;
    }
}

