/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.common.util.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String MODULES_FOLDER_NAME = "modules";
    private static final Pattern validModNamesPattern = Pattern.compile("[\\w\\d-_]+");

    public static Path getModuleLibPath(Path solrInstallDirPath, String moduleName) {
        return ModuleUtils.getModulesPath(solrInstallDirPath).resolve(moduleName).resolve("lib");
    }

    static Set<String> resolveFromSyspropOrEnv() {
        return Set.copyOf(EnvUtils.getPropertyAsList((String)"solr.modules", Collections.emptyList()));
    }

    public static boolean moduleExists(Path solrInstallDirPath, String moduleName) {
        if (!ModuleUtils.isValidName(moduleName)) {
            return false;
        }
        Path modPath = ModuleUtils.getModulesPath(solrInstallDirPath).resolve(moduleName);
        return Files.isDirectory(modPath, new LinkOption[0]);
    }

    public static Set<String> listAvailableModules(Path solrInstallDirPath) {
        Set<String> set;
        block8: {
            Stream<Path> moduleFilesStream = Files.list(ModuleUtils.getModulesPath(solrInstallDirPath));
            try {
                set = moduleFilesStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(p -> p.getFileName().toString()).collect(Collectors.toSet());
                if (moduleFilesStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (moduleFilesStream != null) {
                        try {
                            moduleFilesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn("Found no modules in {}", (Object)ModuleUtils.getModulesPath(solrInstallDirPath), (Object)e);
                    return Collections.emptySet();
                }
            }
            moduleFilesStream.close();
        }
        return set;
    }

    public static Collection<String> resolveModulesFromStringOrSyspropOrEnv(String modulesFromString) {
        Collection<String> moduleNames = modulesFromString != null && !modulesFromString.isBlank() ? StrUtils.splitSmart((String)modulesFromString, (char)',', (boolean)true) : ModuleUtils.resolveFromSyspropOrEnv();
        return moduleNames.stream().map(String::trim).collect(Collectors.toSet());
    }

    public static boolean isValidName(String moduleName) {
        return validModNamesPattern.matcher(moduleName).matches();
    }

    public static Path getModulesPath(Path solrInstallDirPath) {
        return solrInstallDirPath.resolve(MODULES_FOLDER_NAME);
    }
}

