/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import org.apache.solr.metrics.prometheus.SolrMetric;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.jvm.SolrJvmMetric;

public class SolrJvmGcMetrics
extends SolrJvmMetric {
    public static final String JVM_GC = "solr_metrics_jvm_gc";
    public static final String JVM_GC_SECONDS = "solr_metrics_jvm_gc_seconds";

    public SolrJvmGcMetrics(Metric dropwizardMetric, String metricName) {
        super(dropwizardMetric, metricName);
    }

    @Override
    public SolrMetric parseLabels() {
        String[] parsedMetric = this.metricName.split("\\.");
        this.labels.put("item", parsedMetric[1]);
        return this;
    }

    @Override
    public void toPrometheus(SolrPrometheusFormatter formatter) {
        if (this.metricName.endsWith(".count")) {
            formatter.exportGauge(JVM_GC, (Gauge)this.dropwizardMetric, this.getLabels());
        } else if (this.metricName.endsWith(".time")) {
            formatter.exportGauge(JVM_GC_SECONDS, (Gauge)this.dropwizardMetric, this.getLabels());
        }
    }
}

