/*
 * Decompiled with CFR 0.152.
 */
package com.knuddels.jtokkit;

import java.util.Arrays;

class ByteArrayWrapper {
    private final byte[] array;

    ByteArrayWrapper(byte[] array) {
        this.array = array;
    }

    int length() {
        return this.array.length;
    }

    ByteArrayWrapper getBytesBetween(int startIndex, int endIndex) {
        if (startIndex < 0 || startIndex >= this.array.length) {
            throw new IndexOutOfBoundsException("startIndex out of bounds: " + startIndex + " (" + this + ")");
        }
        if (endIndex < 0 || endIndex > this.array.length) {
            throw new IndexOutOfBoundsException("endIndex out of bounds: " + endIndex + " (" + this + ")");
        }
        if (startIndex >= endIndex) {
            throw new IllegalArgumentException("startIndex must be less than endIndex: " + startIndex + " >= " + endIndex);
        }
        int length = endIndex - startIndex;
        byte[] result = new byte[length];
        System.arraycopy(this.array, startIndex, result, 0, length);
        return new ByteArrayWrapper(result);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ByteArrayWrapper that = (ByteArrayWrapper)other;
        return Arrays.equals(this.array, that.array);
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

