/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLDecoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.SwingUtilities;
import org.netbeans.modules.web.monitor.client.Controller;
import org.netbeans.modules.web.monitor.client.MonitorAction;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public class PutTransaction
extends HttpServlet {
    private static FileObject currDir = null;
    private static boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String id;
        if (debug) {
            this.log("doPost");
        }
        if (currDir == null) {
            try {
                currDir = Controller.getCurrDir();
            }
            catch (FileNotFoundException ex) {
                if (debug) {
                    this.log("Couldn't write the transaction data");
                }
                return;
            }
        }
        if ((id = URLDecoder.decode(req.getQueryString(), "UTF-8")) == null || id.length() == 0) {
            if (debug) {
                this.log("Bad request, exiting...");
            }
            return;
        }
        id = id.substring(0, id.indexOf("|"));
        if (debug) {
            this.log(" Trying to add the transaction");
        }
        FileObject fo = null;
        try {
            if (debug) {
                this.log(" Before creating the file");
            }
            fo = currDir.createData(id, "xml");
            if (debug) {
                this.log(" After creating the file");
            }
        }
        catch (IOException ioex) {
            if (debug) {
                this.log(" Could not create the file, exiting...");
            }
            return;
        }
        FileLock lock = null;
        try {
            lock = fo.lock();
            if (debug) {
                this.log(" Got the lock");
            }
        }
        catch (FileAlreadyLockedException falex) {
            if (debug) {
                this.log(" Couldn't get a file lock, exiting...");
            }
            return;
        }
        boolean success = false;
        try {
            try (PrintWriter fout = new PrintWriter(fo.getOutputStream(lock));
                 InputStreamReader isr = new InputStreamReader((InputStream)req.getInputStream());){
                int numChars;
                char[] charBuf = new char[4096];
                while ((numChars = isr.read(charBuf, 0, 4096)) != -1) {
                    fout.write(charBuf, 0, numChars);
                }
            }
            success = true;
            if (debug) {
                this.log("...success");
            }
        }
        catch (IOException ioex) {
            if (debug) {
                this.log("Failed to read/write the record:");
                this.log(ioex);
            }
        }
        finally {
            lock.releaseLock();
            try {
                res.setContentType("text/plain");
                try (PrintWriter out = res.getWriter();){
                    out.println("ACK");
                }
            }
            catch (Exception out) {}
        }
        final boolean success2 = success;
        final String id2 = id;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (success2) {
                    MonitorAction.addTransaction(id2);
                }
            }
        });
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter out;
        block5: {
            if (debug) {
                this.log("doGet");
            }
            out = res.getWriter();
            try {
                out.println("Shouldn't use GET for this!");
            }
            catch (Exception e) {
                if (!debug) break block5;
                this.log(e.getMessage());
            }
        }
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(ServletConfig servletConfig) {
        if (debug) {
            this.log("init");
        }
    }

    public void log(String msg) {
        System.out.println("PutTransaction::" + msg);
    }

    public void log(Throwable t) {
        this.log(PutTransaction.getStackTrace(t));
    }

    public static String getStackTrace(Throwable t) {
        String stackTrace = null;
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            sw.close();
            stackTrace = sw.getBuffer().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stackTrace;
    }
}

