/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.spi.RemoteFileSystem;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;
import org.openide.util.NbCollections;

final class HudsonRemoteFileSystem
extends RemoteFileSystem
implements AbstractFileSystem.Attr,
AbstractFileSystem.Change,
AbstractFileSystem.List,
AbstractFileSystem.Info {
    private static final Logger LOG = Logger.getLogger(HudsonRemoteFileSystem.class.getName());
    private static final int TIMEOUT = 10000;
    private final URL baseURL;
    private final String displayName;
    private final HudsonJob job;
    private final Set<String> nonDirs = new HashSet<String>();
    private final Map<String, Long> lastModified = new HashMap<String, Long>();
    private final Map<String, Integer> size = new HashMap<String, Integer>();
    private final Map<String, byte[]> headers = new HashMap<String, byte[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HudsonRemoteFileSystem(URL baseURL, String displayName, HudsonJob job) {
        this.baseURL = baseURL;
        this.displayName = displayName;
        this.job = job;
        this.attr = this;
        this.change = this;
        this.list = this;
        this.info = this;
        Class<Mapper> clazz = Mapper.class;
        synchronized (Mapper.class) {
            if (Mapper.workspaces == null) {
                Mapper.workspaces = Collections.newSetFromMap(new WeakHashMap());
            }
            Mapper.workspaces.add(this);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    HudsonRemoteFileSystem(HudsonJob job) throws MalformedURLException {
        this(new URL(job.getUrl() + "ws/"), job.getDisplayName(), job);
    }

    HudsonRemoteFileSystem(HudsonJobBuild build) throws MalformedURLException {
        this(new URL(build.getUrl() + "artifact/"), build.getDisplayName(), build.getJob());
    }

    HudsonRemoteFileSystem(HudsonMavenModuleBuild module) throws MalformedURLException {
        this(new URL(module.getUrl() + "artifact/"), module.getBuildDisplayName(), module.getBuild().getJob());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshAll() {
        LOG.log(Level.FINE, "refreshing files in {0}", this.baseURL);
        Set<String> set = this.nonDirs;
        synchronized (set) {
            this.nonDirs.clear();
            this.lastModified.clear();
            this.size.clear();
            this.headers.clear();
        }
        for (FileObject f : NbCollections.iterable((Enumeration)this.existingFileObjects(this.getRoot()))) {
            if (Thread.interrupted()) {
                return;
            }
            LOG.log(Level.FINER, "  refreshing {0}", f.getPath());
            f.refresh();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] children(String f) {
        String fSlash = f.length() > 0 ? f + "/" : "";
        try {
            URL url = new URL(this.baseURL, Utilities.uriEncode(fSlash) + "*plain*");
            URLConnection conn = new ConnectionBuilder().job(this.job).url(url).timeout(10000).connection();
            String contentType = conn.getContentType();
            if (contentType == null || !contentType.startsWith("text/plain")) {
                LOG.log(Level.FINE, "non-plain dir listing: {0}", url);
                return new String[0];
            }
            ArrayList<String> kids = new ArrayList<String>();
            try (InputStream is = conn.getInputStream();){
                String line;
                BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((line = r.readLine()) != null) {
                    if (line.endsWith("/")) {
                        String n = line.substring(0, line.length() - 1);
                        kids.add(n);
                        continue;
                    }
                    kids.add(line);
                    Set<String> set = this.nonDirs;
                    synchronized (set) {
                        this.nonDirs.add(fSlash + line);
                    }
                }
            }
            LOG.log(Level.FINE, "children: {0} -> {1}", new Object[]{url, kids});
            return kids.toArray(new String[0]);
        }
        catch (IOException x) {
            LOG.log(Level.FINE, "cannot list children of {0} in {1}: {2}", new Object[]{f, this.baseURL, x});
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean folder(String name) {
        Set<String> set = this.nonDirs;
        synchronized (set) {
            return !this.nonDirs.contains(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLConnection connection(String name, boolean cacheMetadata) throws IOException {
        LOG.log(Level.FINE, "metadata in {0}: {1}", new Object[]{this.baseURL, name});
        URLConnection conn = new ConnectionBuilder().job(this.job).url(new URL(this.baseURL, Utilities.uriEncode(name))).timeout(10000).connection();
        if (cacheMetadata) {
            assert (Thread.holdsLock(this.nonDirs));
            this.lastModified.put(name, conn.getLastModified());
            int contentLength = conn.getContentLength();
            if (contentLength == -1) {
                LOG.warning("unknown content length for " + name + " in " + this.baseURL);
                this.size.put(name, 0);
            } else {
                this.size.put(name, contentLength);
            }
            if (contentLength >= 0) {
                byte[] buf = new byte[Math.min(contentLength, 8192)];
                try (InputStream is = conn.getInputStream();){
                    int p;
                    int read;
                    for (p = 0; p < buf.length && (read = is.read(buf, p, buf.length - p)) != -1; p += read) {
                    }
                    if (p == buf.length) {
                        this.headers.put(name, buf);
                    } else {
                        LOG.warning("incomplete read for " + name + " in " + this.baseURL + ": read up to " + p + " where reported length is " + contentLength);
                    }
                }
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date lastModified(String name) {
        Set<String> set = this.nonDirs;
        synchronized (set) {
            if (this.folder(name)) {
                return new Date(0L);
            }
            if (!this.lastModified.containsKey(name)) {
                try {
                    this.connection(name, true);
                }
                catch (IOException x) {
                    LOG.log(Level.FINE, "cannot get metadata for " + name + " in " + this.baseURL, x);
                    return new Date(0L);
                }
            }
            return new Date(this.lastModified.get(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size(String name) {
        Set<String> set = this.nonDirs;
        synchronized (set) {
            if (this.folder(name)) {
                return 0L;
            }
            if (!this.size.containsKey(name)) {
                try {
                    this.connection(name, true);
                }
                catch (IOException x) {
                    LOG.log(Level.FINE, "cannot get metadata for " + name + " in " + this.baseURL, x);
                    return 0L;
                }
            }
            return this.size.get(name).intValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream inputStream(final String name) throws FileNotFoundException {
        Set<String> set = this.nonDirs;
        synchronized (set) {
            final byte[] header = this.headers.get(name);
            if (header != null) {
                LOG.log(Level.FINE, "cached inputStream: {0}", name);
                if ((long)header.length == this.size(name)) {
                    return new ByteArrayInputStream(header);
                }
                class HeaderCachedInputStream
                extends InputStream {
                    int p;
                    InputStream delegate;

                    HeaderCachedInputStream() {
                    }

                    @Override
                    public int read() throws IOException {
                        if (this.delegate != null) {
                            return this.delegate.read();
                        }
                        if (this.p < header.length) {
                            return header[this.p++] & 0xFF;
                        }
                        if (this.delegate == null) {
                            LOG.log(Level.FINE, "uncached tail of inputStream: {0}", name);
                            this.delegate = HudsonRemoteFileSystem.this.inputStreamNoCache(name);
                            while (this.p-- > 0) {
                                if (this.delegate.read() != -1) continue;
                                throw new IOException("Premature EOF in " + name);
                            }
                        }
                        return this.delegate.read();
                    }

                    @Override
                    public void close() throws IOException {
                        if (this.delegate != null) {
                            this.delegate.close();
                        }
                    }

                    @Override
                    public int available() throws IOException {
                        if (this.delegate != null) {
                            return this.delegate.available();
                        }
                        return header.length - this.p;
                    }
                }
                return new HeaderCachedInputStream();
            }
            return this.inputStreamNoCache(name);
        }
    }

    private InputStream inputStreamNoCache(String name) throws FileNotFoundException {
        LOG.log(Level.FINE, "inputStream: {0}", name);
        try {
            return new BufferedInputStream(this.connection(name, false).getInputStream());
        }
        catch (IOException x) {
            throw (FileNotFoundException)new FileNotFoundException(x.getMessage()).initCause(x);
        }
    }

    public Object readAttribute(String name, String attrName) {
        if (attrName.equals("isRemoteAndSlow")) {
            return true;
        }
        return null;
    }

    public void writeAttribute(String name, String attrName, Object value) throws IOException {
        throw new IOException();
    }

    public Enumeration<String> attributes(String name) {
        return Enumerations.empty();
    }

    public void renameAttributes(String oldName, String newName) {
    }

    public void deleteAttributes(String name) {
    }

    public void createFolder(String name) throws IOException {
        throw new IOException();
    }

    public void createData(String name) throws IOException {
        throw new IOException();
    }

    public void rename(String oldName, String newName) throws IOException {
        throw new IOException();
    }

    public void delete(String name) throws IOException {
        throw new IOException();
    }

    public boolean readOnly(String name) {
        return true;
    }

    public String mimeType(String name) {
        return null;
    }

    public OutputStream outputStream(String name) throws IOException {
        throw new IOException();
    }

    public void lock(String name) throws IOException {
    }

    public void unlock(String name) {
    }

    public void markUnimportant(String name) {
    }

    public static class Mapper
    extends URLMapper {
        static Set<HudsonRemoteFileSystem> workspaces = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URL getURL(FileObject fo, int type) {
            Class<Mapper> clazz = Mapper.class;
            synchronized (Mapper.class) {
                if (workspaces == null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return null;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return Mapper.doGetURL(fo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject[] getFileObjects(URL url) {
            Class<Mapper> clazz = Mapper.class;
            synchronized (Mapper.class) {
                if (workspaces == null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Mapper.doGetFileObjects(url);
            }
        }

        private static URL doGetURL(FileObject fo) {
            try {
                FileSystem fs = fo.getFileSystem();
                if (fs instanceof HudsonRemoteFileSystem) {
                    return new URL(((HudsonRemoteFileSystem)fs).baseURL, Utilities.uriEncode(fo.getPath()));
                }
            }
            catch (IOException x) {
                LOG.log(Level.INFO, "trying to get URL for " + fo, x);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static FileObject[] doGetFileObjects(URL url) {
            HudsonRemoteFileSystem fs = null;
            String urlS = url.toString();
            Class<Mapper> clazz = Mapper.class;
            synchronized (Mapper.class) {
                FileObject f;
                for (HudsonRemoteFileSystem _fs : workspaces) {
                    if (!urlS.startsWith(_fs.baseURL.toString())) continue;
                    fs = _fs;
                    break;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (fs != null && (f = fs.findResource(urlS.substring(fs.baseURL.toString().length()))) != null) {
                    return new FileObject[]{f};
                }
                return null;
            }
        }
    }
}

