/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.jstesting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProvider;
import org.netbeans.modules.web.clientproject.jstesting.CompositeCategoryProviderImpl;
import org.netbeans.modules.web.clientproject.jstesting.JsTestingProviderAccessor;
import org.netbeans.modules.web.clientproject.jstesting.SelectProviderPanel;
import org.netbeans.modules.web.clientproject.spi.jstesting.JsTestingProviderImplementation;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;

public final class JsTestingProviders {
    public static final String JS_TESTING_PATH = "JS/Testing";
    public static final String CUSTOMIZER_IDENT = "JS_TESTING";
    private static final Lookup.Result<JsTestingProviderImplementation> JS_TESTING_PROVIDERS = Lookups.forPath((String)"JS/Testing").lookupResult(JsTestingProviderImplementation.class);
    private static final JsTestingProviders INSTANCE = new JsTestingProviders();
    private final List<JsTestingProvider> jsTestingProviders = new CopyOnWriteArrayList<JsTestingProvider>();

    private JsTestingProviders() {
        this.initProviders();
    }

    public static JsTestingProviders getDefault() {
        return INSTANCE;
    }

    public List<JsTestingProvider> getJsTestingProviders() {
        return new ArrayList<JsTestingProvider>(this.jsTestingProviders);
    }

    @CheckForNull
    public JsTestingProvider findJsTestingProvider(@NonNull String identifier) {
        Parameters.notNull((CharSequence)"identifier", (Object)identifier);
        for (JsTestingProvider jsTestingProvider : this.jsTestingProviders) {
            if (!jsTestingProvider.getIdentifier().equals(identifier)) continue;
            return jsTestingProvider;
        }
        return null;
    }

    @CheckForNull
    public JsTestingProvider getJsTestingProvider(@NonNull Project project, boolean showSelectionPanel) {
        JsTestingProvider jsTestingProvider;
        Parameters.notNull((CharSequence)"project", (Object)project);
        for (JsTestingProvider jsTestingProvider2 : this.jsTestingProviders) {
            if (!jsTestingProvider2.isEnabled(project)) continue;
            return jsTestingProvider2;
        }
        if (showSelectionPanel && (jsTestingProvider = SelectProviderPanel.open()) != null) {
            jsTestingProvider.notifyEnabled(project, true);
            return jsTestingProvider;
        }
        return null;
    }

    public void setJsTestingProvider(@NonNull Project project, @NonNull JsTestingProvider jsTestingProvider) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"jsTestingProvider", (Object)jsTestingProvider);
        JsTestingProvider currentTestingProvider = this.getJsTestingProvider(project, false);
        if (currentTestingProvider != null) {
            if (currentTestingProvider.getIdentifier().equals(jsTestingProvider.getIdentifier())) {
                return;
            }
            currentTestingProvider.notifyEnabled(project, false);
        }
        jsTestingProvider.notifyEnabled(project, true);
    }

    public ProjectCustomizer.CompositeCategoryProvider createCustomizer() {
        return new CompositeCategoryProviderImpl();
    }

    public NodeFactory createJsTestingProvidersNodeFactory() {
        return new NodeFactory(){

            public NodeList<?> createNodes(Project project) {
                return new ProxyNodeList(project);
            }
        };
    }

    private void initProviders() {
        assert (this.jsTestingProviders.isEmpty()) : "Empty providers expected but: " + this.jsTestingProviders;
        this.jsTestingProviders.addAll(this.map(JS_TESTING_PROVIDERS.allInstances()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reinitProviders() {
        List<JsTestingProvider> list = this.jsTestingProviders;
        synchronized (list) {
            this.clearProviders();
            this.initProviders();
        }
    }

    private void clearProviders() {
        this.jsTestingProviders.clear();
    }

    private Collection<JsTestingProvider> map(Collection<? extends JsTestingProviderImplementation> providers) {
        ArrayList<JsTestingProvider> result = new ArrayList<JsTestingProvider>();
        for (JsTestingProviderImplementation jsTestingProviderImplementation : providers) {
            result.add(JsTestingProviderAccessor.getDefault().create(jsTestingProviderImplementation));
        }
        return result;
    }

    static {
        JS_TESTING_PROVIDERS.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                INSTANCE.reinitProviders();
            }
        });
    }

    private static final class ProxyNodeList
    implements NodeList<Node>,
    ChangeListener {
        private final Project project;
        private final List<NodeList<Node>> nodeList = new CopyOnWriteArrayList<NodeList<Node>>();
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final AtomicLong listenerCounter = new AtomicLong(0L);

        private ProxyNodeList(Project project) {
            assert (project != null);
            this.project = project;
            this.nodeList.addAll(this.initNodeList(project));
        }

        private List<NodeList<Node>> initNodeList(Project project) {
            ArrayList<NodeList<Node>> result = new ArrayList<NodeList<Node>>();
            for (JsTestingProvider provider : JsTestingProviders.getDefault().getJsTestingProviders()) {
                NodeList<Node> providerNodeList = provider.createNodeList(project);
                if (providerNodeList == null) continue;
                result.add(providerNodeList);
            }
            return result;
        }

        public List<Node> keys() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (NodeList<Node> list : this.nodeList) {
                nodes.addAll(list.keys());
            }
            return nodes;
        }

        public void addChangeListener(ChangeListener listener) {
            if (this.listenerCounter.incrementAndGet() == 1L) {
                for (NodeList<Node> list : this.nodeList) {
                    list.addChangeListener((ChangeListener)this);
                }
            }
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            if (this.listenerCounter.decrementAndGet() == 0L) {
                for (NodeList<Node> list : this.nodeList) {
                    list.removeChangeListener((ChangeListener)this);
                }
            }
            this.changeSupport.removeChangeListener(listener);
        }

        public Node node(Node node) {
            return node;
        }

        public void addNotify() {
            for (NodeList<Node> list : this.nodeList) {
                list.addNotify();
            }
        }

        public void removeNotify() {
            for (NodeList<Node> list : this.nodeList) {
                list.removeNotify();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.changeSupport.fireChange();
        }
    }
}

