/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.xml.sax.SAXException;

public class HttpMonitorHelper {
    private static final String MONITOR_MODULE_NAME = "org.netbeans.modules.web.monitor";
    private static ModuleInfo httpMonitorInfo;
    private static ModuleSpy monitorSpy;
    private static Lookup.Result res;
    private static MonitorInfoListener monitorInfoListener;
    private static MonitorLookupListener monitorLookupListener;
    private static final String MONITOR_FILTER_NAME = "HTTPMonitorFilter";
    private static final String MONITOR_FILTER_CLASS = "org.netbeans.modules.web.monitor.server.MonitorFilter";
    private static final String MONITOR_FILTER_PATTERN = "/*";
    private static final String MONITOR_INTERNALPORT_PARAM_NAME = "netbeans.monitor.ide";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean synchronizeMonitor(String domainLoc, String domainName, boolean monitorFlag, boolean jakartaVariant, String ... others) throws FileNotFoundException, IOException, SAXException {
        boolean monitorModuleAvailable = HttpMonitorHelper.isMonitorEnabled();
        boolean shouldInstall = monitorModuleAvailable && monitorFlag;
        File webXML = HttpMonitorHelper.getDefaultWebXML(domainLoc, domainName);
        if (webXML == null) {
            return false;
        }
        WebApp webApp = DDProvider.getDefault().getDDRoot(webXML);
        if (webApp == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new Exception(""));
            return false;
        }
        boolean needsSave = false;
        boolean needRestart = false;
        try {
            if (shouldInstall) {
                needRestart = HttpMonitorHelper.addMonitorJars(domainLoc, domainName, jakartaVariant, others);
                boolean result = HttpMonitorHelper.changeFilterMonitor(webApp, true);
                needsSave = needsSave || result;
                result = HttpMonitorHelper.specifyFilterPortParameter(webApp);
                needsSave = needsSave || result;
            } else {
                boolean result = HttpMonitorHelper.changeFilterMonitor(webApp, false);
                needsSave = needsSave || result;
            }
        }
        catch (ClassNotFoundException cnfe) {
            needsSave = false;
            ErrorManager.getDefault().notify(65536, (Throwable)cnfe);
        }
        if (needsSave) {
            try (FileOutputStream os = new FileOutputStream(webXML);){
                webApp.write((OutputStream)os);
            }
        }
        return needRestart;
    }

    static File getDefaultWebXML(String domainLoc, String domainName) {
        String loc = domainLoc + "/" + domainName + "/config/default-web.xml";
        File webXML = new File(loc);
        if (webXML.exists()) {
            String backupLoc = domainLoc + "/" + domainName + "/config/default-web.xml.orig";
            File backupXml = new File(backupLoc);
            if (!backupXml.exists()) {
                try {
                    HttpMonitorHelper.copy(webXML, backupXml);
                    HttpMonitorHelper.createCopyAndUpgrade(backupXml, webXML);
                }
                catch (FileNotFoundException fnfe) {
                    Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "This file existed a few milliseconds ago: " + webXML.getAbsolutePath(), fnfe);
                }
                catch (IOException ioe) {
                    if (backupXml.exists()) {
                        backupXml.delete();
                        Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "failed to backup data from " + webXML.getAbsolutePath(), ioe);
                    }
                    Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "failed to create backup file " + backupXml.getAbsolutePath(), ioe);
                }
            }
            return webXML.exists() ? webXML : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createCopyAndUpgrade(File webXML, File newWebXML) {
        BufferedReader fr = null;
        BufferedWriter fw = null;
        boolean deleteNew = true;
        try {
            String line;
            fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(webXML), StandardCharsets.ISO_8859_1));
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newWebXML), StandardCharsets.ISO_8859_1));
            while ((line = fr.readLine()) != null) {
                if (line.startsWith("<!DOCTYPE")) {
                    while (!line.startsWith("<web-app")) {
                        line = fr.readLine();
                    }
                    fw.write("<web-app version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">");
                    fw.newLine();
                    continue;
                }
                fw.write(line);
                fw.newLine();
            }
            deleteNew = false;
            fw.close();
            fw = null;
            fr.close();
            fr = null;
        }
        catch (FileNotFoundException fnfe) {
            Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "This file existed a few milliseconds ago: " + webXML.getAbsolutePath());
        }
        catch (Exception e) {
            if (null != fw && deleteNew && !newWebXML.delete()) {
                Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "hack to eliminate GF bug 8609 failed and left bogus file: {0}", newWebXML.getAbsolutePath());
            }
            Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "hack to eliminate GF bug 8609 failed", e);
        }
        finally {
            if (null != fw) {
                try {
                    fw.close();
                }
                catch (IOException ioe) {
                    Logger.getLogger("glassfish-eecommon").log(Level.INFO, "close of fw failed: " + newWebXML.getAbsolutePath(), ioe);
                }
            }
            if (null != fr) {
                try {
                    fr.close();
                }
                catch (IOException ioe) {
                    Logger.getLogger("glassfish-eecommon").log(Level.INFO, "close of fr failed: " + webXML.getAbsolutePath(), ioe);
                }
            }
        }
    }

    private static boolean addMonitorJars(String domainLoc, String domainName, boolean jakartaVariant, String ... others) throws FileNotFoundException, IOException {
        String loc = domainLoc + "/" + domainName;
        File instDir = new File(loc);
        boolean retVal = jakartaVariant ? HttpMonitorHelper.copyFromIDEInstToDir("modules/ext/org-netbeans-modules-web-httpmonitor-jakarta.jar", instDir, "lib/org-netbeans-modules-web-httpmonitor.jar") : HttpMonitorHelper.copyFromIDEInstToDir("modules/ext/org-netbeans-modules-web-httpmonitor.jar", instDir, "lib/org-netbeans-modules-web-httpmonitor.jar");
        for (String anOther : others) {
            int lastSlash = anOther.lastIndexOf("/");
            if (lastSlash <= -1) continue;
            String jarName = anOther.substring(lastSlash + 1);
            retVal = retVal && HttpMonitorHelper.copyFromIDEInstToDir(anOther, instDir, "lib/" + jarName);
        }
        return retVal;
    }

    static boolean changeFilterMonitor(WebApp webApp, boolean full) throws ClassNotFoundException {
        boolean filterWasChanged;
        block8: {
            block7: {
                filterWasChanged = false;
                if (!full) break block7;
                boolean isFilter = false;
                Filter[] filters = webApp.getFilter();
                for (int i = 0; i < filters.length; ++i) {
                    if (!filters[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                    isFilter = true;
                    break;
                }
                if (!isFilter) {
                    Filter filter = (Filter)webApp.createBean("Filter");
                    filter.setFilterName(MONITOR_FILTER_NAME);
                    filter.setFilterClass(MONITOR_FILTER_CLASS);
                    webApp.addFilter(filter);
                    filterWasChanged = true;
                }
                boolean isMapping = false;
                FilterMapping[] maps = webApp.getFilterMapping();
                for (int i = 0; i < maps.length; ++i) {
                    if (!maps[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                    isMapping = true;
                    break;
                }
                if (isMapping) break block8;
                FilterMapping filterMapping = (FilterMapping)webApp.createBean("FilterMapping");
                Object[] dispatcher = new String[]{"REQUEST", "FORWARD", "INCLUDE", "ERROR"};
                try {
                    filterMapping.setDispatcher((String[])dispatcher);
                }
                catch (VersionNotSupportedException ex) {
                    Logger.getLogger("glassfish-eecommon").log(Level.FINER, "ignorable and ignoring", ex);
                    ((BaseBean)filterMapping).createProperty("dispatcher", "Dispatcher", 65840, String.class);
                    ((BaseBean)filterMapping).setValue("Dispatcher", dispatcher);
                }
                filterMapping.setFilterName(MONITOR_FILTER_NAME);
                filterMapping.setUrlPattern(MONITOR_FILTER_PATTERN);
                webApp.addFilterMapping(filterMapping);
                filterWasChanged = true;
                break block8;
            }
            FilterMapping[] maps = webApp.getFilterMapping();
            for (int i = 0; i < maps.length; ++i) {
                if (!maps[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                webApp.removeFilterMapping(maps[i]);
                filterWasChanged = true;
                break;
            }
            Filter[] filters = webApp.getFilter();
            for (int i = 0; i < filters.length; ++i) {
                if (!filters[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                webApp.removeFilter(filters[i]);
                filterWasChanged = true;
                break;
            }
        }
        return filterWasChanged;
    }

    private static File findInstallationFile(String instRelPath) {
        return InstalledFileLocator.getDefault().locate(instRelPath, null, false);
    }

    private static boolean copyFromIDEInstToDir(String sourceRelPath, File copyTo, String targetRelPath) throws FileNotFoundException, IOException {
        File targetFile = HttpMonitorHelper.findFileUnderBase(copyTo, targetRelPath);
        File sourceFile = HttpMonitorHelper.findInstallationFile(sourceRelPath);
        if (sourceFile != null && sourceFile.exists()) {
            File targetParent = targetFile.getParentFile();
            if (!targetParent.exists()) {
                targetParent.mkdirs();
            }
            if (!targetFile.exists() || sourceFile.length() != targetFile.length()) {
                HttpMonitorHelper.copy(sourceFile, targetFile);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File file1, File file2) throws FileNotFoundException, IOException {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int b;
            bis = new BufferedInputStream(new FileInputStream(file1));
            bos = new BufferedOutputStream(new FileOutputStream(file2));
            while ((b = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(b);
            }
        }
        finally {
            if (null != bis) {
                try {
                    bis.close();
                }
                catch (IOException ioe) {
                    Logger.getLogger("glassfish-eecommon").log(Level.FINEST, "bis", ioe);
                }
            }
            if (null != bos) {
                try {
                    bos.close();
                }
                catch (IOException ioe) {
                    Logger.getLogger("glassfish-eecommon").log(Level.FINEST, "bos", ioe);
                }
            }
        }
    }

    private static File findFileUnderBase(File base, String fileRelPath) {
        if (fileRelPath.startsWith("/")) {
            fileRelPath = fileRelPath.substring(1);
        }
        fileRelPath = fileRelPath.replace('/', File.separatorChar);
        return new File(base, fileRelPath);
    }

    static boolean specifyFilterPortParameter(WebApp webApp) throws ClassNotFoundException {
        Filter[] filters = webApp.getFilter();
        Filter myFilter = null;
        for (int i = 0; i < filters.length; ++i) {
            if (!MONITOR_FILTER_NAME.equals(filters[i].getFilterName())) continue;
            myFilter = filters[i];
            break;
        }
        if (myFilter == null) {
            return false;
        }
        InitParam[] params = myFilter.getInitParam();
        InitParam myParam = null;
        for (int i = 0; i < params.length; ++i) {
            if (!MONITOR_INTERNALPORT_PARAM_NAME.equals(params[i].getParamName())) continue;
            myParam = params[i];
            break;
        }
        String correctParamValue = HttpMonitorHelper.getLocalHost() + ":" + HttpMonitorHelper.getInternalServerPort();
        if (myParam == null) {
            InitParam init = (InitParam)myFilter.createBean("InitParam");
            init.setParamName(MONITOR_INTERNALPORT_PARAM_NAME);
            init.setParamValue(correctParamValue);
            myFilter.addInitParam(init);
            return true;
        }
        if (correctParamValue.equals(myParam.getParamValue())) {
            return false;
        }
        myParam.setParamValue(correctParamValue);
        return true;
    }

    private static String getLocalHost() {
        return "127.0.0.1";
    }

    private static URL getSampleHTTPServerURL() {
        FileObject fo = FileUtil.getConfigFile((String)"HTTPServer_DUMMY");
        if (fo == null) {
            return null;
        }
        URL u = URLMapper.findURL((FileObject)fo, (int)2);
        return u;
    }

    private static String getInternalServerPort() {
        URL u = HttpMonitorHelper.getSampleHTTPServerURL();
        if (u != null) {
            return Integer.toString(u.getPort());
        }
        return "8082";
    }

    private static void startModuleSpy(ModuleSpy spy) {
        res = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        Iterator it = res.allInstances().iterator();
        String moduleId = spy.getModuleId();
        while (it.hasNext()) {
            ModuleInfo mi = (ModuleInfo)it.next();
            if (!mi.getCodeName().startsWith(moduleId)) continue;
            httpMonitorInfo = mi;
            spy.setEnabled(mi.isEnabled());
            monitorInfoListener = new MonitorInfoListener(spy);
            httpMonitorInfo.addPropertyChangeListener((PropertyChangeListener)monitorInfoListener);
            break;
        }
        monitorLookupListener = new MonitorLookupListener(spy, httpMonitorInfo);
        res.addLookupListener((LookupListener)monitorLookupListener);
    }

    static synchronized boolean isMonitorEnabled() {
        if (monitorSpy == null) {
            monitorSpy = new ModuleSpy(MONITOR_MODULE_NAME);
            HttpMonitorHelper.startModuleSpy(monitorSpy);
        }
        return monitorSpy.isEnabled();
    }

    void removeListeners() {
        if (httpMonitorInfo != null) {
            httpMonitorInfo.removePropertyChangeListener((PropertyChangeListener)monitorInfoListener);
        }
        if (res != null) {
            res.removeLookupListener((LookupListener)monitorLookupListener);
        }
    }

    private static class ModuleSpy {
        private boolean enabled;
        private String moduleId;

        public ModuleSpy(String moduleId) {
            this.moduleId = moduleId;
        }

        public void setModuleId(String moduleId) {
            this.moduleId = moduleId;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getModuleId() {
            return this.moduleId;
        }
    }

    private static class MonitorInfoListener
    implements PropertyChangeListener {
        ModuleSpy spy;

        MonitorInfoListener(ModuleSpy spy) {
            this.spy = spy;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                this.spy.setEnabled((Boolean)evt.getNewValue());
            }
        }
    }

    private static class MonitorLookupListener
    implements LookupListener {
        ModuleSpy spy;
        ModuleInfo httpMonitorInfo;

        MonitorLookupListener(ModuleSpy spy, ModuleInfo httpMonitorInfo) {
            this.spy = spy;
            this.httpMonitorInfo = httpMonitorInfo;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Iterator it = res.allInstances().iterator();
            boolean moduleFound = false;
            while (it.hasNext()) {
                ModuleInfo mi = (ModuleInfo)it.next();
                if (!mi.getCodeName().startsWith(this.spy.getModuleId())) continue;
                this.spy.setEnabled(mi.isEnabled());
                if (this.httpMonitorInfo == null) {
                    this.httpMonitorInfo = mi;
                    monitorInfoListener = new MonitorInfoListener(this.spy);
                    this.httpMonitorInfo.addPropertyChangeListener((PropertyChangeListener)monitorInfoListener);
                }
                moduleFound = true;
                break;
            }
            if (!moduleFound && this.httpMonitorInfo != null) {
                this.httpMonitorInfo.removePropertyChangeListener((PropertyChangeListener)monitorInfoListener);
                this.httpMonitorInfo = null;
                this.spy.setEnabled(false);
            }
        }
    }
}

