/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StackMonitoringConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="stackMonitoringStatus")
    private final StackMonitoringStatus stackMonitoringStatus;
    @JsonProperty(value="stackMonitoringConnectorId")
    private final String stackMonitoringConnectorId;

    @Deprecated
    @ConstructorProperties(value={"stackMonitoringStatus", "stackMonitoringConnectorId"})
    public StackMonitoringConfig(StackMonitoringStatus stackMonitoringStatus, String stackMonitoringConnectorId) {
        this.stackMonitoringStatus = stackMonitoringStatus;
        this.stackMonitoringConnectorId = stackMonitoringConnectorId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public StackMonitoringStatus getStackMonitoringStatus() {
        return this.stackMonitoringStatus;
    }

    public String getStackMonitoringConnectorId() {
        return this.stackMonitoringConnectorId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StackMonitoringConfig(");
        sb.append("super=").append(super.toString());
        sb.append("stackMonitoringStatus=").append(String.valueOf((Object)this.stackMonitoringStatus));
        sb.append(", stackMonitoringConnectorId=").append(String.valueOf(this.stackMonitoringConnectorId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StackMonitoringConfig)) {
            return false;
        }
        StackMonitoringConfig other = (StackMonitoringConfig)((Object)o);
        return Objects.equals((Object)this.stackMonitoringStatus, (Object)other.stackMonitoringStatus) && Objects.equals(this.stackMonitoringConnectorId, other.stackMonitoringConnectorId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.stackMonitoringStatus == null ? 43 : this.stackMonitoringStatus.hashCode());
        result = result * 59 + (this.stackMonitoringConnectorId == null ? 43 : this.stackMonitoringConnectorId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum StackMonitoringStatus implements BmcEnum
    {
        Enabling("ENABLING"),
        Enabled("ENABLED"),
        Disabling("DISABLING"),
        NotEnabled("NOT_ENABLED"),
        FailedEnabling("FAILED_ENABLING"),
        FailedDisabling("FAILED_DISABLING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, StackMonitoringStatus> map;

        private StackMonitoringStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static StackMonitoringStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'StackMonitoringStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(StackMonitoringStatus.class);
            map = new HashMap<String, StackMonitoringStatus>();
            for (StackMonitoringStatus v : StackMonitoringStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="stackMonitoringStatus")
        private StackMonitoringStatus stackMonitoringStatus;
        @JsonProperty(value="stackMonitoringConnectorId")
        private String stackMonitoringConnectorId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder stackMonitoringStatus(StackMonitoringStatus stackMonitoringStatus) {
            this.stackMonitoringStatus = stackMonitoringStatus;
            this.__explicitlySet__.add("stackMonitoringStatus");
            return this;
        }

        public Builder stackMonitoringConnectorId(String stackMonitoringConnectorId) {
            this.stackMonitoringConnectorId = stackMonitoringConnectorId;
            this.__explicitlySet__.add("stackMonitoringConnectorId");
            return this;
        }

        public StackMonitoringConfig build() {
            StackMonitoringConfig model = new StackMonitoringConfig(this.stackMonitoringStatus, this.stackMonitoringConnectorId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StackMonitoringConfig model) {
            if (model.wasPropertyExplicitlySet("stackMonitoringStatus")) {
                this.stackMonitoringStatus(model.getStackMonitoringStatus());
            }
            if (model.wasPropertyExplicitlySet("stackMonitoringConnectorId")) {
                this.stackMonitoringConnectorId(model.getStackMonitoringConnectorId());
            }
            return this;
        }
    }
}

