/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.net.URL;
import javax.swing.Action;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionQuery;
import org.netbeans.modules.web.core.syntax.completion.api.JspCompletionItem;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class JspCompletionProvider
implements CompletionProvider {
    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        int type = JspSyntaxSupport.get(component.getDocument()).checkCompletion(component, typedText, false);
        if (type == 0) {
            return 3;
        }
        return 0;
    }

    public CompletionTask createTask(int type, JTextComponent component) {
        if ((type & 1 & 9) != 0) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
        }
        if (type == 2) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(null), component);
        }
        return null;
    }

    public static class Query
    extends AbstractQuery {
        private JTextComponent component;

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        @Override
        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            JspCompletionQuery.CompletionResultSet jspResultSet = new JspCompletionQuery.CompletionResultSet();
            JspCompletionQuery.instance().query(jspResultSet, this.component, caretOffset);
            resultSet.addAllItems(jspResultSet.getItems());
            resultSet.setAnchorOffset(jspResultSet.getAnchor());
        }
    }

    public static class DocQuery
    extends AbstractQuery {
        private JTextComponent component;
        private JspCompletionItem item;

        public DocQuery(JspCompletionItem item) {
            this.item = item;
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        @Override
        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            if (this.item != null) {
                if (this.item.hasHelp()) {
                    resultSet.setDocumentation((CompletionDocumentation)new DocItem(this.item));
                }
            } else {
                CompletionItem citem;
                JspCompletionQuery.CompletionResultSet jspResultSet = new JspCompletionQuery.CompletionResultSet();
                JspCompletionQuery.instance().query(jspResultSet, this.component, caretOffset);
                if (jspResultSet.getItems().size() > 0 && (citem = jspResultSet.getItems().get(0)) instanceof JspCompletionItem) {
                    resultSet.setDocumentation((CompletionDocumentation)new DocItem((JspCompletionItem)citem));
                    resultSet.setAnchorOffset(jspResultSet.getAnchor());
                }
            }
        }
    }

    public static abstract class AbstractQuery
    extends AsyncCompletionQuery {
        protected void preQueryUpdate(JTextComponent component) {
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            this.doQuery(resultSet, doc, caretOffset);
            resultSet.finish();
        }

        abstract void doQuery(CompletionResultSet var1, Document var2, int var3);
    }

    private static class DocItem
    implements CompletionDocumentation {
        private JspCompletionItem ri;

        public DocItem(JspCompletionItem ri) {
            this.ri = ri;
        }

        public String getText() {
            return this.ri.getHelp();
        }

        public URL getURL() {
            return this.ri.getHelpURL();
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }
}

