/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetRepoFileLinesRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private String revision;
    private String filePath;
    private Integer startLineNumber;
    private Integer limit;
    private String opcRequestId;

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Integer getStartLineNumber() {
        return this.startLineNumber;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).revision(this.revision).filePath(this.filePath).startLineNumber(this.startLineNumber).limit(this.limit).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(",revision=").append(String.valueOf(this.revision));
        sb.append(",filePath=").append(String.valueOf(this.filePath));
        sb.append(",startLineNumber=").append(String.valueOf(this.startLineNumber));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRepoFileLinesRequest)) {
            return false;
        }
        GetRepoFileLinesRequest other = (GetRepoFileLinesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.revision, other.revision) && Objects.equals(this.filePath, other.filePath) && Objects.equals(this.startLineNumber, other.startLineNumber) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.revision == null ? 43 : this.revision.hashCode());
        result = result * 59 + (this.filePath == null ? 43 : this.filePath.hashCode());
        result = result * 59 + (this.startLineNumber == null ? 43 : this.startLineNumber.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRepoFileLinesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String repositoryId = null;
        private String revision = null;
        private String filePath = null;
        private Integer startLineNumber = null;
        private Integer limit = null;
        private String opcRequestId = null;

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder startLineNumber(Integer startLineNumber) {
            this.startLineNumber = startLineNumber;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRepoFileLinesRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.revision(o.getRevision());
            this.filePath(o.getFilePath());
            this.startLineNumber(o.getStartLineNumber());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRepoFileLinesRequest build() {
            GetRepoFileLinesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetRepoFileLinesRequest buildWithoutInvocationCallback() {
            GetRepoFileLinesRequest request = new GetRepoFileLinesRequest();
            request.repositoryId = this.repositoryId;
            request.revision = this.revision;
            request.filePath = this.filePath;
            request.startLineNumber = this.startLineNumber;
            request.limit = this.limit;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

