/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class TerminateClusterNetworkRequest
extends BmcRequest<Void> {
    private String clusterNetworkId;
    private String ifMatch;

    public String getClusterNetworkId() {
        return this.clusterNetworkId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().clusterNetworkId(this.clusterNetworkId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",clusterNetworkId=").append(String.valueOf(this.clusterNetworkId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TerminateClusterNetworkRequest)) {
            return false;
        }
        TerminateClusterNetworkRequest other = (TerminateClusterNetworkRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.clusterNetworkId, other.clusterNetworkId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.clusterNetworkId == null ? 43 : this.clusterNetworkId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<TerminateClusterNetworkRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String clusterNetworkId = null;
        private String ifMatch = null;

        public Builder clusterNetworkId(String clusterNetworkId) {
            this.clusterNetworkId = clusterNetworkId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(TerminateClusterNetworkRequest o) {
            this.clusterNetworkId(o.getClusterNetworkId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public TerminateClusterNetworkRequest build() {
            TerminateClusterNetworkRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public TerminateClusterNetworkRequest buildWithoutInvocationCallback() {
            TerminateClusterNetworkRequest request = new TerminateClusterNetworkRequest();
            request.clusterNetworkId = this.clusterNetworkId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

