/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import java.util.Arrays;
import java.util.Random;
import java.util.function.Consumer;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.openide.DialogDescriptor;

public abstract class AbstractPasswordPanel
extends JPanel {
    private static final String SPECIAL_CHARACTERS = "/!#$^?:.(){}[]~-_.";
    protected DialogDescriptor descriptor;

    protected final void setDescriptor(DialogDescriptor descriptor) {
        if (this.descriptor != null) {
            throw new IllegalStateException("DialogDescriptor has been already set.");
        }
        this.descriptor = descriptor;
        descriptor.setValid(false);
    }

    static boolean checkPasswordLogic(char[] passwd1, char[] passwd2, Consumer<String> message) {
        boolean result = false;
        if (passwd1.length < 8) {
            message.accept(Bundle.Lenght());
            return result;
        }
        int nSpecialCharacters = 0;
        int nLetters = 0;
        int nDigits = 0;
        for (int i = 0; i < passwd1.length; ++i) {
            if (Character.isLetter(passwd1[i])) {
                ++nLetters;
                continue;
            }
            if (Character.isDigit(passwd1[i])) {
                ++nDigits;
                continue;
            }
            if (SPECIAL_CHARACTERS.indexOf(passwd1[i]) < 0) continue;
            ++nSpecialCharacters;
        }
        if (nLetters < 1) {
            message.accept(Bundle.OneLetter());
        } else if (nSpecialCharacters < 1) {
            message.accept(Bundle.OneSpecial());
        } else if (nDigits < 1) {
            message.accept(Bundle.OneNumber());
        } else if (!Arrays.equals(passwd1, passwd2)) {
            message.accept(Bundle.Match());
        } else {
            message.accept(null);
            result = true;
        }
        return result;
    }

    static char[] generatePassword() {
        int i;
        Random rnd = new Random();
        char[] password = new char[12];
        for (i = 0; i < 4; ++i) {
            password[i] = (char)(65 + rnd.nextInt(25));
        }
        password[4] = SPECIAL_CHARACTERS.charAt(rnd.nextInt(SPECIAL_CHARACTERS.length()));
        for (i = 5; i < password.length - 1; ++i) {
            password[i] = (char)(97 + rnd.nextInt(25));
        }
        password[password.length - 1] = (char)(48 + rnd.nextInt(9));
        return password;
    }

    protected void errorMessage(String message) {
        if (message == null) {
            this.descriptor.getNotificationLineSupport().clearMessages();
            this.descriptor.setValid(true);
        } else {
            this.descriptor.setValid(false);
            this.descriptor.getNotificationLineSupport().setErrorMessage(message);
        }
    }

    protected abstract void checkPassword();

    protected class PasswordListener
    implements DocumentListener {
        protected PasswordListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AbstractPasswordPanel.this.checkPassword();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AbstractPasswordPanel.this.checkPassword();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AbstractPasswordPanel.this.checkPassword();
        }
    }
}

