/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import com.sun.source.util.JavacTask;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

class SetupLimitModulesProbe {
    SetupLimitModulesProbe() {
    }

    public static void main(String[] args) throws IOException {
        String release = args[0];
        String[] excludedModules = (String[])Arrays.stream(args).skip(1L).toArray(String[]::new);
        String limitModules = SetupLimitModulesProbe.computeLimitModules(release, excludedModules);
        System.out.println(limitModules);
    }

    public static String computeLimitModules(String release, String ... excludedModulesIn) throws IOException {
        HashSet<String> excludedModules = new HashSet<String>(List.of(excludedModulesIn));
        List<String> options = "last".equals(release) ? List.of("--add-modules", "ALL-SYSTEM", "-classpath", "") : List.of("--release", release, "-classpath", "");
        JavacTask task = (JavacTask)ToolProvider.getSystemJavaCompiler().getTask(null, null, null, options, null, List.of(new JFOImpl(URI.create("mem://Test.java"), "")));
        task.analyze();
        String limitModules = task.getElements().getAllModuleElements().stream().filter(m -> !m.getQualifiedName().toString().startsWith("jdk.internal.")).filter(m -> !m.isUnnamed()).filter(m -> SetupLimitModulesProbe.canInclude(m, excludedModules)).map(m -> m.getQualifiedName()).collect(Collectors.joining(","));
        return limitModules;
    }

    private static boolean canInclude(ModuleElement m, Set<String> excludes) {
        return Collections.disjoint(SetupLimitModulesProbe.transitiveDependencies(m), excludes);
    }

    private static Set<String> transitiveDependencies(ModuleElement m) {
        LinkedList<ModuleElement> todo = new LinkedList<ModuleElement>();
        HashSet<ModuleElement> seenModules = new HashSet<ModuleElement>();
        todo.add(m);
        while (!todo.isEmpty()) {
            ModuleElement current = (ModuleElement)todo.remove(0);
            if (!seenModules.add(current)) continue;
            for (ModuleElement.RequiresDirective rd : ElementFilter.requiresIn(current.getDirectives())) {
                todo.add(rd.getDependency());
            }
        }
        return seenModules.stream().map(c -> c.getQualifiedName().toString()).collect(Collectors.toSet());
    }

    private static final class JFOImpl
    extends SimpleJavaFileObject {
        private final String content;

        public JFOImpl(URI uri, String content) {
            super(uri, JavaFileObject.Kind.SOURCE);
            this.content = content;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.content;
        }
    }
}

