/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class SetAnchoringAction
extends NodeAction {
    private JCheckBoxMenuItem[] items;
    private ActionListener menuItemListener;

    protected boolean enable(Node[] nodes) {
        List<RADComponent> comps = FormUtils.getSelectedLayoutComponents(nodes);
        return comps != null && comps.size() > 0;
    }

    public String getName() {
        return NbBundle.getMessage(SetAnchoringAction.class, (String)"ACT_SetAnchoring");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] activatedNodes) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenu popupMenu = new JMenu(NbBundle.getMessage(SetAnchoringAction.class, (String)"ACT_SetAnchoring"));
        popupMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)popupMenu, (String)SetAnchoringAction.class.getName());
        popupMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                JMenu menu = (JMenu)e.getSource();
                SetAnchoringAction.this.createAnchoringSubmenu(menu);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return popupMenu;
    }

    private void createAnchoringSubmenu(JMenu menu) {
        Node[] nodes = this.getActivatedNodes();
        List<RADComponent> components = FormUtils.getSelectedLayoutComponents(nodes);
        if (components == null || components.size() < 1) {
            return;
        }
        if (menu.getMenuComponentCount() <= 0) {
            ResourceBundle bundle = NbBundle.getBundle(SetAnchoringAction.class);
            AnchoringMenuItem leftItem = new AnchoringMenuItem(bundle.getString("CTL_AnchorLeft"), components, 0);
            AnchoringMenuItem rightItem = new AnchoringMenuItem(bundle.getString("CTL_AnchorRight"), components, 1);
            AnchoringMenuItem topItem = new AnchoringMenuItem(bundle.getString("CTL_AnchorTop"), components, 2);
            AnchoringMenuItem bottomItem = new AnchoringMenuItem(bundle.getString("CTL_AnchorBottom"), components, 3);
            this.items = new JCheckBoxMenuItem[]{leftItem, rightItem, topItem, bottomItem};
            for (int i = 0; i < 4; ++i) {
                this.items[i].addActionListener(this.getMenuItemListener());
                HelpCtx.setHelpIDString((JComponent)this.items[i], (String)SetAnchoringAction.class.getName());
                menu.add(this.items[i]);
            }
        }
        this.updateState(components);
    }

    private void updateState(List components) {
        if (components == null || components.size() < 1) {
            return;
        }
        FormModel formModel = ((RADComponent)components.get(0)).getFormModel();
        LayoutModel layoutModel = formModel.getLayoutModel();
        FormDesigner formDesigner = FormEditor.getFormDesigner(formModel);
        LayoutDesigner layoutDesigner = formDesigner.getLayoutDesigner();
        Iterator iter = components.iterator();
        boolean[] matchAlignment = new boolean[4];
        boolean[] cannotChangeTo = new boolean[4];
        while (iter.hasNext()) {
            RADComponent radC = (RADComponent)iter.next();
            String id = radC.getId();
            LayoutComponent comp = layoutModel.getLayoutComponent(id);
            int[][] alignment = new int[][]{layoutDesigner.getAdjustableComponentAlignment(comp, 0), layoutDesigner.getAdjustableComponentAlignment(comp, 1)};
            for (int i = 0; i < 4; ++i) {
                if ((alignment[i / 2][1] & 1 << i % 2) == 0) {
                    cannotChangeTo[i] = true;
                }
                if (alignment[i / 2][0] == -1) continue;
                matchAlignment[i] = matchAlignment[i] || alignment[i / 2][0] == i % 2;
            }
        }
        for (int i = 0; i < 4; ++i) {
            boolean match = matchAlignment[i];
            boolean miss = matchAlignment[2 * (i / 2) + 1 - i % 2];
            this.items[i].setEnabled((match || miss) && !cannotChangeTo[i]);
            this.items[i].setSelected(!miss && match);
        }
    }

    private ActionListener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new AnchoringMenuItemListener();
        }
        return this.menuItemListener;
    }

    private static class AnchoringMenuItem
    extends JCheckBoxMenuItem {
        private int direction;
        private List components;

        AnchoringMenuItem(String text, List components, int direction) {
            super(text);
            this.components = components;
            this.direction = direction;
        }

        int getDirection() {
            return this.direction;
        }

        List getRADComponents() {
            return this.components;
        }
    }

    private static class AnchoringMenuItemListener
    implements ActionListener {
        private AnchoringMenuItemListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (!(source instanceof AnchoringMenuItem)) {
                return;
            }
            AnchoringMenuItem mi = (AnchoringMenuItem)source;
            if (!mi.isEnabled()) {
                return;
            }
            int index = mi.getDirection();
            FormModel formModel = ((RADComponent)mi.getRADComponents().get(0)).getFormModel();
            LayoutModel layoutModel = formModel.getLayoutModel();
            Object layoutUndoMark = layoutModel.getChangeMark();
            UndoableEdit ue = layoutModel.getUndoableEdit();
            FormDesigner formDesigner = FormEditor.getFormDesigner(formModel);
            LayoutDesigner layoutDesigner = formDesigner.getLayoutDesigner();
            HashSet<RADVisualContainer> containers = new HashSet<RADVisualContainer>();
            boolean autoUndo = true;
            try {
                for (RADComponent radC : mi.getRADComponents()) {
                    String compId = radC.getId();
                    LayoutComponent layoutComp = layoutModel.getLayoutComponent(compId);
                    boolean changed = false;
                    int[] alignment = layoutDesigner.getAdjustableComponentAlignment(layoutComp, index / 2);
                    if ((alignment[1] & 1 << index % 2) != 0 && alignment[0] != index % 2) {
                        layoutDesigner.adjustComponentAlignment(layoutComp, index / 2, index % 2);
                        changed = true;
                    }
                    if (!changed) continue;
                    RADVisualComponent comp = (RADVisualComponent)formModel.getMetaComponent(compId);
                    containers.add(comp.getParentContainer());
                }
                autoUndo = false;
            }
            finally {
                Iterator iter = containers.iterator();
                while (iter.hasNext()) {
                    formModel.fireContainerLayoutChanged((RADVisualContainer)iter.next(), null, null, null);
                }
                if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                    formModel.addUndoableEdit(ue);
                }
                if (autoUndo) {
                    formModel.forceUndoOfCompoundEdit();
                }
            }
        }
    }
}

