/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.launch;

import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbDebugSession;

public final class NbDisconnectRequestHandler {
    private static final Logger LOGGER = Logger.getLogger(NbDisconnectRequestHandler.class.getName());

    public CompletableFuture<Void> disconnect(DisconnectArguments arguments, DebugAdapterContext context) {
        this.destroyDebugSession(arguments, context);
        context.getBreakpointManager().disposeBreakpoints();
        return CompletableFuture.completedFuture(null);
    }

    private void destroyDebugSession(DisconnectArguments arguments, DebugAdapterContext context) {
        NbDebugSession debugSession = context.getDebugSession();
        if (debugSession != null) {
            if (Boolean.TRUE.equals(arguments.getTerminateDebuggee()) && !context.isAttached()) {
                debugSession.terminate();
            } else {
                debugSession.detach();
            }
        } else {
            context.requestProcessTermination();
        }
    }
}

