/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import org.jitsi.srtp.SrtpPolicy;
import org.jitsi.srtp.crypto.Aes;
import org.jitsi.srtp.crypto.HmacSha1;
import org.jitsi.srtp.crypto.SrtpCipher;
import org.jitsi.srtp.crypto.SrtpCipherCtr;
import org.jitsi.srtp.crypto.SrtpCipherF8;
import org.jitsi.srtp.crypto.SrtpCipherGcm;
import org.jitsi.utils.ByteArrayBuffer;
import org.jitsi.utils.logging2.Logger;

public class BaseSrtpCryptoContext {
    protected static final long REPLAY_WINDOW_SIZE = 64L;
    protected final SrtpCipher cipher;
    protected final byte[] ivStore;
    protected final Mac mac;
    protected final SrtpPolicy policy;
    protected final byte[] rbStore = new byte[4];
    protected long replayWindow;
    protected final byte[] saltKey;
    protected final int ssrc;
    protected final byte[] tempStore = new byte[100];
    protected final Logger logger;

    protected BaseSrtpCryptoContext(int ssrc, byte[] masterK, byte[] masterS, SrtpPolicy policy, Logger parentLogger) throws GeneralSecurityException {
        Mac mac;
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        this.ssrc = ssrc;
        this.policy = policy;
        int encKeyLength = policy.getEncKeyLength();
        if (masterK != null) {
            if (masterK.length != encKeyLength) {
                throw new IllegalArgumentException("masterK.length != encKeyLength");
            }
        } else if (encKeyLength != 0) {
            throw new IllegalArgumentException("null masterK but encKeyLength != 0");
        }
        int saltKeyLength = policy.getSaltKeyLength();
        if (masterS != null) {
            if (masterS.length != saltKeyLength) {
                throw new IllegalArgumentException("masterS.length != saltKeyLength");
            }
        } else if (saltKeyLength != 0) {
            throw new IllegalArgumentException("null masterS but saltKeyLength != 0");
        }
        this.saltKey = new byte[saltKeyLength];
        int ivSize = 16;
        switch (policy.getEncType()) {
            case 1: {
                this.cipher = new SrtpCipherCtr(Aes.createCipher("AES/CTR/NoPadding"));
                break;
            }
            case 5: {
                if (policy.getAuthTagLength() != 16) {
                    throw new IllegalArgumentException("SRTP only supports 16-octet GCM auth tags");
                }
                this.cipher = new SrtpCipherGcm(Aes.createCipher("AES/GCM/NoPadding"));
                ivSize = 12;
                break;
            }
            case 2: {
                this.cipher = new SrtpCipherF8(Aes.createCipher("AES/ECB/NoPadding"));
                break;
            }
            case 4: {
                this.cipher = new SrtpCipherF8(Cipher.getInstance("Twofish/ECB/NoPadding"));
                break;
            }
            case 3: {
                this.cipher = new SrtpCipherCtr(Cipher.getInstance("Twofish/CTR/NoPadding"));
                break;
            }
            default: {
                this.cipher = null;
                ivSize = 0;
            }
        }
        this.ivStore = new byte[ivSize];
        switch (policy.getAuthType()) {
            case 1: {
                mac = HmacSha1.createMac(parentLogger);
                break;
            }
            case 2: {
                mac = Mac.getInstance("SkeinMac_512_" + policy.getAuthTagLength() * 8);
                break;
            }
            default: {
                mac = null;
            }
        }
        this.mac = mac;
    }

    protected void writeRoc(int rocIn) {
        this.rbStore[0] = (byte)(rocIn >> 24);
        this.rbStore[1] = (byte)(rocIn >> 16);
        this.rbStore[2] = (byte)(rocIn >> 8);
        this.rbStore[3] = (byte)rocIn;
    }

    protected synchronized byte[] authenticatePacketHmac(ByteArrayBuffer pkt, int rocIn) {
        this.mac.update(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
        this.writeRoc(rocIn);
        this.mac.update(this.rbStore, 0, this.rbStore.length);
        return this.mac.doFinal();
    }

    public int getAuthTagLength() {
        return this.policy.getAuthTagLength();
    }

    public int getSsrc() {
        return this.ssrc;
    }
}

