/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.validation.swingui;

import ca.sqlpower.validation.Status;
import ca.sqlpower.validation.ValidateResult;
import ca.sqlpower.validation.Validator;
import ca.sqlpower.validation.swingui.StatusComponent;
import ca.sqlpower.validation.swingui.ValidationHandler;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class FormValidationHandler
implements ValidationHandler {
    private static final Logger logger = Logger.getLogger(FormValidationHandler.class);
    protected static final Color COLOR_ERROR = new Color(255, 170, 170);
    protected static final Color COLOR_WARNING = Color.YELLOW;
    private boolean skipDisabled;
    private StatusComponent display;
    private List<Action> actions;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private List<ValidateObject> objects;
    private ValidateResult worstValidationStatus;
    private boolean havePerformedValidation;

    public FormValidationHandler(StatusComponent display) {
        this(display, null, false);
    }

    public FormValidationHandler(StatusComponent display, List<Action> actions, boolean skipDisabled) {
        this.display = display;
        this.objects = new ArrayList<ValidateObject>();
        this.actions = actions;
        this.skipDisabled = skipDisabled;
    }

    public FormValidationHandler(StatusComponent display, List<Action> actions) {
        this(display, actions, false);
    }

    public FormValidationHandler(StatusComponent display, boolean skipDisabled) {
        this(display, null, skipDisabled);
    }

    @Override
    public void setValidatedAction(Action action) {
        this.actions = new ArrayList<Action>();
        this.actions.add(action);
        this.performFormValidation();
    }

    @Override
    public void addValidateObject(final JComponent component, Validator validator) {
        final ValidateObject validateObject = new ValidateObject(component, validator);
        this.objects.add(validateObject);
        if (component instanceof JTextComponent) {
            validateObject.setObject(((JTextComponent)component).getText());
            ((JTextComponent)component).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.doStuff();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.doStuff();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.doStuff();
                }

                private void doStuff() {
                    validateObject.setObject(((JTextComponent)component).getText());
                    FormValidationHandler.this.performFormValidation();
                }
            });
        } else if (component instanceof JComboBox) {
            validateObject.setObject(((JComboBox)component).getSelectedItem());
            ((JComboBox)component).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    validateObject.setObject(((JComboBox)component).getSelectedItem());
                    FormValidationHandler.this.performFormValidation();
                }
            });
        } else if (component instanceof AbstractButton) {
            validateObject.setObject(((AbstractButton)component).isSelected());
            ((AbstractButton)component).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    validateObject.setObject(((AbstractButton)component).isSelected());
                    FormValidationHandler.this.performFormValidation();
                }
            });
        } else if (component instanceof JTable) {
            JTable table = (JTable)component;
            final TableModel tableModel = table.getModel();
            validateObject.setObject(tableModel);
            final TableModelListener tableModelListener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent arg0) {
                    validateObject.setObject(tableModel);
                    FormValidationHandler.this.performFormValidation();
                }
            };
            tableModel.addTableModelListener(tableModelListener);
            table.addPropertyChangeListener("model", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TableModel old = (TableModel)evt.getOldValue();
                    old.removeTableModelListener(tableModelListener);
                    TableModel newModel = (TableModel)evt.getNewValue();
                    newModel.addTableModelListener(tableModelListener);
                    FormValidationHandler.this.performFormValidation();
                }
            });
        } else if (component instanceof JSpinner) {
            final JSpinner jsp = (JSpinner)component;
            jsp.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    validateObject.setObject(jsp.getValue());
                    FormValidationHandler.this.performFormValidation();
                }
            });
            jsp.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    validateObject.setObject(jsp.getValue().toString());
                    FormValidationHandler.this.performFormValidation();
                }
            });
        } else {
            throw new IllegalArgumentException("Unsupported JComponent type:" + component.getClass());
        }
        this.performFormValidation();
    }

    public void addValidateObject(final JTextComponent textComponent, final JCheckBox checkBox, Validator validator, final boolean selected, final String defaultValid) {
        final ValidateObject validateObject = new ValidateObject(textComponent, validator);
        this.objects.add(validateObject);
        validateObject.setObject(textComponent.getText());
        textComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doStuff();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doStuff();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doStuff();
            }

            private void doStuff() {
                if (selected == checkBox.isSelected()) {
                    validateObject.setObject(textComponent.getText());
                } else {
                    validateObject.setObject(defaultValid);
                }
                FormValidationHandler.this.performFormValidation();
            }
        });
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (selected == checkBox.isSelected()) {
                    validateObject.setObject(textComponent.getText());
                } else {
                    validateObject.setObject(defaultValid);
                }
                FormValidationHandler.this.performFormValidation();
            }
        });
        this.performFormValidation();
    }

    public void performFormValidation() {
        ValidateResult worst = null;
        for (ValidateObject o : this.objects) {
            o.doValidate();
            if (o.getResult() == null) continue;
            if (o.getResult().getStatus() == Status.FAIL && (worst == null || worst.getStatus() != Status.FAIL)) {
                worst = o.getResult();
                continue;
            }
            if (o.getResult().getStatus() == Status.WARN && (worst == null || worst.getStatus() == Status.OK)) {
                worst = o.getResult();
                continue;
            }
            if (worst != null) continue;
            worst = o.getResult();
        }
        this.setWorstValidationStatus(worst);
        this.display.setResult(worst);
        this.setValidatedActionsEnabled(this.getWorstValidationStatus() == null || this.getWorstValidationStatus().getStatus() != Status.FAIL);
    }

    public void setValidatedActionsEnabled(boolean enabled) {
        if (this.actions != null) {
            for (Action a : this.actions) {
                a.setEnabled(enabled);
            }
        }
    }

    public ValidateResult getWorstValidationStatus() {
        return this.worstValidationStatus;
    }

    private void setWorstValidationStatus(ValidateResult result) {
        ValidateResult oldResult = this.worstValidationStatus;
        this.worstValidationStatus = result;
        this.pcs.firePropertyChange("worstValidationStatus", oldResult, result);
    }

    public List<String> getFailResults() {
        return this.getResults(Status.FAIL);
    }

    public List<String> getWarnResults() {
        return this.getResults(Status.WARN);
    }

    private List<String> getResults(Status status) {
        ArrayList<String> msg = new ArrayList<String>();
        for (ValidateObject o : this.objects) {
            if (o.getResult() == null || o.getResult().getStatus() != status) continue;
            msg.add(o.getMessage());
        }
        return msg;
    }

    public ValidateResult getResultOf(Object object) {
        for (ValidateObject o : this.objects) {
            if (object != o.getComponent()) continue;
            return o.getResult();
        }
        throw new IllegalArgumentException("Object:" + (object == null ? "null" : object) + " not found!");
    }

    public void removeValidateObject(JComponent com) {
        LinkedList<ValidateObject> removed = new LinkedList<ValidateObject>();
        for (ValidateObject vo : this.objects) {
            if (vo.component != com) continue;
            removed.add(vo);
        }
        for (ValidateObject vo : removed) {
            this.objects.remove(vo);
        }
        this.performFormValidation();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeSupport getPCS() {
        return this.pcs;
    }

    public boolean hasPerformedValidation() {
        return this.havePerformedValidation;
    }

    public void resetHasValidated() {
        this.havePerformedValidation = false;
    }

    private class ValidateObject {
        private JComponent component;
        private Object object;
        private Validator validator;
        private Color savedColor;
        private ValidateResult result;

        protected String getMessage() {
            StringBuffer msg = new StringBuffer();
            if (this.getResult() != null) {
                msg.append("[").append(this.getResult().getStatus().name()).append("]");
                msg.append(" ").append(this.getResult().getMessage());
            } else {
                msg.append(" unknown result");
            }
            return msg.toString();
        }

        protected ValidateObject(JComponent component, Validator validator) {
            this.component = component;
            this.validator = validator;
            this.savedColor = component.getBackground();
        }

        protected void doValidate() {
            this.result = FormValidationHandler.this.skipDisabled && !this.component.isEnabled() ? ValidateResult.createValidateResult(Status.OK, "") : this.validator.validate(this.object);
            FormValidationHandler.this.havePerformedValidation = true;
            switch (this.result.getStatus()) {
                case OK: {
                    this.component.setBackground(this.savedColor);
                    break;
                }
                case WARN: {
                    this.component.setBackground(COLOR_WARNING);
                    break;
                }
                case FAIL: {
                    this.component.setBackground(COLOR_ERROR);
                }
            }
        }

        protected Color getSavedColor() {
            return this.savedColor;
        }

        protected ValidateResult getResult() {
            return this.result;
        }

        protected void setObject(Object object) {
            this.object = object;
        }

        protected JComponent getComponent() {
            return this.component;
        }
    }
}

