/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.job.JobEntryLoader;
import org.pentaho.di.job.JobPlugin;
import org.pentaho.di.repository.PermissionMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.StepLoader;
import org.pentaho.di.trans.StepPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryCreationHelper {
    private Repository repository;
    private LogWriter log;
    private DatabaseMeta databaseMeta;
    private Database database;
    private StepLoader stepLoader;

    public RepositoryCreationHelper(Repository repository) {
        this.repository = repository;
        this.databaseMeta = this.repository.getDatabaseMeta();
        this.database = this.repository.getDatabase();
        this.log = LogWriter.getInstance();
        this.stepLoader = StepLoader.getInstance();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void createRepositorySchema(ProgressMonitorListener monitor, boolean upgrade, List<String> statements, boolean dryrun) throws KettleException {
        block491: {
            block490: {
                block488: {
                    block487: {
                        block486: {
                            block485: {
                                block484: {
                                    KEY = 9;
                                    this.log.logBasic(this.toString(), "Starting to create or modify the repository tables...", new Object[0]);
                                    message = (upgrade != false ? "Upgrading " : "Creating") + " the Kettle repository...";
                                    if (monitor != null) {
                                        monitor.beginTask(message, 31);
                                    }
                                    this.repository.setAutoCommit(true);
                                    table = new RowMeta();
                                    tablename = "R_REPOSITORY_LOG";
                                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                    if (monitor != null) {
                                        monitor.subTask("Checking table " + schemaTable);
                                    }
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_REPOSITORY_LOG", 5, KEY, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("REP_VERSION", 2, 255, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("LOG_DATE", 3));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("LOG_USER", 2, 255, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("OPERATION_DESC", 2, 2000000, 0));
                                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_REPOSITORY_LOG", false);
                                    if (!Const.isEmpty((String)sql)) {
                                        statements.add(sql);
                                        if (!dryrun) {
                                            try {
                                                if (this.log.isDetailed()) {
                                                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                                }
                                                this.database.execStatements(sql);
                                                if (!this.log.isDetailed()) ** GOTO lbl35
                                                this.log.logDetailed(this.toString(), "Created/altered table " + schemaTable, new Object[0]);
                                            }
                                            catch (KettleException dbe) {
                                                throw new KettleException("Unable to create or modify table " + schemaTable, (Throwable)dbe);
                                            }
                                        }
                                    } else if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                                    }
lbl35:
                                    // 6 sources

                                    if (!dryrun) {
                                        this.repository.insertLogEntry((upgrade != false ? "Upgrade" : "Creation") + " of the Kettle repository");
                                    }
                                    table = new RowMeta();
                                    tablename = "R_VERSION";
                                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                    if (monitor != null) {
                                        monitor.subTask("Checking table " + schemaTable);
                                    }
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_VERSION", 5, KEY, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("MAJOR_VERSION", 5, 3, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("MINOR_VERSION", 5, 3, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("UPGRADE_DATE", 3, 0, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("IS_UPGRADE", 4, 1, 0));
                                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_VERSION", false);
                                    create = false;
                                    if (!Const.isEmpty((String)sql)) {
                                        create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                                        statements.add(sql);
                                        if (!dryrun) {
                                            try {
                                                if (this.log.isDetailed()) {
                                                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                                }
                                                this.database.execStatements(sql);
                                                if (!this.log.isDetailed()) ** GOTO lbl68
                                                this.log.logDetailed(this.toString(), "Created/altered table " + schemaTable, new Object[0]);
                                            }
                                            catch (KettleException dbe) {
                                                throw new KettleException("Unable to create or modify table " + schemaTable, (Throwable)dbe);
                                            }
                                        }
                                    } else if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                                    }
lbl68:
                                    // 6 sources

                                    try {
                                        nextId = sql.toUpperCase().indexOf("CREATE TABLE") < 0 ? this.repository.getNextID(schemaTable, "ID_VERSION") : 1L;
                                        data = new Object[]{nextId, 3L, 2L, new Date(), upgrade};
                                        if (dryrun) {
                                            sql = this.database.getSQLOutput(null, "R_VERSION", (RowMetaInterface)table, data, null);
                                            statements.add(sql);
                                        } else {
                                            this.database.execStatement("INSERT INTO " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_VERSION") + " VALUES(?, ?, ?, ?, ?)", (RowMetaInterface)table, data);
                                        }
                                    }
                                    catch (KettleException e) {
                                        throw new KettleException("Unable to insert new version log record into " + schemaTable, (Throwable)e);
                                    }
                                    ok_database_type = true;
                                    table = new RowMeta();
                                    tablename = "R_DATABASE_TYPE";
                                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                    if (monitor != null) {
                                        monitor.subTask("Checking table " + schemaTable);
                                    }
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_TYPE", 5, KEY, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
                                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DATABASE_TYPE", false);
                                    create = false;
                                    if (!Const.isEmpty((String)sql)) {
                                        create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                                        statements.add(sql);
                                        if (!dryrun) {
                                            try {
                                                if (this.log.isDetailed()) {
                                                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                                }
                                                this.database.execStatements(sql);
                                                if (!this.log.isDetailed()) ** GOTO lbl110
                                                this.log.logDetailed(this.toString(), "Created/altered table " + schemaTable, new Object[0]);
                                            }
                                            catch (KettleException dbe) {
                                                throw new KettleException("Unable to create or modify table " + schemaTable, (Throwable)dbe);
                                            }
                                        }
                                    } else if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                                    }
lbl110:
                                    // 6 sources

                                    if (ok_database_type) {
                                        code = DatabaseMeta.getDBTypeDescList();
                                        desc = DatabaseMeta.getDBTypeDescLongList();
                                        if (!dryrun) {
                                            this.database.prepareInsert((RowMetaInterface)table, null, tablename);
                                        }
                                        for (i = 1; i < code.length; ++i) {
                                            lookup = null;
                                            if (upgrade) {
                                                lookup = this.database.getOneRow("SELECT " + this.repository.quote("ID_DATABASE_TYPE") + " FROM " + schemaTable + " WHERE " + this.repository.quote("CODE") + " = '" + code[i] + "'");
                                            }
                                            if (lookup != null) continue;
                                            nextid = i;
                                            if (!create) {
                                                nextid = this.repository.getNextDatabaseTypeID();
                                            }
                                            tableData = new Object[]{new Long(nextid), code[i], desc[i]};
                                            if (dryrun) {
                                                sql = this.database.getSQLOutput(null, tablename, (RowMetaInterface)table, tableData, null);
                                                statements.add(sql);
                                                continue;
                                            }
                                            this.database.setValuesInsert((RowMetaInterface)table, tableData);
                                            this.database.insertRow();
                                        }
                                        try {
                                            if (!dryrun) {
                                                this.database.closeInsert();
                                            }
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed(this.toString(), "Populated table " + schemaTable, new Object[0]);
                                            }
                                        }
                                        catch (KettleException dbe) {
                                            throw new KettleException("Unable to close insert after populating table " + schemaTable, (Throwable)dbe);
                                        }
                                    }
                                    if (monitor != null) {
                                        monitor.worked(1);
                                    }
                                    ok_database_contype = true;
                                    table = new RowMeta();
                                    tablename = "R_DATABASE_CONTYPE";
                                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                    if (monitor != null) {
                                        monitor.subTask("Checking table " + schemaTable);
                                    }
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_CONTYPE", 5, KEY, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
                                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DATABASE_CONTYPE", false);
                                    if (!Const.isEmpty((String)sql)) {
                                        statements.add(sql);
                                        if (!dryrun) {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                            }
                                            this.database.execStatements(sql);
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                                            }
                                        }
                                    } else if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                                    }
                                    if (ok_database_contype) {
                                        code = DatabaseMeta.dbAccessTypeCode;
                                        desc = DatabaseMeta.dbAccessTypeDesc;
                                        if (!dryrun) {
                                            this.database.prepareInsert((RowMetaInterface)table, null, tablename);
                                        }
                                        for (i = 0; i < code.length; ++i) {
                                            lookup = null;
                                            if (upgrade) {
                                                lookup = this.database.getOneRow("SELECT " + this.repository.quote("ID_DATABASE_CONTYPE") + " FROM " + schemaTable + " WHERE " + this.repository.quote("CODE") + " = '" + code[i] + "'");
                                            }
                                            if (lookup != null) continue;
                                            nextid = i + 1;
                                            if (!create) {
                                                nextid = this.repository.getNextDatabaseConnectionTypeID();
                                            }
                                            tableData = new Object[]{new Long(nextid), code[i], desc[i]};
                                            if (dryrun) {
                                                sql = this.database.getSQLOutput(null, tablename, (RowMetaInterface)table, tableData, null);
                                                statements.add(sql);
                                                continue;
                                            }
                                            this.database.setValuesInsert((RowMetaInterface)table, tableData);
                                            this.database.insertRow();
                                        }
                                        try {
                                            if (!dryrun) {
                                                this.database.closeInsert();
                                            }
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed(this.toString(), "Populated table " + schemaTable, new Object[0]);
                                            }
                                        }
                                        catch (KettleException dbe) {
                                            throw new KettleException("Unable to close insert after populating table " + schemaTable, (Throwable)dbe);
                                        }
                                    }
                                    if (monitor != null) {
                                        monitor.worked(1);
                                    }
                                    table = new RowMeta();
                                    tablename = "R_NOTE";
                                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                    if (monitor != null) {
                                        monitor.subTask("Checking table " + schemaTable);
                                    }
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_NOTE", 5, KEY, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 2000000, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_X", 5, 6, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_Y", 5, 6, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_WIDTH", 5, 6, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_HEIGHT", 5, 6, 0));
                                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_NOTE", false);
                                    if (!Const.isEmpty((String)sql)) {
                                        statements.add(sql);
                                        if (!dryrun) {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                            }
                                            this.database.execStatements(sql);
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                                            }
                                        }
                                    } else if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                                    }
                                    if (monitor != null) {
                                        monitor.worked(1);
                                    }
                                    table = new RowMeta();
                                    tablename = "R_DATABASE";
                                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                    if (monitor != null) {
                                        monitor.subTask("Checking table " + schemaTable);
                                    }
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE", 5, KEY, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_TYPE", 5, KEY, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_CONTYPE", 5, KEY, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("HOST_NAME", 2, 255, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("DATABASE_NAME", 2, 255, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("PORT", 5, 7, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("USERNAME", 2, 255, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("PASSWORD", 2, 255, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("SERVERNAME", 2, 255, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("DATA_TBS", 2, 255, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("INDEX_TBS", 2, 255, 0));
                                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DATABASE", false);
                                    if (!Const.isEmpty((String)sql)) {
                                        statements.add(sql);
                                        if (!dryrun) {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                            }
                                            this.database.execStatements(sql);
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                                            }
                                        }
                                    } else if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                                    }
                                    if (monitor != null) {
                                        monitor.worked(1);
                                    }
                                    table = new RowMeta();
                                    tablename = "R_DATABASE_ATTRIBUTE";
                                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                    if (monitor != null) {
                                        monitor.subTask("Checking table " + schemaTable);
                                    }
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_ATTRIBUTE", 5, KEY, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE", 5, KEY, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                                    table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 2000000, 0));
                                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DATABASE_ATTRIBUTE", false);
                                    if (!Const.isEmpty((String)sql)) {
                                        statements.add(sql);
                                        if (!dryrun) {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                            }
                                            this.database.execStatements(sql);
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                                            }
                                        }
                                        try {
                                            indexname = "IDX_" + schemaTable.substring(2) + "_AK";
                                            keyfield = new String[]{"ID_DATABASE", "CODE"};
                                            if (this.database.checkIndexExists(schemaTable, keyfield)) break block484;
                                            sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                                            statements.add(sql);
                                            if (!dryrun) {
                                                if (this.log.isDetailed()) {
                                                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                                }
                                                this.database.execStatements(sql);
                                                if (this.log.isDetailed()) {
                                                    this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + schemaTable, new Object[0]);
                                                }
                                            }
                                        }
                                        catch (KettleException kdbe) {}
                                    } else if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                                    }
                                }
                                if (monitor != null) {
                                    monitor.worked(1);
                                }
                                table = new RowMeta();
                                tablename = "R_DIRECTORY";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DIRECTORY", 5, KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DIRECTORY_PARENT", 5, KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("DIRECTORY_NAME", 2, 255, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DIRECTORY", false);
                                if (!Const.isEmpty((String)sql)) {
                                    statements.add(sql);
                                    if (!dryrun) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                        }
                                        this.database.execStatements(sql);
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                                        }
                                    }
                                    try {
                                        indexname = "IDX_" + schemaTable.substring(2) + "_AK";
                                        keyfield = new String[]{"ID_DIRECTORY_PARENT", "DIRECTORY_NAME"};
                                        if (this.database.checkIndexExists(schemaTable, keyfield)) break block485;
                                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                                        statements.add(sql);
                                        if (!dryrun) {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                            }
                                            this.database.execStatements(sql);
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + schemaTable, new Object[0]);
                                            }
                                        }
                                    }
                                    catch (KettleException kdbe) {}
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                                }
                            }
                            if (monitor != null) {
                                monitor.worked(1);
                            }
                            table = new RowMeta();
                            tablename = "R_TRANSFORMATION";
                            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                            if (monitor != null) {
                                monitor.subTask("Checking table " + schemaTable);
                            }
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DIRECTORY", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 2000000, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("EXTENDED_DESCRIPTION", 2, 2000000, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("TRANS_VERSION", 2, 255, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("TRANS_STATUS", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_READ", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_WRITE", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_INPUT", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_OUTPUT", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_UPDATE", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_LOG", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME_LOG", 2, 255, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("USE_BATCHID", 4, 1, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("USE_LOGFIELD", 4, 1, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_MAXDATE", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME_MAXDATE", 2, 255, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("FIELD_NAME_MAXDATE", 2, 255, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("OFFSET_MAXDATE", 1, 12, 2));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("DIFF_MAXDATE", 1, 12, 2));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("CREATED_USER", 2, 255, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("CREATED_DATE", 3, 20, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("MODIFIED_USER", 2, 255, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("MODIFIED_DATE", 3, 20, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("SIZE_ROWSET", 5, KEY, 0));
                            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANSFORMATION", false);
                            if (!Const.isEmpty((String)sql)) {
                                statements.add(sql);
                                if (!dryrun) {
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                    }
                                    this.database.execStatements(sql);
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                                    }
                                }
                            } else if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                            }
                            if (this.database.checkTableExists(schemaTable) && (rows = this.database.getRows(sql = "SELECT * FROM " + schemaTable + " WHERE " + this.repository.quote("ID_DIRECTORY") + " IS NULL", 1)) != null && rows.size() > 0) {
                                sql = "UPDATE " + schemaTable + " SET " + this.repository.quote("ID_DIRECTORY") + "=0 WHERE " + this.repository.quote("ID_DIRECTORY") + " IS NULL";
                                statements.add(sql);
                                if (!dryrun) {
                                    this.database.execStatement(sql);
                                }
                            }
                            if (monitor != null) {
                                monitor.worked(1);
                            }
                            table = new RowMeta();
                            tablename = "R_TRANS_ATTRIBUTE";
                            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                            if (monitor != null) {
                                monitor.subTask("Checking table " + schemaTable);
                            }
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANS_ATTRIBUTE", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("NR", 5, 6, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_NUM", 5, 18, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 2000000, 0));
                            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_ATTRIBUTE", false);
                            if (!Const.isEmpty((String)sql)) {
                                statements.add(sql);
                                if (!dryrun) {
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                    }
                                    this.database.execStatements(sql);
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                                    }
                                }
                                try {
                                    indexname = "IDX_TRANS_ATTRIBUTE_LOOKUP";
                                    keyfield = new String[]{"ID_TRANSFORMATION", "CODE", "NR"};
                                    if (this.database.checkIndexExists(schemaTable, keyfield)) break block486;
                                    sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                                    statements.add(sql);
                                    if (!dryrun) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                        }
                                        this.database.execStatements(sql);
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + schemaTable, new Object[0]);
                                        }
                                    }
                                }
                                catch (KettleException kdbe) {}
                            } else if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                            }
                        }
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                        table = new RowMeta();
                        tablename = "R_JOB_ATTRIBUTE";
                        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                        if (monitor != null) {
                            monitor.subTask("Checking table " + schemaTable);
                        }
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB_ATTRIBUTE", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("NR", 5, 6, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_NUM", 5, 18, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 2000000, 0));
                        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOB_ATTRIBUTE", false);
                        if (!Const.isEmpty((String)sql)) {
                            statements.add(sql);
                            if (!dryrun) {
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                }
                                this.database.execStatements(sql);
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                                }
                            }
                            try {
                                indexname = "IDX_JOB_ATTRIBUTE_LOOKUP";
                                keyfield = new String[]{"ID_JOB", "CODE", "NR"};
                                if (this.database.checkIndexExists(schemaTable, keyfield)) break block487;
                                sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                                statements.add(sql);
                                if (!dryrun) {
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                    }
                                    this.database.execStatements(sql);
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + schemaTable, new Object[0]);
                                    }
                                }
                            }
                            catch (KettleException kdbe) {}
                        } else if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                        }
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_DEPENDENCY";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DEPENDENCY", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("FIELD_NAME", 2, 255, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DEPENDENCY", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_PARTITION_SCHEMA";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_PARTITION_SCHEMA", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("DYNAMIC_DEFINITION", 4, 1, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("PARTITIONS_PER_SLAVE", 2, 255, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_PARTITION_SCHEMA", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_PARTITION";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_PARTITION", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_PARTITION_SCHEMA", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("PARTITION_ID", 2, 255, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_PARTITION", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_TRANS_PARTITION_SCHEMA";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANS_PARTITION_SCHEMA", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_PARTITION_SCHEMA", 5, KEY, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_PARTITION_SCHEMA", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_CLUSTER";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CLUSTER", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("BASE_PORT", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("SOCKETS_BUFFER_SIZE", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("SOCKETS_FLUSH_INTERVAL", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("SOCKETS_COMPRESSED", 4, 0, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("DYNAMIC_CLUSTER", 4, 0, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_CLUSTER", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_SLAVE";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_SLAVE", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("HOST_NAME", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("PORT", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("USERNAME", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("PASSWORD", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("PROXY_HOST_NAME", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("PROXY_PORT", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("NON_PROXY_HOSTS", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("MASTER", 4));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_SLAVE", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_CLUSTER_SLAVE";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CLUSTER_SLAVE", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CLUSTER", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_SLAVE", 5, KEY, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_CLUSTER_SLAVE", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_TRANS_SLAVE";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANS_SLAVE", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_SLAVE", 5, KEY, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_SLAVE", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_TRANS_CLUSTER";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANS_CLUSTER", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CLUSTER", 5, KEY, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_CLUSTER", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_TRANS_HOP";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANS_HOP", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_FROM", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_TO", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ENABLED", 4, 1, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_HOP", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_TRANS_STEP_CONDITION";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CONDITION", 5, KEY, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_CONDITION";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CONDITION", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CONDITION_PARENT", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("NEGATED", 4, 1, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("OPERATOR", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("LEFT_NAME", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("CONDITION_FUNCTION", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("RIGHT_NAME", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_VALUE_RIGHT", 5, KEY, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_CONDITION", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    tablename = "R_VALUE";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table = new RowMeta();
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_VALUE", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_TYPE", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("IS_NULL", 4, 1, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_VALUE", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    ok_step_type = true;
                    table = new RowMeta();
                    tablename = "R_STEP_TYPE";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_TYPE", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("HELPTEXT", 2, 255, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_STEP_TYPE", false);
                    create = false;
                    if (!Const.isEmpty((String)sql)) {
                        create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (ok_step_type && !dryrun) {
                        this.updateStepTypes(statements, dryrun, create);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Populated table " + schemaTable, new Object[0]);
                        }
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_STEP";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 2000000, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_TYPE", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("DISTRIBUTE", 4, 1, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("COPIES", 5, 3, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_X", 5, 6, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_Y", 5, 6, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_DRAW", 4, 1, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_STEP", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    tablename = "R_STEP_ATTRIBUTE";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table = new RowMeta();
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_ATTRIBUTE", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("NR", 5, 6, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_NUM", 5, 18, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 2000000, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_STEP_ATTRIBUTE", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                            }
                        }
                        try {
                            indexname = "IDX_" + schemaTable.substring(2) + "_LOOKUP";
                            keyfield = new String[]{"ID_STEP", "CODE", "NR"};
                            if (this.database.checkIndexExists(schemaTable, keyfield)) break block488;
                            sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                            statements.add(sql);
                            if (!dryrun) {
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                }
                                this.database.execStatements(sql);
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + schemaTable, new Object[0]);
                                }
                            }
                        }
                        catch (KettleException kdbe) {}
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                    }
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                tablename = "R_STEP_DATABASE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table = new RowMeta();
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE", 5, KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                        }
                    }
                    try {
                        indexname = "IDX_" + schemaTable.substring(2) + "_LU1";
                        keyfield = new String[]{"ID_TRANSFORMATION"};
                        if (!this.database.checkIndexExists(schemaTable, keyfield)) {
                            sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, false, false, false);
                            statements.add(sql);
                            if (!dryrun) {
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                }
                                this.database.execStatements(sql);
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + schemaTable, new Object[0]);
                                }
                            }
                        }
                    }
                    catch (KettleException kdbe) {
                        // empty catch block
                    }
                    try {
                        indexname = "IDX_" + schemaTable.substring(2) + "_LU2";
                        keyfield = new String[]{"ID_DATABASE"};
                        if (!this.database.checkIndexExists(schemaTable, keyfield)) {
                            sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, false, false, false);
                            statements.add(sql);
                            if (!dryrun) {
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                                }
                                this.database.execStatements(sql);
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + schemaTable, new Object[0]);
                                }
                            }
                        }
                    }
                    catch (KettleException kdbe) {}
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_TRANS_NOTE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_NOTE", 5, KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                ok_loglevel = true;
                tablename = "R_LOGLEVEL";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table = new RowMeta();
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_LOGLEVEL", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_LOGLEVEL", false);
                create = false;
                if (!Const.isEmpty((String)sql)) {
                    create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                }
                if (ok_loglevel) {
                    code = LogWriter.logLevelDescription;
                    desc = LogWriter.log_level_desc_long;
                    if (!dryrun) {
                        this.database.prepareInsert((RowMetaInterface)table, null, tablename);
                    }
                    for (i = 1; i < code.length; ++i) {
                        lookup = null;
                        if (upgrade) {
                            lookup = this.database.getOneRow("SELECT " + this.repository.quote("ID_LOGLEVEL") + " FROM " + schemaTable + " WHERE " + this.database.getDatabaseMeta().quoteField("CODE") + " = '" + code[i] + "'");
                        }
                        if (lookup != null) continue;
                        nextid = i;
                        if (!create) {
                            nextid = this.repository.getNextLoglevelID();
                        }
                        tableData = new RowMetaAndData();
                        tableData.addValue(new ValueMeta("ID_LOGLEVEL", 5), (Object)new Long(nextid));
                        tableData.addValue(new ValueMeta("CODE", 2), (Object)code[i]);
                        tableData.addValue(new ValueMeta("DESCRIPTION", 2), (Object)desc[i]);
                        if (dryrun) {
                            sql = this.database.getSQLOutput(null, tablename, tableData.getRowMeta(), tableData.getData(), null);
                            statements.add(sql);
                            continue;
                        }
                        this.database.setValuesInsert(tableData.getRowMeta(), tableData.getData());
                        this.database.insertRow();
                    }
                    try {
                        if (!dryrun) {
                            this.database.closeInsert();
                        }
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Populated table " + schemaTable, new Object[0]);
                        }
                    }
                    catch (KettleException dbe) {
                        throw new KettleException("Unable to close insert after populating table " + schemaTable, (Throwable)dbe);
                    }
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_LOG";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_LOG", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_LOGLEVEL", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("LOGTYPE", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("FILENAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("FILEEXTENTION", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ADD_DATE", 4, 1, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ADD_TIME", 4, 1, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_LOG", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME_LOG", 2, 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_LOG", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_JOB";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DIRECTORY", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 2000000, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("EXTENDED_DESCRIPTION", 2, 2000000, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("JOB_VERSION", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("JOB_STATUS", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_LOG", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME_LOG", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("CREATED_USER", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("CREATED_DATE", 3, 20, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("MODIFIED_USER", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("MODIFIED_DATE", 3, 20, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("USE_BATCH_ID", 4, 0, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("PASS_BATCH_ID", 4, 0, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("USE_LOGFIELD", 4, 0, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("SHARED_FILE", 2, 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOB", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                ok_jobentry_type = true;
                table = new RowMeta();
                tablename = "R_JOBENTRY_TYPE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_TYPE", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOBENTRY_TYPE", false);
                create = false;
                if (!Const.isEmpty((String)sql)) {
                    create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                }
                if (ok_jobentry_type) {
                    this.updateJobEntryTypes(statements, dryrun, create);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Populated table " + schemaTable, new Object[0]);
                    }
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_JOBENTRY";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_TYPE", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 2000000, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOBENTRY", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_JOBENTRY_COPY";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_COPY", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_TYPE", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("NR", 5, 4, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_X", 5, 6, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_Y", 5, 6, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_DRAW", 4, 1, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("PARALLEL", 4, 1, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOBENTRY_COPY", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_JOBENTRY_ATTRIBUTE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_ATTRIBUTE", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("NR", 5, 6, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_NUM", 1, 13, 2));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 2000000, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOBENTRY_ATTRIBUTE", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                        }
                    }
                    try {
                        indexname = "IDX_" + schemaTable.substring(2) + "_LOOKUP";
                        keyfield = new String[]{"ID_JOBENTRY_ATTRIBUTE", "CODE", "NR"};
                        if (this.database.checkIndexExists(schemaTable, keyfield)) break block490;
                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + schemaTable, new Object[0]);
                            }
                        }
                    }
                    catch (KettleException kdbe) {}
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_JOB_HOP";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB_HOP", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_COPY_FROM", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_COPY_TO", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ENABLED", 4, 1, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("EVALUATION", 4, 1, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("UNCONDITIONAL", 4, 1, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOB_HOP", false);
            if (!Const.isEmpty((String)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_JOB_NOTE";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_NOTE", 5, KEY, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
            if (!Const.isEmpty((String)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            profiles = new Hashtable<String, Long>();
            ok_profile = true;
            tablename = "R_PROFILE";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table = new RowMeta();
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_PROFILE", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_PROFILE", false);
            create = false;
            if (!Const.isEmpty((String)sql)) {
                create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
            }
            if (ok_profile) {
                code = new String[]{"Administrator", "User", "Read-only"};
                desc = new String[]{"Administrator profile, manage users", "Normal user, all tools", "Read-only users"};
                if (!dryrun) {
                    this.database.prepareInsert((RowMetaInterface)table, null, tablename);
                }
                for (i = 0; i < code.length; ++i) {
                    lookup = null;
                    if (upgrade) {
                        lookup = this.database.getOneRow("SELECT " + this.repository.quote("ID_PROFILE") + " FROM " + schemaTable + " WHERE " + this.repository.quote("NAME") + " = '" + code[i] + "'");
                    }
                    if (lookup != null) continue;
                    nextid = i + 1;
                    if (!create) {
                        nextid = this.repository.getNextProfileID();
                    }
                    tableData = new RowMetaAndData();
                    tableData.addValue(new ValueMeta("ID_PROFILE", 5), (Object)new Long(nextid));
                    tableData.addValue(new ValueMeta("NAME", 2), (Object)code[i]);
                    tableData.addValue(new ValueMeta("DESCRIPTION", 2), (Object)desc[i]);
                    if (dryrun) {
                        sql = this.database.getSQLOutput(null, tablename, tableData.getRowMeta(), tableData.getData(), null);
                        statements.add(sql);
                    } else {
                        this.database.setValuesInsert(tableData);
                        this.database.insertRow();
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Inserted new row into table " + schemaTable + " : " + table, new Object[0]);
                        }
                    }
                    profiles.put(code[i], new Long(nextid));
                }
                try {
                    if (!dryrun) {
                        this.database.closeInsert();
                    }
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Populated table " + schemaTable, new Object[0]);
                    }
                }
                catch (KettleException dbe) {
                    throw new KettleException("Unable to close insert after populating table " + schemaTable, (Throwable)dbe);
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            users = new Hashtable<String, Long>();
            ok_user = true;
            table = new RowMeta();
            tablename = "R_USER";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_USER", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_PROFILE", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("LOGIN", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("PASSWORD", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ENABLED", 4, 1, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_USER", false);
            create = false;
            if (!Const.isEmpty((String)sql)) {
                create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
            }
            if (ok_user) {
                user = new String[]{"admin", "guest"};
                pass = new String[]{"admin", "guest"};
                code = new String[]{"Administrator", "Guest account"};
                desc = new String[]{"User manager", "Read-only guest account"};
                prof = new String[]{"Administrator", "Read-only"};
                if (!dryrun) {
                    this.database.prepareInsert((RowMetaInterface)table, null, tablename);
                }
                for (i = 0; i < user.length; ++i) {
                    lookup = null;
                    if (upgrade) {
                        lookup = this.database.getOneRow("SELECT " + this.repository.quote("ID_USER") + " FROM " + schemaTable + " WHERE " + this.repository.quote("LOGIN") + " = '" + user[i] + "'");
                    }
                    if (lookup != null) continue;
                    nextid = i + 1;
                    if (!create) {
                        nextid = this.repository.getNextUserID();
                    }
                    password = Encr.encryptPassword((String)pass[i]);
                    profileID = (Long)profiles.get(prof[i]);
                    id_profile = -1L;
                    if (profileID != null) {
                        id_profile = profileID;
                    }
                    tableData = new RowMetaAndData();
                    tableData.addValue(new ValueMeta("ID_USER", 5), (Object)nextid);
                    tableData.addValue(new ValueMeta("ID_PROFILE", 5), (Object)id_profile);
                    tableData.addValue(new ValueMeta("LOGIN", 2), (Object)user[i]);
                    tableData.addValue(new ValueMeta("PASSWORD", 2), (Object)password);
                    tableData.addValue(new ValueMeta("NAME", 2), (Object)code[i]);
                    tableData.addValue(new ValueMeta("DESCRIPTION", 2), (Object)desc[i]);
                    tableData.addValue(new ValueMeta("ENABLED", 4), (Object)Boolean.TRUE);
                    if (dryrun) {
                        sql = this.database.getSQLOutput(null, tablename, tableData.getRowMeta(), tableData.getData(), null);
                        statements.add(sql);
                    } else {
                        this.database.setValuesInsert(tableData);
                        this.database.insertRow();
                    }
                    users.put(user[i], new Long(nextid));
                }
                try {
                    if (!dryrun) {
                        this.database.closeInsert();
                    }
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Populated table " + schemaTable, new Object[0]);
                    }
                }
                catch (KettleException dbe) {
                    throw new KettleException("Unable to close insert after populating table " + schemaTable, (Throwable)dbe);
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            permissions = new Hashtable<String, Long>();
            ok_permission = true;
            table = new RowMeta();
            tablename = "R_PERMISSION";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_PERMISSION", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_PERMISSION", false);
            create = false;
            if (!Const.isEmpty((String)sql)) {
                create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
            }
            if (ok_permission) {
                code = PermissionMeta.permissionTypeCode;
                desc = PermissionMeta.permissionTypeDesc;
                if (!dryrun) {
                    this.database.prepareInsert((RowMetaInterface)table, null, tablename);
                }
                for (i = 1; i < code.length; ++i) {
                    lookup = null;
                    if (upgrade) {
                        lookup = this.database.getOneRow("SELECT " + this.repository.quote("ID_PERMISSION") + " FROM " + schemaTable + " WHERE " + this.repository.quote("CODE") + " = '" + code[i] + "'");
                    }
                    if (lookup != null) continue;
                    nextid = i;
                    if (!create) {
                        nextid = this.repository.getNextPermissionID();
                    }
                    tableData = new RowMetaAndData();
                    tableData.addValue(new ValueMeta("ID_PERMISSION", 5), (Object)new Long(nextid));
                    tableData.addValue(new ValueMeta("CODE", 2), (Object)code[i]);
                    tableData.addValue(new ValueMeta("DESCRIPTION", 2), (Object)desc[i]);
                    if (dryrun) {
                        sql = this.database.getSQLOutput(null, tablename, tableData.getRowMeta(), tableData.getData(), null);
                        statements.add(sql);
                    } else {
                        this.database.setValuesInsert(tableData);
                        this.database.insertRow();
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Inserted new row into table " + schemaTable + " : " + table, new Object[0]);
                        }
                    }
                    permissions.put(code[i], new Long(nextid));
                }
                try {
                    if (!dryrun) {
                        this.database.closeInsert();
                    }
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Populated table " + schemaTable, new Object[0]);
                    }
                }
                catch (KettleException dbe) {
                    throw new KettleException("Unable to close insert after populating table " + schemaTable, (Throwable)dbe);
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            ok_profile_permission = true;
            table = new RowMeta();
            tablename = "R_PROFILE_PERMISSION";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_PROFILE", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_PERMISSION", 5, KEY, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
            create = false;
            if (!Const.isEmpty((String)sql)) {
                create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Created or altered table " + schemaTable, new Object[0]);
                    }
                }
                try {
                    indexname = "IDX_" + schemaTable.substring(2) + "_PK";
                    keyfield = new String[]{"ID_PROFILE", "ID_PERMISSION"};
                    if (this.database.checkIndexExists(schemaTable, keyfield)) break block491;
                    sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql, new Object[0]);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + schemaTable, new Object[0]);
                        }
                    }
                }
                catch (KettleException kdbe) {}
            } else if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Table " + schemaTable + " is OK.", new Object[0]);
            }
        }
        if (ok_profile_permission) {
            if (!dryrun) {
                this.database.prepareInsert((RowMetaInterface)table, null, tablename);
            }
            profileID = (Long)profiles.get("Administrator");
            id_profile = -1L;
            if (profileID != null) {
                id_profile = profileID;
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Administrator profile id = " + id_profile, new Object[0]);
            }
            perms = new String[]{PermissionMeta.permissionTypeCode[2], PermissionMeta.permissionTypeCode[3], PermissionMeta.permissionTypeCode[4], PermissionMeta.permissionTypeCode[5]};
            for (i = 0; i < perms.length; ++i) {
                permissionID = (Long)permissions.get(perms[i]);
                id_permission = -1L;
                if (permissionID != null) {
                    id_permission = permissionID;
                }
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "Permission id for '" + perms[i] + "' = " + id_permission, new Object[0]);
                }
                lookup = null;
                if (upgrade) {
                    lookupSQL = "SELECT " + this.repository.quote("ID_PROFILE") + " FROM " + schemaTable + " WHERE " + this.repository.quote("ID_PROFILE") + "=" + id_profile + " AND +" + this.repository.quote("ID_PERMISSION") + "=" + id_permission;
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Executing SQL: " + lookupSQL, new Object[0]);
                    }
                    lookup = this.database.getOneRow(lookupSQL);
                }
                if (lookup == null) {
                    insertSQL = "INSERT INTO " + schemaTable + "(" + this.repository.quote("ID_PROFILE") + ", " + this.repository.quote("ID_PERMISSION") + ")" + " VALUES(" + id_profile + "," + id_permission + ")";
                    statements.add(insertSQL);
                    if (!dryrun) {
                        this.database.execStatement(insertSQL);
                    }
                    if (!this.log.isDetailed()) continue;
                    this.log.logDetailed(this.toString(), "insertSQL = [" + insertSQL + "]", new Object[0]);
                    continue;
                }
                if (!this.log.isDetailed()) continue;
                this.log.logDetailed(this.toString(), "Found id_profile=" + id_profile + ", id_permission=" + id_permission, new Object[0]);
            }
            profileID = (Long)profiles.get("User");
            id_profile = -1L;
            if (profileID != null) {
                id_profile = profileID;
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "User profile id = " + id_profile, new Object[0]);
            }
            perms = new String[]{PermissionMeta.permissionTypeCode[3], PermissionMeta.permissionTypeCode[4], PermissionMeta.permissionTypeCode[5]};
            for (i = 0; i < perms.length; ++i) {
                permissionID = (Long)permissions.get(perms[i]);
                id_permission = -1L;
                if (permissionID != null) {
                    id_permission = permissionID;
                }
                lookup = null;
                if (upgrade) {
                    lookup = this.database.getOneRow("SELECT " + this.repository.quote("ID_PROFILE") + " FROM " + schemaTable + " WHERE " + this.repository.quote("ID_PROFILE") + "=" + id_profile + " AND " + this.repository.quote("ID_PERMISSION") + "=" + id_permission);
                }
                if (lookup != null) continue;
                tableData = new RowMetaAndData();
                tableData.addValue(new ValueMeta("ID_PROFILE", 5), (Object)new Long(id_profile));
                tableData.addValue(new ValueMeta("ID_PERMISSION", 5), (Object)new Long(id_permission));
                if (dryrun) {
                    sql = this.database.getSQLOutput(null, tablename, tableData.getRowMeta(), tableData.getData(), null);
                    statements.add(sql);
                    continue;
                }
                this.database.setValuesInsert(tableData);
                this.database.insertRow();
            }
            try {
                if (!dryrun) {
                    this.database.closeInsert();
                }
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "Populated table " + schemaTable, new Object[0]);
                }
            }
            catch (KettleException dbe) {
                throw new KettleException("Unable to close insert after populating table " + schemaTable, (Throwable)dbe);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        this.log.logBasic(this.toString(), (upgrade != false ? "Upgraded" : "Created") + " " + Repository.repositoryTableNames.length + " repository tables.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> updateStepTypes(List<String> statements, boolean dryrun, boolean create) throws KettleException {
        Repository repository = this.repository;
        synchronized (repository) {
            for (int i = 0; i < this.stepLoader.nrStepsWithType(0); ++i) {
                StepPlugin sp = this.stepLoader.getStepWithType(0, i);
                long id = -1L;
                if (!create) {
                    id = this.repository.getStepTypeID(((String[])sp.getID())[0]);
                }
                if (id >= 0L) continue;
                id = i + 1;
                if (!create) {
                    id = this.repository.getNextStepTypeID();
                }
                RowMetaAndData table = new RowMetaAndData();
                table.addValue(new ValueMeta("ID_STEP_TYPE", 5), (Object)new Long(id));
                table.addValue(new ValueMeta("CODE", 2), (Object)((String[])sp.getID())[0]);
                table.addValue(new ValueMeta("DESCRIPTION", 2), (Object)sp.getDescription());
                table.addValue(new ValueMeta("HELPTEXT", 2), (Object)sp.getTooltip());
                if (dryrun) {
                    String sql = this.database.getSQLOutput(null, "R_STEP_TYPE", table.getRowMeta(), table.getData(), null);
                    statements.add(sql);
                    continue;
                }
                this.database.prepareInsert(table.getRowMeta(), null, "R_STEP_TYPE");
                this.database.setValuesInsert(table);
                this.database.insertRow();
                this.database.closeInsert();
            }
        }
        return statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobEntryTypes(List<String> statements, boolean dryrun, boolean create) throws KettleException {
        Repository repository = this.repository;
        synchronized (repository) {
            JobEntryLoader jobEntryLoader = JobEntryLoader.getInstance();
            JobPlugin[] jobPlugins = jobEntryLoader.getJobEntriesWithType(0);
            for (int i = 0; i < jobPlugins.length; ++i) {
                String type_desc = (String)jobPlugins[i].getID();
                String type_desc_long = jobPlugins[i].getDescription();
                long id = -1L;
                if (!create) {
                    id = this.repository.getJobEntryTypeID(type_desc);
                }
                if (id >= 0L) continue;
                id = i + 1;
                if (!create) {
                    id = this.repository.getNextJobEntryTypeID();
                }
                RowMetaAndData table = new RowMetaAndData();
                table.addValue(new ValueMeta("ID_JOBENTRY_TYPE", 5), (Object)new Long(id));
                table.addValue(new ValueMeta("CODE", 2), (Object)type_desc);
                table.addValue(new ValueMeta("DESCRIPTION", 2), (Object)type_desc_long);
                if (dryrun) {
                    String sql = this.database.getSQLOutput(null, "R_JOBENTRY_TYPE", table.getRowMeta(), table.getData(), null);
                    statements.add(sql);
                    continue;
                }
                this.database.prepareInsert(table.getRowMeta(), null, "R_JOBENTRY_TYPE");
                this.database.setValuesInsert(table);
                this.database.insertRow();
                this.database.closeInsert();
            }
        }
    }
}

