/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.interpreter;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.ConstantOperators;
import org.eclipse.xtext.xbase.interpreter.Context;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

public abstract class AbstractConstantExpressionsInterpreter {
    @Inject
    private ConstantOperators constantOperators;
    @Inject
    private OperatorMapping operatorMapping;

    protected Object evaluate(XExpression expression, Context ctx) {
        if (ctx.getAlreadyEvaluating().add(expression)) {
            try {
                Object object = this.internalEvaluate(expression, ctx);
                return object;
            }
            finally {
                ctx.getAlreadyEvaluating().remove(expression);
            }
        }
        throw this.notConstantExpression(expression);
    }

    protected Object _internalEvaluate(XExpression expression, Context ctx) {
        throw this.notConstantExpression(expression);
    }

    protected Object _internalEvaluate(Void nullValue, Context ctx) {
        throw this.notConstantExpression(null);
    }

    public ConstantExpressionEvaluationException notConstantExpression(XExpression expression) {
        String text = null;
        if (expression != null) {
            text = this.toText(expression);
        }
        return new ConstantExpressionEvaluationException("Not a constant expression : '" + text + "'", expression);
    }

    protected Object _internalEvaluate(XCastedExpression expression, Context ctx) {
        return this.evaluate(expression.getTarget(), ctx);
    }

    protected Object _internalEvaluate(XStringLiteral it, Context ctx) {
        return it.getValue();
    }

    protected Object _internalEvaluate(XBooleanLiteral it, Context ctx) {
        return it.isIsTrue();
    }

    protected Object _internalEvaluate(XAnnotation literal, Context ctx) {
        return literal;
    }

    protected Object _internalEvaluate(XTypeLiteral it, Context ctx) {
        return this.toTypeReference(it.getType(), it.getArrayDimensions().size());
    }

    protected JvmTypeReference toTypeReference(JvmType type, int arrayDimensions) {
        if (type == null) {
            return null;
        }
        JvmParameterizedTypeReference resultTypeRef = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        resultTypeRef.setType(type);
        int i = 0;
        while (i < arrayDimensions) {
            JvmGenericArrayTypeReference arrayRef = TypesFactory.eINSTANCE.createJvmGenericArrayTypeReference();
            arrayRef.setComponentType((JvmTypeReference)resultTypeRef);
            resultTypeRef = arrayRef;
            ++i;
        }
        return resultTypeRef;
    }

    protected Object _internalEvaluate(XBinaryOperation it, Context ctx) {
        Context context = ctx.cloneWithExpectation(null);
        Object left = this.evaluate(it.getLeftOperand(), context);
        Object right = this.evaluate(it.getRightOperand(), context);
        return this.evaluateBinaryOperation(it, left, right);
    }

    protected Object evaluateBinaryOperation(XBinaryOperation binaryOperation, Object left, Object right) {
        String op;
        block56: {
            op = this.getOperator(binaryOperation);
            if (op == null) break block56;
            switch (op) {
                case "+": {
                    return this.constantOperators.plus(left, right);
                }
                case "-": {
                    return this.constantOperators.minus(left, right);
                }
                case "*": {
                    return this.constantOperators.multiply(left, right);
                }
                case "/": {
                    return this.constantOperators.divide(left, right);
                }
                case "%": {
                    return this.constantOperators.modulo(left, right);
                }
                case "&&": {
                    return this.constantOperators.and(left, right);
                }
                case "||": {
                    return this.constantOperators.or(left, right);
                }
                case "<<": {
                    return this.constantOperators.shiftLeft(left, right);
                }
                case ">>": {
                    return this.constantOperators.shiftRight(left, right);
                }
                case ">>>": {
                    return this.constantOperators.shiftRightUnsigned(left, right);
                }
                case "<": {
                    return this.constantOperators.lessThan(left, right);
                }
                case ">": {
                    return this.constantOperators.greaterThan(left, right);
                }
                case "<=": {
                    return this.constantOperators.lessEquals(left, right);
                }
                case ">=": {
                    return this.constantOperators.greaterEquals(left, right);
                }
                case "==": 
                case "===": {
                    return this.constantOperators.same(left, right);
                }
                case "!=": 
                case "!==": {
                    return this.constantOperators.notSame(left, right);
                }
            }
            throw new ConstantExpressionEvaluationException("Couldn't evaluate binary operator '" + op + "' on values " + String.valueOf(left) + " and " + String.valueOf(right));
        }
        throw new ConstantExpressionEvaluationException("Couldn't evaluate binary operator '" + op + "' on values " + String.valueOf(left) + " and " + String.valueOf(right));
    }

    protected Object _internalEvaluate(XUnaryOperation it, Context ctx) {
        Object value = this.evaluate(it.getOperand(), ctx);
        String op = this.getOperator(it);
        if ("-".equals(op)) {
            return this.constantOperators.minus(value);
        }
        if ("!".equals(op) && value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if ("+".equals(op) && value instanceof Number) {
            return value;
        }
        throw new ConstantExpressionEvaluationException("Couldn't evaluate unary operator '" + op + "' on value " + String.valueOf(value));
    }

    protected String getOperator(XAbstractFeatureCall call) {
        Resource res = call.eResource();
        if (res instanceof StorageAwareResource && ((StorageAwareResource)res).isLoadedFromStorage()) {
            QualifiedName operator = this.operatorMapping.getOperator(QualifiedName.create((String)call.getFeature().getSimpleName()));
            if (operator != null) {
                return operator.toString();
            }
            return null;
        }
        return call.getConcreteSyntaxFeatureName();
    }

    protected String toText(XExpression expression) {
        return NodeModelUtils.getNode((EObject)expression).getText();
    }

    public Object internalEvaluate(XExpression it, Context ctx) {
        if (it instanceof XBinaryOperation) {
            return this._internalEvaluate((XBinaryOperation)it, ctx);
        }
        if (it instanceof XUnaryOperation) {
            return this._internalEvaluate((XUnaryOperation)it, ctx);
        }
        if (it instanceof XBooleanLiteral) {
            return this._internalEvaluate((XBooleanLiteral)it, ctx);
        }
        if (it instanceof XCastedExpression) {
            return this._internalEvaluate((XCastedExpression)it, ctx);
        }
        if (it instanceof XStringLiteral) {
            return this._internalEvaluate((XStringLiteral)it, ctx);
        }
        if (it instanceof XTypeLiteral) {
            return this._internalEvaluate((XTypeLiteral)it, ctx);
        }
        if (it instanceof XAnnotation) {
            return this._internalEvaluate((XAnnotation)it, ctx);
        }
        if (it != null) {
            return this._internalEvaluate(it, ctx);
        }
        return this._internalEvaluate((Void)null, ctx);
    }

    protected ConstantOperators getConstantOperators() {
        return this.constantOperators;
    }
}

