<?php

namespace {

	/**
	 * <p>This attribute is used to mark functionality as deprecated. Using deprecated functionality will cause an <b><code>E_USER_DEPRECATED</code></b> error to be emitted.</p>
	 * @link https://php.net/manual/en/class.deprecated.php
	 * @since PHP 8 >= 8.4.0
	 */
	final class Deprecated {

		/**
		 * @var ?string <p>An optional message explaining the reason for the deprecation and possible replacement functionality. Will be included in the emitted deprecation message.</p>
		 * @link https://php.net/manual/en/class.deprecated.php#deprecated.props.message
		 */
		public ?string $message;

		/**
		 * @var ?string <p>An optional string indicating since when the functionality is deprecated. The contents are not validated by PHP and may contain a version number, a date or any other value that is considered appropriate. Will be included in the emitted deprecation message.</p> <p>Functionality that is part of PHP will use Major.Minor as the since value, for example <code>'8.4'</code>.</p>
		 * @link https://php.net/manual/en/class.deprecated.php#deprecated.props.since
		 */
		public ?string $since;

		/**
		 * Construct a new Deprecated attribute instance
		 * <p>Constructs a new <code>Deprecated</code> instance.</p>
		 * @param ?string $message <p>The value of the message property.</p>
		 * @param ?string $since <p>The value of the since property.</p>
		 * @return self
		 * @link https://php.net/manual/en/deprecated.construct.php
		 * @since PHP 8 >= 8.4.0
		 */
		public function __construct(?string $message = null, ?string $since = null) {}
	}

}
