/**
Provides properties and methods for manipulating the layout and presentation of <canvas> elements. The HTMLCanvasElement interface also inherits the properties and methods of the HTMLElement interface.

@returns {HTMLCanvasElement}
*/
HTMLCanvasElement = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.height = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.width = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} [frameRequestRate]
@returns {MediaStream}
**/
HTMLCanvasElement.prototype.captureStream = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns an object that provides methods and properties for drawing and manipulating images and graphics on a canvas element in a document. A context object includes information about colors, line widths, fonts, and other graphic parameters that can be drawn on a canvas.

@param {String} contextId
@param {Object} [options]
@returns {(CanvasRenderingContext2D | ImageBitmapRenderingContext | WebGLRenderingContext | WebGL2RenderingContext | null)} RenderingContext | null
**/
HTMLCanvasElement.prototype.getContext = function(contextId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {BlobCallback} callback BlobCallback
@param {String} [type]
@param {Object} [quality]
@returns {undefined}
**/
HTMLCanvasElement.prototype.toBlob = function(callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the content of the current canvas as an image that you can use as a source for another canvas or an HTML element.

@param {String} [type] The standard MIME type for the image format to return. If you do not specify this parameter, the default value is a PNG format image.
@param {Object} [quality]
@returns {String}
**/
HTMLCanvasElement.prototype.toDataURL = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLCanvasElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLCanvasElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.accessKey = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.accessKeyLabel = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.autocapitalize = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.dir = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLCanvasElement.prototype.draggable = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLCanvasElement.prototype.hidden = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.innerText = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.lang = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.offsetHeight = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.offsetLeft = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLCanvasElement.prototype.offsetParent = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.offsetTop = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.offsetWidth = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.outerText = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLCanvasElement.prototype.spellcheck = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.title = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLCanvasElement.prototype.translate = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {ElementInternals}
**/
HTMLCanvasElement.prototype.attachInternals = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
HTMLCanvasElement.prototype.click = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLCanvasElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLCanvasElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NamedNodeMap}
**/
HTMLCanvasElement.prototype.attributes = new NamedNodeMap();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMTokenList}
**/
HTMLCanvasElement.prototype.classList = new DOMTokenList();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.className = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.clientHeight = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.clientLeft = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.clientTop = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.clientWidth = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.id = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.localName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.namespaceURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: Element, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onfullscreenchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: Element, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onfullscreenerror = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.outerHTML = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Document}
**/
HTMLCanvasElement.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMTokenList}
**/
HTMLCanvasElement.prototype.part = new DOMTokenList();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.prefix = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.scrollHeight = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.scrollLeft = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.scrollTop = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.scrollWidth = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ShadowRoot | null)} ShadowRoot | null
**/
HTMLCanvasElement.prototype.shadowRoot = new ShadowRoot();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.slot = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.tagName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Creates a shadow root for element and returns it.

@param {ShadowRootInit} init ShadowRootInit
@returns {ShadowRoot}
**/
HTMLCanvasElement.prototype.attachShadow = function(init) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the first (starting at element) inclusive ancestor that matches selectors, and null otherwise.

@param {String} selectors
@returns {(Object | null)} E | null
**/
HTMLCanvasElement.prototype.closest = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns element's first attribute whose qualified name is qualifiedName, and null if there is no such attribute otherwise.

@param {String} qualifiedName
@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.getAttribute = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns element's attribute whose namespace is namespace and local name is localName, and null if there is no such attribute otherwise.

@param {(String | null)} namespace string | null
@param {String} localName
@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.getAttributeNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the qualified names of all element's attributes. Can contain duplicates.

@returns {String}
**/
HTMLCanvasElement.prototype.getAttributeNames = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} qualifiedName
@returns {(Attr | null)} Attr | null
**/
HTMLCanvasElement.prototype.getAttributeNode = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@param {String} localName
@returns {(Attr | null)} Attr | null
**/
HTMLCanvasElement.prototype.getAttributeNodeNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMRect}
**/
HTMLCanvasElement.prototype.getBoundingClientRect = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMRectList}
**/
HTMLCanvasElement.prototype.getClientRects = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a HTMLCollection of the elements in the object on which the method was invoked (a document or an element) that have all the classes given by classNames. The classNames argument is interpreted as a space-separated list of classes.

@param {String} classNames
@returns {HTMLCollectionOf}
**/
HTMLCanvasElement.prototype.getElementsByClassName = function(classNames) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} qualifiedName
@returns {HTMLCollectionOf}
**/
HTMLCanvasElement.prototype.getElementsByTagName = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@param {String} localName
@returns {HTMLCollectionOf}
**/
HTMLCanvasElement.prototype.getElementsByTagNameNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if element has an attribute whose qualified name is qualifiedName, and false otherwise.

@param {String} qualifiedName
@returns {Boolean}
**/
HTMLCanvasElement.prototype.hasAttribute = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if element has an attribute whose namespace is namespace and local name is localName.

@param {(String | null)} namespace string | null
@param {String} localName
@returns {Boolean}
**/
HTMLCanvasElement.prototype.hasAttributeNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if element has attributes, and false otherwise.

@returns {Boolean}
**/
HTMLCanvasElement.prototype.hasAttributes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} pointerId
@returns {Boolean}
**/
HTMLCanvasElement.prototype.hasPointerCapture = function(pointerId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {("beforebegin" | "afterbegin" | "beforeend" | "afterend")} where InsertPosition
@param {Element} element Element
@returns {(Element | null)} Element | null
**/
HTMLCanvasElement.prototype.insertAdjacentElement = function(where, element) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {("beforebegin" | "afterbegin" | "beforeend" | "afterend")} position InsertPosition
@param {String} text
@returns {undefined}
**/
HTMLCanvasElement.prototype.insertAdjacentHTML = function(position, text) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {("beforebegin" | "afterbegin" | "beforeend" | "afterend")} where InsertPosition
@param {String} data
@returns {undefined}
**/
HTMLCanvasElement.prototype.insertAdjacentText = function(where, data) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if matching selectors against element's root yields element, and false otherwise.

@param {String} selectors
@returns {Boolean}
**/
HTMLCanvasElement.prototype.matches = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} pointerId
@returns {undefined}
**/
HTMLCanvasElement.prototype.releasePointerCapture = function(pointerId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes element's first attribute whose qualified name is qualifiedName.

@param {String} qualifiedName
@returns {undefined}
**/
HTMLCanvasElement.prototype.removeAttribute = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes element's attribute whose namespace is namespace and local name is localName.

@param {(String | null)} namespace string | null
@param {String} localName
@returns {undefined}
**/
HTMLCanvasElement.prototype.removeAttributeNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Attr} attr Attr
@returns {Attr}
**/
HTMLCanvasElement.prototype.removeAttributeNode = function(attr) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Displays element fullscreen and resolves promise when done.

When supplied, options's navigationUI member indicates whether showing navigation UI while in fullscreen is preferred or not. If set to "show", navigation simplicity is preferred over screen space, and if set to "hide", more screen space is preferred. User agents are always free to honor user preference over the application's. The default value "auto" indicates no application preference.

@param {FullscreenOptions} [options] FullscreenOptions
@returns {Promise}
**/
HTMLCanvasElement.prototype.requestFullscreen = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
HTMLCanvasElement.prototype.requestPointerLock = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {undefined}
**/
HTMLCanvasElement.prototype.scroll = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {undefined}
**/
HTMLCanvasElement.prototype.scrollBy = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Boolean | ScrollIntoViewOptions)} [arg] boolean | ScrollIntoViewOptions
@returns {undefined}
**/
HTMLCanvasElement.prototype.scrollIntoView = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {undefined}
**/
HTMLCanvasElement.prototype.scrollTo = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Sets the value of element's first attribute whose qualified name is qualifiedName to value.

@param {String} qualifiedName
@param {String} value
@returns {undefined}
**/
HTMLCanvasElement.prototype.setAttribute = function(qualifiedName, value) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Sets the value of element's attribute whose namespace is namespace and local name is localName to value.

@param {(String | null)} namespace string | null
@param {String} qualifiedName
@param {String} value
@returns {undefined}
**/
HTMLCanvasElement.prototype.setAttributeNS = function(namespace, qualifiedName, value) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Attr} attr Attr
@returns {(Attr | null)} Attr | null
**/
HTMLCanvasElement.prototype.setAttributeNode = function(attr) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Attr} attr Attr
@returns {(Attr | null)} Attr | null
**/
HTMLCanvasElement.prototype.setAttributeNodeNS = function(attr) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} pointerId
@returns {undefined}
**/
HTMLCanvasElement.prototype.setPointerCapture = function(pointerId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
If force is not given, "toggles" qualifiedName, removing it if it is present and adding it if it is not present. If force is true, adds qualifiedName. If force is false, removes qualifiedName.

Returns true if qualifiedName is now present, and false otherwise.

@param {String} qualifiedName
@param {Boolean} [force]
@returns {Boolean}
**/
HTMLCanvasElement.prototype.toggleAttribute = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} selectors
@returns {Boolean}
**/
HTMLCanvasElement.prototype.webkitMatchesSelector = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLCanvasElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLCanvasElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.baseURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NodeListOf}
**/
HTMLCanvasElement.prototype.childNodes = new NodeListOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLCanvasElement.prototype.firstChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLCanvasElement.prototype.isConnected = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLCanvasElement.prototype.lastChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLCanvasElement.prototype.nextSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.nodeName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.nodeType = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.nodeValue = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Document | null)} Document | null
**/
HTMLCanvasElement.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLElement | null)} HTMLElement | null
**/
HTMLCanvasElement.prototype.parentElement = new HTMLElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ParentNode | null)} ParentNode | null
**/
HTMLCanvasElement.prototype.parentNode = new ParentNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLCanvasElement.prototype.previousSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.textContent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@returns {Object} T
**/
HTMLCanvasElement.prototype.appendChild = function(node) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a copy of node. If deep is true, the copy also includes the node's descendants.

@param {Boolean} [deep]
@returns {Node}
**/
HTMLCanvasElement.prototype.cloneNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a bitmask indicating the position of other relative to node.

@param {Node} other Node
@returns {Number}
**/
HTMLCanvasElement.prototype.compareDocumentPosition = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if other is an inclusive descendant of node, and false otherwise.

@param {(Node | null)} other Node | null
@returns {Boolean}
**/
HTMLCanvasElement.prototype.contains = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns node's root.

@param {GetRootNodeOptions} [options] GetRootNodeOptions
@returns {Node}
**/
HTMLCanvasElement.prototype.getRootNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node has children.

@returns {Boolean}
**/
HTMLCanvasElement.prototype.hasChildNodes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@param {(Node | null)} child Node | null
@returns {Object} T
**/
HTMLCanvasElement.prototype.insertBefore = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {Boolean}
**/
HTMLCanvasElement.prototype.isDefaultNamespace = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node and otherNode have the same properties.

@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLCanvasElement.prototype.isEqualNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLCanvasElement.prototype.isSameNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} prefix string | null
@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.lookupNamespaceURI = function(prefix) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.lookupPrefix = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes empty exclusive Text nodes and concatenates the data of remaining contiguous exclusive Text nodes into the first of their nodes.

@returns {undefined}
**/
HTMLCanvasElement.prototype.normalize = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} child T
@returns {Object} T
**/
HTMLCanvasElement.prototype.removeChild = function(child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Node} node Node
@param {Object} child T
@returns {Object} T
**/
HTMLCanvasElement.prototype.replaceChild = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.ATTRIBUTE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.CDATA_SECTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.COMMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_FRAGMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_CONTAINED_BY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_CONTAINS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_DISCONNECTED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_FOLLOWING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_PRECEDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_TYPE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.ELEMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.ENTITY_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.ENTITY_REFERENCE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.NOTATION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.PROCESSING_INSTRUCTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.TEXT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
HTMLCanvasElement.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
HTMLCanvasElement.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
HTMLCanvasElement.prototype.removeEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaAtomic = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaAutoComplete = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaBusy = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaChecked = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaColCount = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaColIndex = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaColSpan = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaCurrent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaDisabled = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaExpanded = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaHasPopup = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaHidden = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaKeyShortcuts = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaLabel = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaLevel = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaLive = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaModal = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaMultiLine = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaMultiSelectable = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaOrientation = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaPlaceholder = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaPosInSet = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaPressed = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaReadOnly = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaRequired = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaRoleDescription = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaRowCount = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaRowIndex = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaRowSpan = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaSelected = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaSetSize = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaSort = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaValueMax = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaValueMin = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaValueNow = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.ariaValueText = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Keyframe[] | PropertyIndexedKeyframes | null)} keyframes Keyframe[] | PropertyIndexedKeyframes | null
@param {(Number | KeyframeAnimationOptions)} [options] number | KeyframeAnimationOptions
@returns {Animation}
**/
HTMLCanvasElement.prototype.animate = function(keyframes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {GetAnimationsOptions} [options] GetAnimationsOptions
@returns {Animation[]}
**/
HTMLCanvasElement.prototype.getAnimations = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes just after node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLCanvasElement.prototype.after = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes just before node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLCanvasElement.prototype.before = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes node.

@returns {undefined}
**/
HTMLCanvasElement.prototype.remove = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Replaces node with nodes, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLCanvasElement.prototype.replaceWith = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.baseURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NodeListOf}
**/
HTMLCanvasElement.prototype.childNodes = new NodeListOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLCanvasElement.prototype.firstChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLCanvasElement.prototype.isConnected = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLCanvasElement.prototype.lastChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLCanvasElement.prototype.nextSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.nodeName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.nodeType = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.nodeValue = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Document | null)} Document | null
**/
HTMLCanvasElement.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLElement | null)} HTMLElement | null
**/
HTMLCanvasElement.prototype.parentElement = new HTMLElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ParentNode | null)} ParentNode | null
**/
HTMLCanvasElement.prototype.parentNode = new ParentNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLCanvasElement.prototype.previousSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.textContent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@returns {Object} T
**/
HTMLCanvasElement.prototype.appendChild = function(node) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a copy of node. If deep is true, the copy also includes the node's descendants.

@param {Boolean} [deep]
@returns {Node}
**/
HTMLCanvasElement.prototype.cloneNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a bitmask indicating the position of other relative to node.

@param {Node} other Node
@returns {Number}
**/
HTMLCanvasElement.prototype.compareDocumentPosition = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if other is an inclusive descendant of node, and false otherwise.

@param {(Node | null)} other Node | null
@returns {Boolean}
**/
HTMLCanvasElement.prototype.contains = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns node's root.

@param {GetRootNodeOptions} [options] GetRootNodeOptions
@returns {Node}
**/
HTMLCanvasElement.prototype.getRootNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node has children.

@returns {Boolean}
**/
HTMLCanvasElement.prototype.hasChildNodes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@param {(Node | null)} child Node | null
@returns {Object} T
**/
HTMLCanvasElement.prototype.insertBefore = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {Boolean}
**/
HTMLCanvasElement.prototype.isDefaultNamespace = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node and otherNode have the same properties.

@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLCanvasElement.prototype.isEqualNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLCanvasElement.prototype.isSameNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} prefix string | null
@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.lookupNamespaceURI = function(prefix) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.lookupPrefix = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes empty exclusive Text nodes and concatenates the data of remaining contiguous exclusive Text nodes into the first of their nodes.

@returns {undefined}
**/
HTMLCanvasElement.prototype.normalize = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} child T
@returns {Object} T
**/
HTMLCanvasElement.prototype.removeChild = function(child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Node} node Node
@param {Object} child T
@returns {Object} T
**/
HTMLCanvasElement.prototype.replaceChild = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.ATTRIBUTE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.CDATA_SECTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.COMMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_FRAGMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_CONTAINED_BY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_CONTAINS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_DISCONNECTED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_FOLLOWING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_PRECEDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_TYPE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.ELEMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.ENTITY_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.ENTITY_REFERENCE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.NOTATION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.PROCESSING_INSTRUCTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.TEXT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
HTMLCanvasElement.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
HTMLCanvasElement.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
HTMLCanvasElement.prototype.removeEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.innerHTML = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLCanvasElement.prototype.nextElementSibling = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLCanvasElement.prototype.previousElementSibling = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.childElementCount = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCollection}
**/
HTMLCanvasElement.prototype.children = new HTMLCollection();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLCanvasElement.prototype.firstElementChild = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLCanvasElement.prototype.lastElementChild = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes after the last child of node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLCanvasElement.prototype.append = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes before the first child of node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLCanvasElement.prototype.prepend = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the first element that is a descendant of node that matches selectors.

@param {String} selectors
@returns {(Object | null)} E | null
**/
HTMLCanvasElement.prototype.querySelector = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns all element descendants of node that match selectors.

@param {String} selectors
@returns {NodeListOf}
**/
HTMLCanvasElement.prototype.querySelectorAll = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Replace all children of node with nodes, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLCanvasElement.prototype.replaceChildren = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.baseURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NodeListOf}
**/
HTMLCanvasElement.prototype.childNodes = new NodeListOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLCanvasElement.prototype.firstChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLCanvasElement.prototype.isConnected = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLCanvasElement.prototype.lastChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLCanvasElement.prototype.nextSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.nodeName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.nodeType = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.nodeValue = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Document | null)} Document | null
**/
HTMLCanvasElement.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLElement | null)} HTMLElement | null
**/
HTMLCanvasElement.prototype.parentElement = new HTMLElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ParentNode | null)} ParentNode | null
**/
HTMLCanvasElement.prototype.parentNode = new ParentNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLCanvasElement.prototype.previousSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.textContent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@returns {Object} T
**/
HTMLCanvasElement.prototype.appendChild = function(node) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a copy of node. If deep is true, the copy also includes the node's descendants.

@param {Boolean} [deep]
@returns {Node}
**/
HTMLCanvasElement.prototype.cloneNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a bitmask indicating the position of other relative to node.

@param {Node} other Node
@returns {Number}
**/
HTMLCanvasElement.prototype.compareDocumentPosition = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if other is an inclusive descendant of node, and false otherwise.

@param {(Node | null)} other Node | null
@returns {Boolean}
**/
HTMLCanvasElement.prototype.contains = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns node's root.

@param {GetRootNodeOptions} [options] GetRootNodeOptions
@returns {Node}
**/
HTMLCanvasElement.prototype.getRootNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node has children.

@returns {Boolean}
**/
HTMLCanvasElement.prototype.hasChildNodes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@param {(Node | null)} child Node | null
@returns {Object} T
**/
HTMLCanvasElement.prototype.insertBefore = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {Boolean}
**/
HTMLCanvasElement.prototype.isDefaultNamespace = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node and otherNode have the same properties.

@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLCanvasElement.prototype.isEqualNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLCanvasElement.prototype.isSameNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} prefix string | null
@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.lookupNamespaceURI = function(prefix) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {(String | null)} string | null
**/
HTMLCanvasElement.prototype.lookupPrefix = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes empty exclusive Text nodes and concatenates the data of remaining contiguous exclusive Text nodes into the first of their nodes.

@returns {undefined}
**/
HTMLCanvasElement.prototype.normalize = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} child T
@returns {Object} T
**/
HTMLCanvasElement.prototype.removeChild = function(child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Node} node Node
@param {Object} child T
@returns {Object} T
**/
HTMLCanvasElement.prototype.replaceChild = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.ATTRIBUTE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.CDATA_SECTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.COMMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_FRAGMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_CONTAINED_BY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_CONTAINS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_DISCONNECTED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_FOLLOWING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_POSITION_PRECEDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.DOCUMENT_TYPE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.ELEMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.ENTITY_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.ENTITY_REFERENCE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.NOTATION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.PROCESSING_INSTRUCTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.TEXT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
HTMLCanvasElement.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
HTMLCanvasElement.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
HTMLCanvasElement.prototype.removeEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLSlotElement | null)} HTMLSlotElement | null
**/
HTMLCanvasElement.prototype.assignedSlot = new HTMLSlotElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null
**/
HTMLCanvasElement.prototype.oncopy = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null
**/
HTMLCanvasElement.prototype.oncut = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null
**/
HTMLCanvasElement.prototype.onpaste = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLCanvasElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLCanvasElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {CSSStyleDeclaration}
**/
HTMLCanvasElement.prototype.style = new CSSStyleDeclaration();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.contentEditable = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.enterKeyHint = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.inputMode = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLCanvasElement.prototype.isContentEditable = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: UIEvent) => any) | null
**/
HTMLCanvasElement.prototype.onabort = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
HTMLCanvasElement.prototype.onanimationcancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
HTMLCanvasElement.prototype.onanimationend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
HTMLCanvasElement.prototype.onanimationiteration = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
HTMLCanvasElement.prototype.onanimationstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLCanvasElement.prototype.onauxclick = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null
**/
HTMLCanvasElement.prototype.onblur = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.oncanplay = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.oncanplaythrough = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLCanvasElement.prototype.onclick = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onclose = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLCanvasElement.prototype.oncontextmenu = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.oncuechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLCanvasElement.prototype.ondblclick = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLCanvasElement.prototype.ondrag = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLCanvasElement.prototype.ondragend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLCanvasElement.prototype.ondragenter = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLCanvasElement.prototype.ondragleave = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLCanvasElement.prototype.ondragover = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLCanvasElement.prototype.ondragstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLCanvasElement.prototype.ondrop = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.ondurationchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onemptied = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onended = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(OnErrorEventHandlerNonNull | null)} OnErrorEventHandler
**/
HTMLCanvasElement.prototype.onerror = new OnErrorEventHandlerNonNull();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null
**/
HTMLCanvasElement.prototype.onfocus = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: FormDataEvent) => any) | null
**/
HTMLCanvasElement.prototype.onformdata = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLCanvasElement.prototype.ongotpointercapture = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.oninput = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.oninvalid = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null
**/
HTMLCanvasElement.prototype.onkeydown = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null
**/
HTMLCanvasElement.prototype.onkeypress = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null
**/
HTMLCanvasElement.prototype.onkeyup = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onload = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onloadeddata = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onloadedmetadata = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onloadstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLCanvasElement.prototype.onlostpointercapture = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLCanvasElement.prototype.onmousedown = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLCanvasElement.prototype.onmouseenter = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLCanvasElement.prototype.onmouseleave = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLCanvasElement.prototype.onmousemove = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLCanvasElement.prototype.onmouseout = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLCanvasElement.prototype.onmouseover = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLCanvasElement.prototype.onmouseup = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onpause = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onplay = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onplaying = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLCanvasElement.prototype.onpointercancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLCanvasElement.prototype.onpointerdown = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLCanvasElement.prototype.onpointerenter = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLCanvasElement.prototype.onpointerleave = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLCanvasElement.prototype.onpointermove = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLCanvasElement.prototype.onpointerout = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLCanvasElement.prototype.onpointerover = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLCanvasElement.prototype.onpointerup = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: ProgressEvent) => any) | null
**/
HTMLCanvasElement.prototype.onprogress = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onratechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onreset = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: UIEvent) => any) | null
**/
HTMLCanvasElement.prototype.onresize = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onscroll = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: SecurityPolicyViolationEvent) => any) | null
**/
HTMLCanvasElement.prototype.onsecuritypolicyviolation = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onseeked = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onseeking = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onselect = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onselectionchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onselectstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onslotchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onstalled = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: SubmitEvent) => any) | null
**/
HTMLCanvasElement.prototype.onsubmit = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onsuspend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.ontimeupdate = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.ontoggle = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
HTMLCanvasElement.prototype.ontouchcancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
HTMLCanvasElement.prototype.ontouchend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
HTMLCanvasElement.prototype.ontouchmove = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
HTMLCanvasElement.prototype.ontouchstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
HTMLCanvasElement.prototype.ontransitioncancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
HTMLCanvasElement.prototype.ontransitionend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
HTMLCanvasElement.prototype.ontransitionrun = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
HTMLCanvasElement.prototype.ontransitionstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onvolumechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onwaiting = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onwebkitanimationend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onwebkitanimationiteration = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onwebkitanimationstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLCanvasElement.prototype.onwebkittransitionend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: WheelEvent) => any) | null
**/
HTMLCanvasElement.prototype.onwheel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLCanvasElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLCanvasElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLCanvasElement.prototype.autofocus = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMStringMap}
**/
HTMLCanvasElement.prototype.dataset = new DOMStringMap();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLCanvasElement.prototype.nonce = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLCanvasElement.prototype.tabIndex = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
HTMLCanvasElement.prototype.blur = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {FocusOptions} [options] FocusOptions
@returns {undefined}
**/
HTMLCanvasElement.prototype.focus = function() {};

