/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.completion;

import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.php.latte.completion.Bundle;
import org.netbeans.modules.php.latte.completion.LatteElement;
import org.netbeans.modules.php.latte.parser.LatteParserResult;
import org.openide.util.ImageUtilities;

public abstract class LatteCompletionProposal
implements CompletionProposal {
    private final LatteElement element;
    private final CompletionRequest request;

    public LatteCompletionProposal(LatteElement element, CompletionRequest request) {
        this.element = element;
        this.request = request;
    }

    public int getAnchorOffset() {
        return this.request.anchorOffset;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.element.getName();
    }

    public String getSortText() {
        return this.element.getName();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public boolean isSmart() {
        return this.getName().startsWith(this.request.prefix);
    }

    public int getSortPrioOverride() {
        return 0;
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        formatter.name(this.getKind(), true);
        formatter.appendText(this.getName());
        formatter.name(this.getKind(), false);
        this.element.formatParameters(formatter);
        return formatter.getText();
    }

    public String getCustomInsertTemplate() {
        return this.element.getTemplate();
    }

    public static class CompletionRequest {
        public int anchorOffset;
        public String prefix;
        public LatteParserResult parserResult;
    }

    static class ControlCompletionProposal
    extends LatteCompletionProposal {
        private static final ImageIcon CONTROL_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/latte/resources/latte_cc_icon.png", (boolean)false);

        public ControlCompletionProposal(LatteElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.ControlRhs();
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        @Override
        public ImageIcon getIcon() {
            return CONTROL_ICON;
        }
    }

    static class UserVariableCompletionProposal
    extends VariableCompletionProposal {
        public UserVariableCompletionProposal(LatteElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.UserVariableRhs();
        }

        @Override
        public int getSortPrioOverride() {
            return 15;
        }
    }

    static class DefaultVariableCompletionProposal
    extends VariableCompletionProposal {
        public DefaultVariableCompletionProposal(LatteElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.DefaultVariableRhs();
        }

        @Override
        public int getSortPrioOverride() {
            return 40;
        }
    }

    static abstract class VariableCompletionProposal
    extends LatteCompletionProposal {
        public VariableCompletionProposal(LatteElement element, CompletionRequest request) {
            super(element, request);
        }

        public ElementKind getKind() {
            return ElementKind.VARIABLE;
        }
    }

    static class IteratorMethodItemCompletionProposal
    extends IteratorItemCompletionProposal {
        public IteratorMethodItemCompletionProposal(LatteElement element, CompletionRequest request) {
            super(element, request);
        }

        public ElementKind getKind() {
            return ElementKind.METHOD;
        }
    }

    static class IteratorFieldItemCompletionProposal
    extends IteratorItemCompletionProposal {
        public IteratorFieldItemCompletionProposal(LatteElement element, CompletionRequest request) {
            super(element, request);
        }

        public ElementKind getKind() {
            return ElementKind.FIELD;
        }
    }

    static abstract class IteratorItemCompletionProposal
    extends LatteCompletionProposal {
        public IteratorItemCompletionProposal(LatteElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.IteratorRhs();
        }

        @Override
        public ImageIcon getIcon() {
            return null;
        }
    }

    static class KeywordCompletionProposal
    extends LatteCompletionProposal {
        private static final ImageIcon KEYWORD_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/latte/resources/latte_cc_icon.png", (boolean)false);

        public KeywordCompletionProposal(LatteElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.KeywordRhs();
        }

        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        @Override
        public ImageIcon getIcon() {
            return KEYWORD_ICON;
        }
    }

    static class HelperCompletionProposal
    extends LatteCompletionProposal {
        private static final ImageIcon HELPER_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/latte/resources/helper_cc_icon.png", (boolean)false);

        public HelperCompletionProposal(LatteElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.HelperRhs();
        }

        public ElementKind getKind() {
            return ElementKind.RULE;
        }

        @Override
        public ImageIcon getIcon() {
            return HELPER_ICON;
        }
    }

    static class EndMacroCompletionProposal
    extends MacroCompletionProposal {
        public EndMacroCompletionProposal(LatteElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.EndMacroRhs();
        }

        @Override
        public int getSortPrioOverride() {
            return 100;
        }
    }

    static class StartMacroCompletionProposal
    extends MacroCompletionProposal {
        public StartMacroCompletionProposal(LatteElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.MacroRhs();
        }

        @Override
        public int getSortPrioOverride() {
            return 50;
        }
    }

    static abstract class MacroCompletionProposal
    extends LatteCompletionProposal {
        private static final ImageIcon MACRO_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/latte/resources/macro_cc_icon.png", (boolean)false);

        public MacroCompletionProposal(LatteElement element, CompletionRequest request) {
            super(element, request);
        }

        public ElementKind getKind() {
            return ElementKind.METHOD;
        }

        @Override
        public ImageIcon getIcon() {
            return MACRO_ICON;
        }
    }
}

