/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyChange;
import org.netbeans.modules.project.dependency.DependencyChangeException;
import org.netbeans.modules.project.dependency.DependencyChangeRequest;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectModificationResult;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.Scopes;
import org.netbeans.modules.project.dependency.impl.ProjectModificationResultImpl;
import org.netbeans.modules.project.dependency.spi.ProjectDependenciesImplementation;
import org.netbeans.modules.project.dependency.spi.ProjectDependencyModifier;

public final class ProjectDependencies {
    public static DependencyResult findDependencies(Project target, DependencyQuery query) throws ProjectOperationException {
        ProjectDependenciesImplementation pds = (ProjectDependenciesImplementation)target.getLookup().lookup(ProjectDependenciesImplementation.class);
        if (pds == null) {
            return null;
        }
        return pds.findDependencies(query);
    }

    public static DependencyQueryBuilder newBuilder() {
        return new DependencyQueryBuilder();
    }

    public static DependencyQuery newQuery(Scope ... scopes) {
        return ProjectDependencies.newBuilder().scope(scopes).build();
    }

    public static ProjectModificationResult addDependencies(Project project, Dependency ... dependencies) throws DependencyChangeException, ProjectOperationException {
        return ProjectDependencies.modifyDependencies(project, new DependencyChangeRequest(Collections.singletonList(DependencyChange.builder(DependencyChange.Kind.ADD).dependency(dependencies).create())));
    }

    public static ProjectModificationResult removeDependencies(Project project, List<Dependency> dependencies) throws DependencyChangeException, ProjectOperationException {
        return ProjectDependencies.modifyDependencies(project, new DependencyChangeRequest(Collections.singletonList(DependencyChange.builder(DependencyChange.Kind.REMOVE).dependency(dependencies).create())));
    }

    public static ProjectModificationResult modifyDependencies(Project p, DependencyChange change) throws DependencyChangeException, ProjectOperationException {
        return ProjectDependencies.modifyDependencies(p, new DependencyChangeRequest(Collections.singletonList(change)));
    }

    public static ProjectModificationResult modifyDependencies(Project p, DependencyChangeRequest change) throws DependencyChangeException, ProjectOperationException {
        Collection modifiers = p.getLookup().lookupAll(ProjectDependencyModifier.class);
        if (modifiers.isEmpty()) {
            return null;
        }
        ProjectModificationResultImpl impl = new ProjectModificationResultImpl(p);
        ArrayList<ProjectDependencyModifier.Result> results = new ArrayList<ProjectDependencyModifier.Result>();
        HashSet<String> exclude = new HashSet<String>();
        for (ProjectDependencyModifier m : modifiers) {
            ProjectDependencyModifier.Result res = m.computeChange(change);
            if (res == null) continue;
            results.add(res);
        }
        if (results.isEmpty()) {
            return null;
        }
        block1: for (ProjectDependencyModifier.Result r : results) {
            for (ProjectDependencyModifier.Result c : results) {
                if (exclude.contains(c.getId()) || !c.suppresses(r)) continue;
                exclude.add(r.getId());
                continue block1;
            }
        }
        for (ProjectDependencyModifier.Result r : results) {
            if (exclude.contains(r.getId())) continue;
            impl.add(r);
        }
        return new ProjectModificationResult(impl);
    }

    public static final class DependencyQuery {
        private final Set<Scope> scopes;
        private final Dependency.Filter filter;
        private final boolean offline;
        private final boolean flushChaches;

        private DependencyQuery(Set<Scope> scopes, Dependency.Filter filter, boolean offline, boolean flushCaches) {
            this.scopes = scopes == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<Scope>(scopes));
            this.filter = filter;
            this.offline = offline;
            this.flushChaches = flushCaches;
        }

        public Set<Scope> getScopes() {
            return this.scopes;
        }

        public Dependency.Filter getFilter() {
            return this.filter;
        }

        public boolean isOffline() {
            return this.offline;
        }

        public boolean isFlushChaches() {
            return this.flushChaches;
        }
    }

    public static final class DependencyQueryBuilder {
        private Set<Scope> scopes;
        private Dependency.Filter filter;
        private boolean offline = true;
        private boolean flush;

        private DependencyQueryBuilder() {
        }

        public DependencyQuery build() {
            if (this.scopes == null) {
                this.scope(Scopes.COMPILE);
            }
            return new DependencyQuery(this.scopes, this.filter, this.offline, this.flush);
        }

        public DependencyQueryBuilder filter(Dependency.Filter f) {
            this.filter = f;
            return this;
        }

        public DependencyQueryBuilder scope(Scope ... s) {
            if (s == null || s.length == 0) {
                return this;
            }
            if (this.scopes == null) {
                this.scopes = new LinkedHashSet<Scope>();
            }
            this.scopes.addAll(Arrays.asList(s));
            return this;
        }

        public DependencyQueryBuilder online() {
            this.offline = false;
            return this;
        }

        public DependencyQueryBuilder offline() {
            this.offline = true;
            return this;
        }

        public DependencyQueryBuilder withoutCaches() {
            this.flush = true;
            return this;
        }
    }
}

