/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.svg.navigation;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.svg.SVGDataObject;
import org.netbeans.modules.svg.SVGViewerElement;
import org.netbeans.modules.svg.navigation.SVGPreviewPanel;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SVGNavigatorPanel
implements NavigatorPanel {
    private static final Logger LOG;
    private SVGPreviewPanel panelUI;
    private static final Lookup.Template<SVGDataObject> MY_DATA;
    private Lookup.Result<SVGDataObject> currentContext;
    private LookupListener contextListener;
    private FileChangeListener fileChangeListener;
    private long lastSaveTime = -1L;
    private DataObject currentDataObject;
    private static final RequestProcessor WORKER;

    public String getDisplayName() {
        return NbBundle.getMessage(SVGNavigatorPanel.class, (String)"Navigator_DisplayName");
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(SVGNavigatorPanel.class, (String)"Navigator_DisplayHint");
    }

    public JComponent getComponent() {
        if (this.lastSaveTime == -1L) {
            this.lastSaveTime = System.currentTimeMillis();
        }
        if (this.panelUI == null) {
            this.panelUI = new SVGPreviewPanel();
        }
        return this.panelUI;
    }

    public void panelActivated(Lookup context) {
        this.currentContext = context.lookup(MY_DATA);
        this.currentContext.addLookupListener(this.getContextListener());
        Collection data = this.currentContext.allInstances();
        this.currentDataObject = this.getDataObject(data);
        if (this.currentDataObject == null) {
            return;
        }
        if (this.fileChangeListener == null) {
            this.fileChangeListener = new SVGFileChangeAdapter();
        }
        this.currentDataObject.getPrimaryFile().addFileChangeListener(this.fileChangeListener);
        this.setNewContent(this.currentDataObject);
    }

    public void panelDeactivated() {
        this.currentContext.removeLookupListener(this.getContextListener());
        this.currentContext = null;
        if (this.currentDataObject != null) {
            this.currentDataObject.getPrimaryFile().removeFileChangeListener(this.fileChangeListener);
        }
        this.currentDataObject = null;
    }

    public Lookup getLookup() {
        return null;
    }

    private void setNewContent(DataObject dataObject) {
        if (dataObject == null) {
            return;
        }
        WORKER.post(() -> {
            FileObject fo = dataObject.getPrimaryFile();
            if (fo == null) {
                return;
            }
            if (this.panelUI == null) {
                this.getComponent();
            }
            SVGLoader svgLoader = new SVGLoader();
            SVGDocument svgDocument = svgLoader.load(fo.toURL());
            SwingUtilities.invokeLater(() -> this.panelUI.setSVG(svgDocument));
        });
    }

    private DataObject getDataObject(Collection<? extends SVGDataObject> data) {
        if (data.isEmpty()) {
            return null;
        }
        return (DataObject)data.iterator().next();
    }

    private LookupListener getContextListener() {
        if (this.contextListener == null) {
            this.contextListener = new ContextListener();
        }
        return this.contextListener;
    }

    static {
        Logger.getLogger("com.github.weisj.jsvg").setLevel(Level.OFF);
        LOG = Logger.getLogger(SVGViewerElement.class.getName());
        MY_DATA = new Lookup.Template(SVGDataObject.class);
        WORKER = new RequestProcessor(SVGNavigatorPanel.class.getName());
    }

    private class SVGFileChangeAdapter
    extends FileChangeAdapter {
        private SVGFileChangeAdapter() {
        }

        public void fileChanged(FileEvent fe) {
            if (fe.getTime() > SVGNavigatorPanel.this.lastSaveTime) {
                SVGNavigatorPanel.this.lastSaveTime = System.currentTimeMillis();
                SwingUtilities.invokeLater(() -> {
                    try {
                        SVGNavigatorPanel.this.currentDataObject = DataObject.find((FileObject)fe.getFile());
                        SVGNavigatorPanel.this.setNewContent(SVGNavigatorPanel.this.currentDataObject);
                    }
                    catch (DataObjectNotFoundException ex) {
                        LOG.log(Level.INFO, NbBundle.getMessage(SVGNavigatorPanel.class, (String)"ERR_DataObject"));
                    }
                });
            }
        }
    }

    private class ContextListener
    implements LookupListener {
        private ContextListener() {
        }

        public void resultChanged(LookupEvent ev) {
            if (SVGNavigatorPanel.this.currentDataObject != null && SVGNavigatorPanel.this.fileChangeListener != null) {
                SVGNavigatorPanel.this.currentDataObject.getPrimaryFile().removeFileChangeListener(SVGNavigatorPanel.this.fileChangeListener);
            }
            SVGNavigatorPanel.this.currentDataObject = SVGNavigatorPanel.this.getDataObject(SVGNavigatorPanel.this.currentContext.allInstances());
            if (SVGNavigatorPanel.this.currentDataObject != null && SVGNavigatorPanel.this.fileChangeListener != null) {
                SVGNavigatorPanel.this.currentDataObject.getPrimaryFile().addFileChangeListener(SVGNavigatorPanel.this.fileChangeListener);
            }
            SVGNavigatorPanel.this.setNewContent(SVGNavigatorPanel.this.currentDataObject);
        }
    }
}

