/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPluggableDatabaseRequest
extends BmcRequest<Void> {
    private String pluggableDatabaseId;

    public String getPluggableDatabaseId() {
        return this.pluggableDatabaseId;
    }

    public Builder toBuilder() {
        return new Builder().pluggableDatabaseId(this.pluggableDatabaseId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pluggableDatabaseId=").append(String.valueOf(this.pluggableDatabaseId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPluggableDatabaseRequest)) {
            return false;
        }
        GetPluggableDatabaseRequest other = (GetPluggableDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pluggableDatabaseId, other.pluggableDatabaseId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pluggableDatabaseId == null ? 43 : this.pluggableDatabaseId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPluggableDatabaseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pluggableDatabaseId = null;

        public Builder pluggableDatabaseId(String pluggableDatabaseId) {
            this.pluggableDatabaseId = pluggableDatabaseId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPluggableDatabaseRequest o) {
            this.pluggableDatabaseId(o.getPluggableDatabaseId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPluggableDatabaseRequest build() {
            GetPluggableDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPluggableDatabaseRequest buildWithoutInvocationCallback() {
            GetPluggableDatabaseRequest request = new GetPluggableDatabaseRequest();
            request.pluggableDatabaseId = this.pluggableDatabaseId;
            return request;
        }
    }
}

