/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.java.generator;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.xml.DTDDataObject;
import org.netbeans.modules.xml.lib.GuiUtil;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tools.generator.SelectFileDialog;
import org.netbeans.modules.xml.tools.generator.XMLGenerateCookie;
import org.netbeans.modules.xml.tools.java.generator.GenerateSupportUtils;
import org.netbeans.modules.xml.tools.java.generator.GenerationUtils;
import org.netbeans.modules.xml.tools.java.generator.SourceUtils;
import org.netbeans.tax.TreeAttlistDeclAttributeDef;
import org.netbeans.tax.TreeDTDRoot;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeElementDecl;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.decl.ANYType;
import org.netbeans.tax.decl.ChildrenType;
import org.netbeans.tax.decl.NameType;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public class GenerateDOMScannerSupport
implements XMLGenerateCookie {
    private static final String JAVA_EXT = "java";
    private static final String DOM_PACKAGE = "org.w3c.dom.";
    private static final String DOM_DOCUMENT = "org.w3c.dom.Document";
    private static final String DOM_ELEMENT = "org.w3c.dom.Element";
    private static final String DOM_NAMED_NODE_MAP = "org.w3c.dom.NamedNodeMap";
    private static final String VARIABLE_DOCUMENT = "document";
    private static final String VARIABLE_ELEMENT = "element";
    private static final String VARIABLE_ATTRS = "attrs";
    private static final String METHOD_SCAN_DOCUMENT = "visitDocument";
    private static final String METHOD_SCAN_ELEMENT = "visitElement";
    private DTDDataObject DO;
    private TreeDTDRoot dtd;

    public GenerateDOMScannerSupport(DTDDataObject DO) {
        this(DO, null);
    }

    public GenerateDOMScannerSupport(DTDDataObject DO, TreeDTDRoot dtd) {
        if (DO == null) {
            throw new IllegalArgumentException("null");
        }
        this.DO = DO;
        this.dtd = dtd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        try {
            if (this.getDTD() == null) {
                return;
            }
            FileObject primFile = this.DO.getPrimaryFile();
            String rawName = primFile.getName();
            String name = rawName.substring(0, 1).toUpperCase() + rawName.substring(1) + NbBundle.getMessage(GenerateDOMScannerSupport.class, (String)"NAME_SUFFIX_Scanner");
            FileObject folder = primFile.getParent();
            FileObject generFile = new SelectFileDialog(folder, name, JAVA_EXT).getFileObject();
            name = generFile.getName();
            generFile.delete();
            generFile = GenerationUtils.createClass(folder, name, null);
            try {
                GuiUtil.setStatusText((String)NbBundle.getMessage(GenerateDOMScannerSupport.class, (String)"MSG_DOM_1"));
                this.prepareDOMScannerClass(generFile);
            }
            finally {
                GuiUtil.setStatusText((String)"");
            }
            GuiUtil.performDefaultAction((FileObject)generFile);
        }
        catch (UserCancelException primFile) {
        }
        catch (TreeException e) {
            GuiUtil.notifyError((String)NbBundle.getMessage(GenerateDOMScannerSupport.class, (String)"MSG_DOM_ERR_1"));
        }
        catch (IOException e) {
            GuiUtil.notifyError((String)NbBundle.getMessage(GenerateDOMScannerSupport.class, (String)"MSG_DOM_ERR_2"));
        }
    }

    private TreeDTDRoot getDTD() throws IOException, TreeException {
        if (this.dtd == null) {
            TreeEditorCookie cake = (TreeEditorCookie)this.DO.getCookie(TreeEditorCookie.class);
            if (cake == null) {
                throw new TreeException("DTDDataObject:INTERNAL ERROR");
            }
            TreeDocumentRoot result = cake.openDocumentRoot();
            this.dtd = (TreeDTDRoot)result;
        }
        return this.dtd;
    }

    private void prepareDOMScannerClass(FileObject clazz) throws IOException {
        this.dtd2java(clazz, this.findRootTagName());
    }

    private void dtd2java(FileObject clazz, String tempRootName) throws IOException {
        final String constructorName = clazz.getName();
        JavaSource targetSource = JavaSource.forFileObject((FileObject)clazz);
        CancellableTask task = new CancellableTask(){

            public void cancel() {
            }

            public void run(Object parameter) throws Exception {
                WorkingCopy workingCopy = (WorkingCopy)parameter;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (javaClass != null) {
                    TreeMaker make = workingCopy.getTreeMaker();
                    GenerationUtils genUtils = GenerationUtils.newInstance(workingCopy);
                    String commentText = "TESTTTT";
                    Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)0, (int)0, (int)0, (String)commentText);
                    make.addComment((Tree)javaClass, comment, true);
                    IdentifierTree tree = make.Identifier((CharSequence)GenerateDOMScannerSupport.DOM_DOCUMENT);
                    VariableTree var = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)GenerateDOMScannerSupport.VARIABLE_DOCUMENT, (Tree)tree, null);
                    ArrayList<VariableTree> varTree = new ArrayList<VariableTree>();
                    varTree.add(var);
                    ClassTree modifiedClass = genUtils.addClassFields(javaClass, varTree);
                    commentText = "org.w3c.dom.Document document";
                    comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
                    make.addComment((Tree)var, comment, true);
                    ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC));
                    MethodTree newConstructor = genUtils.createAssignmentConstructor(mods, constructorName, varTree);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)newConstructor);
                    commentText = "Create new " + constructorName + " with org.w3c.dom.Document.";
                    comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
                    make.addComment((Tree)newConstructor, comment, true);
                    StringBuffer sb = new StringBuffer("{\n");
                    sb.append(GenerateDOMScannerSupport.DOM_ELEMENT).append(" ").append(GenerateDOMScannerSupport.VARIABLE_ELEMENT).append(" = ").append(GenerateDOMScannerSupport.VARIABLE_DOCUMENT).append(".getDocumentElement();\n");
                    Iterator it = GenerateDOMScannerSupport.this.dtd.getElementDeclarations().iterator();
                    while (it.hasNext()) {
                        String tagName = ((TreeElementDecl)it.next()).getName();
                        sb.append("if ((").append(GenerateDOMScannerSupport.VARIABLE_ELEMENT).append(" != null) && ").append(GenerateDOMScannerSupport.VARIABLE_ELEMENT).append(".getTagName().equals (\"").append(tagName).append("\")) {\n");
                        sb.append(GenerateDOMScannerSupport.METHOD_SCAN_ELEMENT).append("_").append(GenerateSupportUtils.getJavaName(tagName)).append(" (").append(GenerateDOMScannerSupport.VARIABLE_ELEMENT).append(");\n}\n");
                    }
                    sb.append("}\n");
                    MethodTree method = make.Method(make.Modifiers(Collections.singleton(Modifier.PUBLIC)), (CharSequence)GenerateDOMScannerSupport.METHOD_SCAN_DOCUMENT, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), sb.toString(), null);
                    commentText = "Scan through org.w3c.dom.Document document.";
                    comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
                    make.addComment((Tree)method, comment, true);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    it = GenerateDOMScannerSupport.this.dtd.getElementDeclarations().iterator();
                    mods = make.Modifiers(EnumSet.noneOf(Modifier.class));
                    tree = make.Identifier((CharSequence)GenerateDOMScannerSupport.DOM_ELEMENT);
                    var = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)GenerateDOMScannerSupport.VARIABLE_ELEMENT, (Tree)tree, null);
                    varTree = new ArrayList();
                    varTree.add(var);
                    while (it.hasNext()) {
                        TreeElementDecl next = (TreeElementDecl)it.next();
                        String tagName = next.getName();
                        String methodName = GenerateSupportUtils.getJavaName("visitElement_" + tagName);
                        sb = new StringBuffer();
                        sb.append("{");
                        sb.append(" // <").append(tagName).append(">\n// element.getValue();\n");
                        Iterator it2 = GenerateDOMScannerSupport.this.dtd.getAttributeDeclarations(tagName).iterator();
                        if (it2.hasNext()) {
                            sb.append(GenerateDOMScannerSupport.DOM_NAMED_NODE_MAP).append(" ").append(GenerateDOMScannerSupport.VARIABLE_ATTRS).append(" = ").append(GenerateDOMScannerSupport.VARIABLE_ELEMENT).append(".getAttributes();\n");
                            sb.append("for (int i = 0; i < ").append(GenerateDOMScannerSupport.VARIABLE_ATTRS).append(".getLength(); i++) {\n");
                            sb.append("org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);\n");
                            while (it2.hasNext()) {
                                TreeAttlistDeclAttributeDef attr = (TreeAttlistDeclAttributeDef)it2.next();
                                sb.append("if (attr.getName().equals (\"").append(attr.getName()).append("\")) { // <").append(tagName).append(" ").append(attr.getName()).append("=\"???\">\n");
                                sb.append("// attr.getValue();\n}\n");
                            }
                            sb.append("}\n");
                        }
                        sb.append(GenerateDOMScannerSupport.this.generateElementScanner(next));
                        sb.append("}\n");
                        method = make.Method(mods, (CharSequence)methodName, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), varTree, Collections.emptyList(), sb.toString(), null);
                        commentText = "Scan through org.w3c.dom.Element named " + tagName + ".";
                        comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
                        make.addComment((Tree)method, comment, true);
                        modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    }
                    workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                }
            }
        };
        targetSource.runModificationTask((Task)task).commit();
    }

    private String generateElementScanner(TreeElementDecl element) {
        Iterator it;
        HashSet<String> elements = new HashSet<String>();
        TreeElementDecl.ContentType type = element.getContentType();
        if (type instanceof ANYType) {
            it = this.dtd.getElementDeclarations().iterator();
            while (it.hasNext()) {
                String tagName = ((TreeElementDecl)it.next()).getName();
                elements.add(tagName);
            }
        } else {
            this.addElements(type, elements);
        }
        StringBuffer sb2 = new StringBuffer();
        sb2.append("org.w3c.dom.NodeList nodes = element.getChildNodes();\n");
        sb2.append("for (int i = 0; i < nodes.getLength(); i++) {\n");
        sb2.append("org.w3c.dom.Node node = nodes.item (i);\n");
        sb2.append("switch (node.getNodeType()) {\n");
        sb2.append("case org.w3c.dom.Node.CDATA_SECTION_NODE:\n");
        sb2.append("// ((org.w3c.dom.CDATASection)node).getData();\nbreak;\n");
        sb2.append("case org.w3c.dom.Node.ELEMENT_NODE:\n");
        sb2.append("org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;\n");
        it = this.dtd.getElementDeclarations().iterator();
        while (it.hasNext()) {
            String tagName = ((TreeElementDecl)it.next()).getName();
            if (!elements.contains(tagName)) continue;
            sb2.append("if (nodeElement.getTagName().equals (\"").append(tagName).append("\")) {\n");
            sb2.append(METHOD_SCAN_ELEMENT).append("_").append(GenerateSupportUtils.getJavaName(tagName)).append(" (nodeElement);\n}\n");
        }
        sb2.append("break;\n");
        sb2.append("case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:\n");
        sb2.append("// ((org.w3c.dom.ProcessingInstruction)node).getTarget();\n");
        sb2.append("// ((org.w3c.dom.ProcessingInstruction)node).getData();\n");
        sb2.append("break;\n");
        if (type.allowText()) {
            sb2.append("case org.w3c.dom.Node.TEXT_NODE:\n");
            sb2.append("// ((org.w3c.dom.Text)node).getData();\n");
            sb2.append("break;\n");
        }
        sb2.append("}\n}\n");
        return sb2.toString();
    }

    private void addElements(TreeElementDecl.ContentType type, Set elements) {
        if (type instanceof ChildrenType) {
            for (TreeElementDecl.ContentType next : ((ChildrenType)type).getTypes()) {
                if (next instanceof ChildrenType) {
                    this.addElements(next, elements);
                    continue;
                }
                if (!(next instanceof NameType)) continue;
                elements.add(((NameType)next).getName());
            }
        }
    }

    private String findRootTagName() {
        return null;
    }
}

