/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.versioning.core.SPIAccessor;
import org.netbeans.modules.versioning.core.Utils;
import org.netbeans.modules.versioning.core.VersioningAnnotationProvider;
import org.netbeans.modules.versioning.core.VersioningConfig;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.filesystems.VCSFilesystemInterceptor;
import org.netbeans.modules.versioning.core.spi.VCSAnnotator;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.core.spi.VCSInterceptor;
import org.netbeans.modules.versioning.core.spi.VCSVisibilityQuery;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.netbeans.spi.queries.CollocationQueryImplementation2;
import org.openide.modules.Places;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class VersioningManager
implements PropertyChangeListener,
ChangeListener,
PreferenceChangeListener {
    public static final String EVENT_VERSIONED_ROOTS = "null VCS.VersionedFilesChanged";
    public static final String EVENT_STATUS_CHANGED = "Set<File> VCS.StatusChanged";
    public static final String EVENT_ANNOTATIONS_CHANGED = "Set<File> VCS.AnnotationsChanged";
    public static final String ATTRIBUTE_REMOTE_LOCATION = "ProvidedExtensions.RemoteLocation";
    static final String PROP_PRIORITY = "Integer VCS.Priority";
    private static VersioningManager instance;
    private static boolean initialized;
    private static boolean initializing;
    private static final Object INIT_LOCK;
    private static volatile Set<VCSFilesystemInterceptor.VCSAnnotationListener> statusListeners;
    private final List<VCSSystemProvider.VersioningSystem> versioningSystems = new ArrayList<VCSSystemProvider.VersioningSystem>(5);
    private final Map<VCSFileProxy, VCSSystemProvider.VersioningSystem> folderOwners = new HashMap<VCSFileProxy, VCSSystemProvider.VersioningSystem>(200);
    private final Map<VCSFileProxy, VCSSystemProvider.VersioningSystem> fileOwners = new LinkedHashMap<VCSFileProxy, VCSSystemProvider.VersioningSystem>(50){
        private final int MAX_SIZE = 50;
        {
            this.MAX_SIZE = 50;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<VCSFileProxy, VCSSystemProvider.VersioningSystem> eldest) {
            return this.size() > 50;
        }
    };
    private VCSSystemProvider.VersioningSystem localHistory;
    public static final Logger LOG;
    private final Map<VCSFileProxy, Boolean> localHistoryFiles = new LinkedHashMap<VCSFileProxy, Boolean>(200);
    private final Map<String, Set<String>> interceptedMethods = new HashMap<String, Set<String>>();
    private final VCSSystemProvider.VersioningSystem NULL_OWNER = new VCSSystemProvider.VersioningSystem(){

        @Override
        public boolean isLocalHistory() {
            throw new IllegalStateException();
        }

        @Override
        public VCSFileProxy getTopmostManagedAncestor(VCSFileProxy file) {
            throw new IllegalStateException();
        }

        @Override
        public VCSInterceptor getVCSInterceptor() {
            throw new IllegalStateException();
        }

        @Override
        public void getOriginalFile(VCSFileProxy workingCopy, VCSFileProxy originalFile) {
            throw new IllegalStateException();
        }

        @Override
        public CollocationQueryImplementation2 getCollocationQueryImplementation() {
            throw new IllegalStateException();
        }

        @Override
        public void addPropertyCL(PropertyChangeListener listener) {
            throw new IllegalStateException();
        }

        @Override
        public void removePropertyCL(PropertyChangeListener listener) {
            throw new IllegalStateException();
        }

        @Override
        public boolean isExcluded(VCSFileProxy file) {
            throw new IllegalStateException();
        }

        @Override
        public VCSAnnotator getVCSAnnotator() {
            throw new IllegalStateException();
        }

        @Override
        public VCSVisibilityQuery getVisibilityQuery() {
            throw new IllegalStateException();
        }

        public Object getDelegate() {
            throw new IllegalStateException();
        }

        @Override
        public String getDisplayName() {
            throw new IllegalStateException();
        }

        @Override
        public String getMenuLabel() {
            throw new IllegalStateException();
        }

        @Override
        public boolean accept(VCSContext ctx) {
            throw new IllegalStateException();
        }

        @Override
        public VCSHistoryProvider getVCSHistoryProvider() {
            throw new IllegalStateException();
        }

        @Override
        public boolean isMetadataFile(VCSFileProxy file) {
            throw new IllegalStateException();
        }
    };
    private final Lookup.Result<VCSSystemProvider> providersLookupResult;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static synchronized VersioningManager getInstance() {
        if (instance == null) {
            instance = new VersioningManager();
            instance.init();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        if (initialized && OpenProjects.getDefault().openProjects().isDone()) {
            return true;
        }
        Object object = INIT_LOCK;
        synchronized (object) {
            if (!initializing) {
                initializing = true;
                new RequestProcessor("Initialize VCS").post(VersioningManager::getInstance);
            }
        }
        return false;
    }

    public static void deliverStatusEvent(VCSFilesystemInterceptor.VCSAnnotationEvent ev) {
        for (VCSFilesystemInterceptor.VCSAnnotationListener l : statusListeners) {
            l.annotationChanged(ev);
        }
    }

    private VersioningManager() {
        this.providersLookupResult = Lookup.getDefault().lookupResult(VCSSystemProvider.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        try {
            VCSContext ctx = VCSContext.EMPTY;
            List<VCSSystemProvider.VersioningSystem> list = this.versioningSystems;
            synchronized (list) {
                Collection providers = this.providersLookupResult.allInstances();
                for (VCSSystemProvider p : providers) {
                    p.addChangeListener(this);
                }
                this.refreshVersioningSystems(true);
                OpenProjects.getDefault().addPropertyChangeListener(evt -> {
                    Object patt9588$temp;
                    if ("openProjects".equals(evt.getPropertyName()) && (patt9588$temp = evt.getOldValue()) instanceof Project[]) {
                        Project[] newV;
                        Project[] oldV = (Project[])patt9588$temp;
                        Object patt9664$temp = evt.getNewValue();
                        if (patt9664$temp instanceof Project[] && oldV.length < (newV = (Project[])patt9664$temp).length) {
                            VersioningManager.refreshAllAnnotations();
                        }
                    }
                });
            }
            VersioningSupport.getPreferences().addPreferenceChangeListener(this);
        }
        finally {
            initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshVersioningSystems(boolean fireAsync) {
        List<VCSSystemProvider.VersioningSystem> list = this.versioningSystems;
        synchronized (list) {
            for (VCSSystemProvider.VersioningSystem system : this.versioningSystems) {
                system.removePropertyCL(this);
            }
            this.versioningSystems.clear();
            Collection providers = this.providersLookupResult.allInstances();
            for (VCSSystemProvider p : providers) {
                Collection<VCSSystemProvider.VersioningSystem> systems = p.getVersioningSystems();
                this.localHistory = null;
                this.versioningSystems.addAll(systems);
                for (VCSSystemProvider.VersioningSystem system : this.versioningSystems) {
                    if (this.localHistory == null && system.isLocalHistory()) {
                        this.localHistory = system;
                    }
                    system.addPropertyCL(this);
                }
            }
        }
        if (fireAsync) {
            RequestProcessor.getDefault().post(this::versionedRootsChanged);
        } else {
            this.versionedRootsChanged();
        }
    }

    private void fireFileStatusChanged(Set<VCSFileProxy> files) {
        this.propertyChangeSupport.firePropertyChange(EVENT_STATUS_CHANGED, null, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushFileOwnerCache() {
        Map<VCSFileProxy, VCSSystemProvider.VersioningSystem> map = this.folderOwners;
        synchronized (map) {
            this.folderOwners.clear();
        }
        map = this.fileOwners;
        synchronized (map) {
            this.fileOwners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushNullOwners() {
        Map<VCSFileProxy, VCSSystemProvider.VersioningSystem> map = this.folderOwners;
        synchronized (map) {
            this.flushNullOwners(this.folderOwners);
        }
        map = this.fileOwners;
        synchronized (map) {
            this.flushNullOwners(this.fileOwners);
        }
    }

    private void flushNullOwners(Map<VCSFileProxy, VCSSystemProvider.VersioningSystem> map) {
        Iterator<VCSFileProxy> it = map.keySet().iterator();
        while (it.hasNext()) {
            if (!map.get(it.next()).equals(this.NULL_OWNER)) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VCSSystemProvider.VersioningSystem[] getVersioningSystems() {
        List<VCSSystemProvider.VersioningSystem> list = this.versioningSystems;
        synchronized (list) {
            return (VCSSystemProvider.VersioningSystem[])this.versioningSystems.toArray(VCSSystemProvider.VersioningSystem[]::new);
        }
    }

    VCSSystemProvider.VersioningSystem[] getOwners(VCSContext ctx) {
        Set<VCSFileProxy> files = ctx.getRootFiles();
        HashSet<VCSSystemProvider.VersioningSystem> owners = new HashSet<VCSSystemProvider.VersioningSystem>();
        for (VCSFileProxy file : files) {
            VCSSystemProvider.VersioningSystem vs = this.getOwner(file);
            if (vs == null) continue;
            owners.add(vs);
        }
        return (VCSSystemProvider.VersioningSystem[])owners.toArray(VCSSystemProvider.VersioningSystem[]::new);
    }

    public VCSSystemProvider.VersioningSystem getOwner(VCSFileProxy file) {
        return this.getOwner(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCSSystemProvider.VersioningSystem getOwner(VCSFileProxy file, Boolean isFile) {
        VCSSystemProvider.VersioningSystem[] vs;
        Map<VCSFileProxy, VCSSystemProvider.VersioningSystem> map;
        VCSSystemProvider.VersioningSystem owner;
        LOG.log(Level.FINE, "looking for owner of {0}", file);
        Map<VCSFileProxy, VCSSystemProvider.VersioningSystem> map2 = this.fileOwners;
        synchronized (map2) {
            owner = this.fileOwners.get(file);
        }
        if (owner == null) {
            map2 = this.folderOwners;
            synchronized (map2) {
                owner = this.folderOwners.get(file);
            }
        }
        if (owner != null) {
            if (owner == this.NULL_OWNER) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " cached NULL_OWNER of {0}", new Object[]{file});
                }
                return null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " cached owner {0} of {1}", new Object[]{owner.getClass().getName(), file});
            }
            return owner;
        }
        VCSFileProxy folder = file;
        if (isFile == null) {
            isFile = file.isFile();
        }
        if (isFile.booleanValue()) {
            folder = file.getParentFile();
            if (folder == null) {
                LOG.log(Level.FINE, " null parent");
                return null;
            }
            map = this.folderOwners;
            synchronized (map) {
                owner = this.folderOwners.get(folder);
            }
        }
        if (owner == null && VersioningSupport.isExcluded(folder)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " caching NULL_OWNER of excluded {0}", new Object[]{file});
            }
            if (isFile.booleanValue()) {
                map = this.fileOwners;
                synchronized (map) {
                    this.fileOwners.put(folder, this.NULL_OWNER);
                }
            }
            map = this.folderOwners;
            synchronized (map) {
                this.folderOwners.put(folder, this.NULL_OWNER);
            }
            return null;
        }
        if (owner != null) {
            map = this.fileOwners;
            synchronized (map) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " caching owner {0} of {1}", new Object[]{owner != null ? owner.getClass().getName() : null, file});
                }
                this.fileOwners.put(file, owner != null ? owner : this.NULL_OWNER);
            }
            if (owner == this.NULL_OWNER) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " cached NULL_OWNER of {0}", new Object[]{folder});
                }
                return null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " cached owner {0} of {1}", new Object[]{owner.getClass().getName(), folder});
            }
            return owner;
        }
        VCSFileProxy closestParent = null;
        for (VCSSystemProvider.VersioningSystem system : vs = this.getVersioningSystems()) {
            if (system == this.localHistory) continue;
            VCSFileProxy topmost = system.getTopmostManagedAncestor(folder);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " {0} returns {1} ", new Object[]{system.getClass().getName(), topmost});
            }
            if (topmost == null || closestParent != null && !Utils.isAncestorOrEqual(closestParent, topmost)) continue;
            if (VersioningConfig.getDefault().isDisconnected(system, topmost)) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, " skipping disconnected owner = {0} for {1}", new Object[]{system.getClass().getName(), topmost});
                continue;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " owner = {0}", new Object[]{system.getClass().getName()});
            }
            owner = system;
            closestParent = topmost;
        }
        Map<VCSFileProxy, VCSSystemProvider.VersioningSystem> map3 = this.folderOwners;
        synchronized (map3) {
            if (owner != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " caching owner {0} of {1}", new Object[]{owner != null ? owner.getClass().getName() : null, folder});
                }
                this.folderOwners.put(folder, owner);
            } else {
                while (folder != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, " caching unversioned folder {0}", new Object[]{folder});
                    }
                    this.folderOwners.put(folder, this.NULL_OWNER);
                    folder = folder.getParentFile();
                }
            }
        }
        Map<VCSFileProxy, VCSSystemProvider.VersioningSystem> map4 = this.fileOwners;
        synchronized (map4) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " caching owner {0} of {1}", new Object[]{owner != null ? owner.getClass().getName() : null, file});
            }
            this.fileOwners.put(file, owner != null ? owner : this.NULL_OWNER);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "owner = {0}", new Object[]{owner != null ? owner.getClass().getName() : null});
        }
        return owner;
    }

    public VCSSystemProvider.VersioningSystem getLocalHistory(VCSFileProxy file) {
        return this.getLocalHistory(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCSSystemProvider.VersioningSystem getLocalHistory(VCSFileProxy file, Boolean isFile) {
        boolean isManaged;
        Object isManagedByLocalHistory;
        VCSSystemProvider.VersioningSystem lh = this.localHistory;
        if (lh == null) {
            return null;
        }
        File nbUserdir = Places.getUserDirectory();
        if (nbUserdir != null && !Utils.isVersionUserdir() && Utils.isAncestorOrEqual(VCSFileProxy.createFileProxy(nbUserdir), file)) {
            return null;
        }
        Map<VCSFileProxy, Boolean> map = this.localHistoryFiles;
        synchronized (map) {
            isManagedByLocalHistory = this.localHistoryFiles.get(file);
            if (isManagedByLocalHistory != null && ((Boolean)isManagedByLocalHistory).booleanValue()) {
                return lh;
            }
        }
        VCSFileProxy folder = file;
        if (isFile == null) {
            isFile = file.isFile();
        }
        if (isFile.booleanValue() && (folder = file.getParentFile()) == null) {
            return null;
        }
        isManagedByLocalHistory = this.localHistoryFiles;
        synchronized (isManagedByLocalHistory) {
            Boolean isManagedByLocalHistory2 = this.localHistoryFiles.get(folder);
            if (isManagedByLocalHistory2 != null) {
                return isManagedByLocalHistory2 != false ? lh : null;
            }
        }
        lh.getDelegate();
        boolean bl = isManaged = lh.getTopmostManagedAncestor(folder) != null;
        if (isManaged) {
            this.putLocalHistoryFile(Boolean.TRUE, folder);
            return lh;
        }
        isManaged = lh.getTopmostManagedAncestor(file) != null;
        this.putLocalHistoryFile(isManaged, file);
        return isManaged ? lh : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putLocalHistoryFile(Boolean b, VCSFileProxy ... files) {
        Map<VCSFileProxy, Boolean> map = this.localHistoryFiles;
        synchronized (map) {
            if (this.localHistoryFiles.size() > 1500) {
                Iterator<VCSFileProxy> it = this.localHistoryFiles.keySet().iterator();
                for (int i = 0; i < 150; ++i) {
                    it.next();
                    it.remove();
                }
            }
            for (VCSFileProxy file : files) {
                this.localHistoryFiles.put(file, b);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshVersioningSystems(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (EVENT_STATUS_CHANGED.equals(evt.getPropertyName())) {
            Set files = (Set)evt.getNewValue();
            VersioningAnnotationProvider.getDefault().refreshAnnotations(files);
            this.fireFileStatusChanged(files);
        } else if (EVENT_ANNOTATIONS_CHANGED.equals(evt.getPropertyName())) {
            Set files = (Set)evt.getNewValue();
            VersioningAnnotationProvider.getDefault().refreshAnnotations(files);
        } else if (EVENT_VERSIONED_ROOTS.equals(evt.getPropertyName())) {
            if (this.localHistory != null && evt.getSource() == this.localHistory.getDelegate()) {
                Map<VCSFileProxy, Boolean> map = this.localHistoryFiles;
                synchronized (map) {
                    this.localHistoryFiles.clear();
                }
            } else {
                this.versionedRootsChanged(null);
            }
            this.propertyChangeSupport.firePropertyChange(EVENT_VERSIONED_ROOTS, null, null);
        }
    }

    public void versionedRootsChanged() {
        this.versionedRootsChanged(null);
        this.propertyChangeSupport.firePropertyChange(EVENT_VERSIONED_ROOTS, null, null);
    }

    private void versionedRootsChanged(VCSSystemProvider.VersioningSystem owner) {
        this.flushCachedContext();
        this.flushFileOwnerCache();
        this.fireFileStatusChanged(null);
        VersioningManager.refreshAllAnnotations();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        VersioningManager.refreshAllAnnotations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean needsLocalHistory(String methodName) {
        boolean ret;
        block8: {
            boolean bl;
            ret = false;
            try {
                List<VCSSystemProvider.VersioningSystem> list = this.versioningSystems;
                // MONITORENTER : list
                if (this.localHistory != null) break block8;
                bl = ret;
                // MONITOREXIT : list
                if (!LOG.isLoggable(Level.FINE)) return bl;
            }
            catch (Throwable throwable) {
                if (!LOG.isLoggable(Level.FINE)) throw throwable;
                LOG.log(Level.FINE, "needsLocalHistory method [{0}] returns {1}", new Object[]{methodName, ret});
                throw throwable;
            }
            LOG.log(Level.FINE, "needsLocalHistory method [{0}] returns {1}", new Object[]{methodName, ret});
            return bl;
        }
        Set<String> s = this.interceptedMethods.get(this.localHistory.getClass().getName());
        if (s == null) {
            Method[] m;
            s = new HashSet<String>();
            for (Method method : m = this.localHistory.getVCSInterceptor().getClass().getDeclaredMethods()) {
                if ((method.getModifiers() & 1) == 0) continue;
                s.add(method.getName());
            }
            this.interceptedMethods.put(this.localHistory.getClass().getName(), s);
        }
        boolean bl = ret = s.contains(methodName);
        // MONITOREXIT : list
        if (!LOG.isLoggable(Level.FINE)) return bl;
        LOG.log(Level.FINE, "needsLocalHistory method [{0}] returns {1}", new Object[]{methodName, ret});
        return bl;
    }

    public static synchronized void statusListener(VCSFilesystemInterceptor.VCSAnnotationListener listener, boolean add) {
        Set newSet = Collections.newSetFromMap(new WeakHashMap());
        newSet.addAll(statusListeners);
        if (add) {
            newSet.add(listener);
        } else {
            newSet.remove(listener);
        }
        statusListeners = newSet;
    }

    private static void refreshAllAnnotations() {
        VersioningAnnotationProvider.refreshAllAnnotations();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    boolean isLocalHistory(VCSSystemProvider.VersioningSystem system) {
        return system == this.localHistory;
    }

    private void flushCachedContext() {
        SPIAccessor.IMPL.flushCachedContext();
    }

    static {
        initialized = false;
        initializing = false;
        INIT_LOCK = new Object();
        statusListeners = Collections.emptySet();
        LOG = Logger.getLogger("org.netbeans.modules.versioning");
    }
}

