/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.xml.stax;

import java.io.IOException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public final class StaxXmlPullParser
implements XmlPullParser {
    private final XMLStreamReader xmlStreamReader;
    private int depth;
    private boolean delayedDepthDecrement;

    StaxXmlPullParser(XMLStreamReader xmlStreamReader) {
        this.xmlStreamReader = xmlStreamReader;
    }

    @Override
    public Object getProperty(String name) {
        return this.xmlStreamReader.getProperty(name);
    }

    @Override
    public String getInputEncoding() {
        return this.xmlStreamReader.getEncoding();
    }

    @Override
    public int getNamespaceCount() {
        return this.xmlStreamReader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int pos) {
        return this.xmlStreamReader.getNamespacePrefix(pos);
    }

    @Override
    public String getNamespaceUri(int pos) {
        return this.xmlStreamReader.getNamespaceURI(pos);
    }

    @Override
    public String getNamespace(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        NamespaceContext namespaceContext = this.xmlStreamReader.getNamespaceContext();
        return namespaceContext.getNamespaceURI(prefix);
    }

    @Override
    public String getNamespace() {
        String prefix = this.getPrefix();
        return this.getNamespace(prefix);
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public String getPositionDescription() {
        Location location = this.xmlStreamReader.getLocation();
        return location.toString();
    }

    @Override
    public int getLineNumber() {
        Location location = this.xmlStreamReader.getLocation();
        return location.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        Location location = this.xmlStreamReader.getLocation();
        return location.getColumnNumber();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.xmlStreamReader.isWhiteSpace();
    }

    @Override
    public String getText() {
        return this.xmlStreamReader.getText();
    }

    @Override
    public String getName() {
        QName qname = this.getQName();
        return qname.getLocalPart();
    }

    @Override
    public QName getQName() {
        return this.xmlStreamReader.getName();
    }

    @Override
    public String getPrefix() {
        return this.xmlStreamReader.getPrefix();
    }

    @Override
    public int getAttributeCount() {
        return this.xmlStreamReader.getAttributeCount();
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.xmlStreamReader.getAttributeNamespace(index);
    }

    @Override
    public String getAttributeName(int index) {
        QName qname = this.getAttributeQName(index);
        if (qname == null) {
            return null;
        }
        return qname.getLocalPart();
    }

    @Override
    public QName getAttributeQName(int index) {
        return this.xmlStreamReader.getAttributeName(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.xmlStreamReader.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this.xmlStreamReader.getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this.xmlStreamReader.getAttributeValue(index);
    }

    @Override
    public String getAttributeValue(String namespace, String name) {
        String namespaceURI = namespace;
        String localName = name;
        return this.xmlStreamReader.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public XmlPullParser.Event getEventType() {
        int staxEventInt = this.xmlStreamReader.getEventType();
        return StaxXmlPullParser.staxEventIntegerToEvent(staxEventInt);
    }

    @Override
    public XmlPullParser.Event next() throws XmlPullParserException {
        int staxEventInt;
        this.preNextEvent();
        try {
            staxEventInt = this.xmlStreamReader.next();
        }
        catch (XMLStreamException e) {
            throw new XmlPullParserException(e);
        }
        XmlPullParser.Event event = StaxXmlPullParser.staxEventIntegerToEvent(staxEventInt);
        switch (event) {
            case START_ELEMENT: {
                ++this.depth;
                break;
            }
            case END_ELEMENT: {
                this.delayedDepthDecrement = true;
                break;
            }
        }
        return event;
    }

    @Override
    public String nextText() throws IOException, XmlPullParserException {
        String nextText;
        try {
            nextText = this.xmlStreamReader.getElementText();
        }
        catch (XMLStreamException e) {
            throw new XmlPullParserException(e);
        }
        this.delayedDepthDecrement = true;
        return nextText;
    }

    @Override
    public XmlPullParser.TagEvent nextTag() throws IOException, XmlPullParserException {
        int staxEventInt;
        this.preNextEvent();
        try {
            staxEventInt = this.xmlStreamReader.nextTag();
        }
        catch (XMLStreamException e) {
            throw new XmlPullParserException(e);
        }
        switch (staxEventInt) {
            case 1: {
                ++this.depth;
                return XmlPullParser.TagEvent.START_ELEMENT;
            }
            case 2: {
                this.delayedDepthDecrement = true;
                return XmlPullParser.TagEvent.END_ELEMENT;
            }
        }
        throw new AssertionError();
    }

    private void preNextEvent() {
        if (this.delayedDepthDecrement) {
            --this.depth;
            this.delayedDepthDecrement = false;
            assert (this.depth >= 0);
        }
    }

    private static XmlPullParser.Event staxEventIntegerToEvent(int staxEventInt) {
        switch (staxEventInt) {
            case 1: {
                return XmlPullParser.Event.START_ELEMENT;
            }
            case 2: {
                return XmlPullParser.Event.END_ELEMENT;
            }
            case 3: {
                return XmlPullParser.Event.PROCESSING_INSTRUCTION;
            }
            case 4: {
                return XmlPullParser.Event.TEXT_CHARACTERS;
            }
            case 5: {
                return XmlPullParser.Event.COMMENT;
            }
            case 6: {
                return XmlPullParser.Event.IGNORABLE_WHITESPACE;
            }
            case 7: {
                return XmlPullParser.Event.START_DOCUMENT;
            }
            case 8: {
                return XmlPullParser.Event.END_DOCUMENT;
            }
            case 9: {
                return XmlPullParser.Event.ENTITY_REFERENCE;
            }
            case 10: {
                return XmlPullParser.Event.OTHER;
            }
            case 11: {
                return XmlPullParser.Event.OTHER;
            }
            case 12: {
                return XmlPullParser.Event.OTHER;
            }
            case 13: {
                return XmlPullParser.Event.OTHER;
            }
            case 14: {
                return XmlPullParser.Event.OTHER;
            }
            case 15: {
                return XmlPullParser.Event.OTHER;
            }
        }
        throw new IllegalArgumentException("Unknown Stax event integer: " + staxEventInt);
    }

    @Override
    public boolean supportsRoundtrip() {
        return false;
    }
}

