/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.enterprise;

import ca.sqlpower.architect.enterprise.ArchitectClientSideSession;
import ca.sqlpower.enterprise.ClientSideSessionUtils;
import ca.sqlpower.enterprise.DataSourceCollectionUpdater;
import ca.sqlpower.enterprise.client.ProjectLocation;
import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.sql.DatabaseListChangeEvent;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sql.Olap4jDataSource;
import ca.sqlpower.sql.SPDataSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;

public class ArchitectDataSourceCollectionUpdater
extends DataSourceCollectionUpdater {
    private static Logger logger = Logger.getLogger(ArchitectDataSourceCollectionUpdater.class);

    public ArchitectDataSourceCollectionUpdater(ProjectLocation projectLocation) {
        super(projectLocation);
    }

    public HttpClient getHttpClient() {
        return ArchitectClientSideSession.createHttpClient(this.projectLocation.getServiceInfo());
    }

    public void databaseAdded(DatabaseListChangeEvent e) {
        SPDataSource source = e.getDataSource();
        source.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        ArrayList<NameValuePair> properties = new ArrayList<NameValuePair>();
        for (Map.Entry ent : source.getPropertiesMap().entrySet()) {
            properties.add((NameValuePair)new BasicNameValuePair((String)ent.getKey(), (String)ent.getValue()));
        }
        if (source instanceof Olap4jDataSource) {
            this.postOlapDataSourceProperties((Olap4jDataSource)source, properties);
        }
        super.databaseAdded(e, source, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postOlapDataSourceProperties(Olap4jDataSource ods, List<NameValuePair> properties) {
        if (this.postingProperties) {
            return;
        }
        HttpClient httpClient = ArchitectClientSideSession.createHttpClient(this.projectLocation.getServiceInfo());
        try {
            File schemaFile = new File(ods.getMondrianSchema());
            if (!schemaFile.exists()) {
                logger.error((Object)("Schema file " + schemaFile.getAbsolutePath() + " does not exist for data source " + ods.getName()));
            }
            HttpPost request = new HttpPost(ClientSideSessionUtils.getServerURI((SPServerInfo)this.projectLocation.getServiceInfo(), (String)("/mondrian" + schemaFile.getName())));
            request.setEntity((HttpEntity)new FileEntity(schemaFile, "text/xml"));
            httpClient.execute((HttpUriRequest)request, this.responseHandler);
            for (int i = properties.size() - 1; i >= 0; --i) {
                NameValuePair pair = properties.get(i);
                if (!pair.getName().equals("mondrianSchema")) continue;
                properties.add((NameValuePair)new BasicNameValuePair("mondrianSchema", "server:" + schemaFile.getName()));
                properties.remove(pair);
                break;
            }
            try {
                this.postingProperties = true;
                ods.setMondrianSchema(new URI("server:" + schemaFile.getName()));
            }
            finally {
                this.postingProperties = false;
            }
            request = new HttpPost(this.olapDataSourceURI((SPDataSource)ods));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(properties));
            httpClient.execute((HttpUriRequest)request, this.responseHandler);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private URI olapDataSourceURI(SPDataSource jds) throws URISyntaxException {
        if (!(jds instanceof Olap4jDataSource)) {
            throw new IllegalStateException("DataSource must be an instance of JDBCDataSource");
        }
        return ClientSideSessionUtils.getServerURI((SPServerInfo)this.projectLocation.getServiceInfo(), (String)("/rest/data-sources/Olap4jDataSource/" + jds.getName()));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        ArrayList<NameValuePair> properties;
        Object source = evt.getSource();
        if (source instanceof SPDataSource) {
            SPDataSource ds = (SPDataSource)source;
            ds.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            properties = new ArrayList<NameValuePair>();
            for (Map.Entry ent : ds.getPropertiesMap().entrySet()) {
                properties.add((NameValuePair)new BasicNameValuePair((String)ent.getKey(), (String)ent.getValue()));
            }
            if (ds instanceof Olap4jDataSource) {
                this.postOlapDataSourceProperties((Olap4jDataSource)ds, properties);
            }
            super.propertyChange(evt, ds, properties);
        }
        if (source instanceof JDBCDataSourceType) {
            JDBCDataSourceType jdst = (JDBCDataSourceType)source;
            jdst.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            properties = new ArrayList();
            for (String name : jdst.getPropertyNames()) {
                properties.add((NameValuePair)new BasicNameValuePair(name, jdst.getProperty(name)));
            }
            this.postJDBCDataSourceTypeProperties(jdst, properties);
        }
    }
}

