/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepLoaderException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.LanguageChoice;
import org.pentaho.di.i18n.LoaderInputStreamProvider;
import org.pentaho.di.trans.KettleURLClassLoader;
import org.pentaho.di.trans.Messages;
import org.pentaho.di.trans.Partitioner;
import org.pentaho.di.trans.StepPlugin;
import org.pentaho.di.trans.StepPluginMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepCategory;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepLoader
implements LoaderInputStreamProvider {
    private static StepLoader stepLoader = null;
    private String[] pluginDirectory;
    private List<StepPlugin> pluginList;
    private Map<String[], URLClassLoader> classLoaders;
    private static Map<String, Partitioner> partitionerMap;
    private static final int PLUGIN_TYPE_STEP = 1;
    private static final int PLUGIN_TYPE_PARTIONER = 2;

    private StepLoader(String[] pluginDirectory) {
        this.pluginDirectory = pluginDirectory;
        this.pluginList = new ArrayList<StepPlugin>();
        this.classLoaders = new Hashtable<String[], URLClassLoader>();
        partitionerMap = new Hashtable<String, Partitioner>();
    }

    public static final StepLoader getInstance(String[] pluginDirectory) {
        if (stepLoader != null) {
            return stepLoader;
        }
        stepLoader = new StepLoader(pluginDirectory);
        return stepLoader;
    }

    public static final StepLoader getInstance() {
        if (stepLoader != null) {
            return stepLoader;
        }
        stepLoader = new StepLoader(new String[]{Const.PLUGIN_STEPS_DIRECTORY_PUBLIC, Const.PLUGIN_STEPS_DIRECTORY_PRIVATE});
        return stepLoader;
    }

    public boolean read() throws KettleException {
        this.readNatives();
        this.readPlugins();
        return true;
    }

    public static final void init(String[] pluginDirectory) throws KettleException {
        StepLoader loader = StepLoader.getInstance(pluginDirectory);
        loader.readNatives();
        loader.readPlugins();
    }

    public static final void init() throws KettleException {
        StepLoader.init(new String[]{Const.PLUGIN_STEPS_DIRECTORY_PUBLIC, Const.PLUGIN_STEPS_DIRECTORY_PRIVATE});
    }

    public void readNatives() {
        for (int i = 0; i < BaseStep.steps.length; ++i) {
            String category;
            String classname;
            String iconfile;
            String[] jarfiles;
            String directory;
            String tooltip;
            String long_desc;
            StepPluginMeta pluginMeta = BaseStep.steps[i];
            String[] id = pluginMeta.getId();
            StepPlugin sp = new StepPlugin(1, id, long_desc = pluginMeta.getLongDesc(), tooltip = pluginMeta.getTooltipDesc(), directory = null, jarfiles = null, iconfile = pluginMeta.getImageFileName(), classname = pluginMeta.getClassName().getName(), category = pluginMeta.getCategory(), null);
            if (sp.handles("ScriptValues")) {
                sp.setSeparateClassloaderNeeded(true);
            }
            this.pluginList.add(sp);
        }
    }

    protected void readPluginFromResource(InputStream docStream, String path, String dir, int type) throws KettleException {
        try {
            Node plugin;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(docStream);
            Node plugins = XMLHandler.getSubNode((Node)doc, (String)"plugins");
            if (plugins != null) {
                for (plugin = plugins.getFirstChild(); plugin != null; plugin = plugin.getNextSibling()) {
                    if ("plugin".equals(plugin.getNodeName())) {
                        this.readPluginFromResource(plugin, path, dir, type, 1);
                    }
                    if (!"plugin-partitioner".equals(plugin.getNodeName())) continue;
                    this.readPluginFromResource(plugin, path, dir, type, 2);
                }
            }
            if ((plugin = XMLHandler.getSubNode((Node)doc, (String)"plugin")) != null) {
                if ("plugin".equals(plugin.getNodeName())) {
                    this.readPluginFromResource(plugin, path, dir, type, 1);
                }
                if ("plugin-partitioner".equals(plugin.getNodeName())) {
                    this.readPluginFromResource(plugin, path, dir, type, 2);
                }
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("StepLoader.RuntimeError.UnableToReadPluginXML.TRANS0001"), (Throwable)e);
        }
    }

    protected void readPluginFromResource(Node plugin, String path, String dir, int type, int pluginType) throws KettleException {
        block14: {
            try {
                String id = XMLHandler.getTagAttribute((Node)plugin, (String)"id");
                String description = XMLHandler.getTagAttribute((Node)plugin, (String)"description");
                String iconfile = XMLHandler.getTagAttribute((Node)plugin, (String)"iconfile");
                String tooltip = XMLHandler.getTagAttribute((Node)plugin, (String)"tooltip");
                String category = XMLHandler.getTagAttribute((Node)plugin, (String)"category");
                String classname = XMLHandler.getTagAttribute((Node)plugin, (String)"classname");
                String errorHelpfile = XMLHandler.getTagAttribute((Node)plugin, (String)"errorhelpfile");
                Node libsnode = XMLHandler.getSubNode((Node)plugin, (String)"libraries");
                int nrlibs = XMLHandler.countNodes((Node)libsnode, (String)"library");
                String[] jarfiles = new String[nrlibs];
                if (path != null) {
                    for (int j = 0; j < nrlibs; ++j) {
                        Node libnode = XMLHandler.getSubNodeByNr((Node)libsnode, (String)"library", (int)j);
                        String jarfile = XMLHandler.getTagAttribute((Node)libnode, (String)"name");
                        jarfiles[j] = path + Const.FILE_SEPARATOR + jarfile;
                    }
                }
                Node locCatsNode = XMLHandler.getSubNode((Node)plugin, (String)"localized_category");
                int nrLocCats = XMLHandler.countNodes((Node)locCatsNode, (String)"category");
                Hashtable<String, String> localizedCategories = new Hashtable<String, String>();
                for (int j = 0; j < nrLocCats; ++j) {
                    Node locCatNode = XMLHandler.getSubNodeByNr((Node)locCatsNode, (String)"category", (int)j);
                    String locale = XMLHandler.getTagAttribute((Node)locCatNode, (String)"locale");
                    String locCat = XMLHandler.getNodeValue((Node)locCatNode);
                    if (Const.isEmpty((String)locale) || Const.isEmpty((String)locCat)) continue;
                    localizedCategories.put(locale.toLowerCase(), locCat);
                }
                Node locDescsNode = XMLHandler.getSubNode((Node)plugin, (String)"localized_description");
                int nrLocDescs = XMLHandler.countNodes((Node)locDescsNode, (String)"description");
                Hashtable<String, String> localizedDescriptions = new Hashtable<String, String>();
                for (int j = 0; j < nrLocDescs; ++j) {
                    Node locDescNode = XMLHandler.getSubNodeByNr((Node)locDescsNode, (String)"description", (int)j);
                    String locale = XMLHandler.getTagAttribute((Node)locDescNode, (String)"locale");
                    String locDesc = XMLHandler.getNodeValue((Node)locDescNode);
                    if (Const.isEmpty((String)locale) || Const.isEmpty((String)locDesc)) continue;
                    localizedDescriptions.put(locale.toLowerCase(), locDesc);
                }
                Node locTipsNode = XMLHandler.getSubNode((Node)plugin, (String)"localized_tooltip");
                int nrLocTips = XMLHandler.countNodes((Node)locTipsNode, (String)"tooltip");
                Hashtable<String, String> localizedTooltips = new Hashtable<String, String>();
                for (int j = 0; j < nrLocTips; ++j) {
                    Node locTipNode = XMLHandler.getSubNodeByNr((Node)locTipsNode, (String)"tooltip", (int)j);
                    String locale = XMLHandler.getTagAttribute((Node)locTipNode, (String)"locale");
                    String locTip = XMLHandler.getNodeValue((Node)locTipNode);
                    if (Const.isEmpty((String)locale) || Const.isEmpty((String)locTip)) continue;
                    localizedTooltips.put(locale.toLowerCase(), locTip);
                }
                String iconFilename = path == null ? iconfile : path + Const.FILE_SEPARATOR + iconfile;
                String errorHelpFileFull = errorHelpfile;
                if (!Const.isEmpty((String)errorHelpfile)) {
                    String string = errorHelpFileFull = path == null ? errorHelpfile : path + Const.FILE_SEPARATOR + errorHelpfile;
                }
                if (pluginType == 1) {
                    StepPlugin sp = new StepPlugin(type, new String[]{id}, description, tooltip, dir, jarfiles, iconFilename, classname, category, errorHelpFileFull);
                    sp.setLocalizedCategories(localizedCategories);
                    sp.setLocalizedDescriptions(localizedDescriptions);
                    sp.setLocalizedTooltips(localizedTooltips);
                    if (this.findStepPluginWithID(id) == null) {
                        this.pluginList.add(sp);
                    } else {
                        int idx = this.pluginList.indexOf((Object)sp);
                        this.pluginList.set(idx, sp);
                    }
                    break block14;
                }
                if (pluginType != 2) break block14;
                try {
                    Class<?> pClass = Class.forName(classname);
                    if (pClass != null) {
                        Partitioner partitioner = (Partitioner)pClass.newInstance();
                        partitioner.setId(id);
                        partitioner.setDescription(description);
                        partitionerMap.put(id, partitioner);
                    }
                }
                catch (Throwable e) {
                    LogWriter.getInstance().logError("StepLoader", Messages.getString("StepLoader.RuntimeError.UnableToReadPluginXML.TRANS0001") + e.toString(), new Object[0]);
                    LogWriter.getInstance().logError("StepLoader", Const.getStackTracker((Throwable)e), new Object[0]);
                }
            }
            catch (Throwable e) {
                throw new KettleException(Messages.getString("StepLoader.RuntimeError.UnableToReadPluginXML.TRANS0001"), e);
            }
        }
    }

    public void readPlugins() throws KettleException {
        InputStream content;
        LogWriter log = LogWriter.getInstance();
        try {
            content = this.getClass().getClassLoader().getResourceAsStream("META-INF/step_plugin.xml");
            if (content != null) {
                this.readPluginFromResource(content, null, null, 1);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to load plugins specified in 'META-INF/step_plugin.xml' files", (Throwable)e);
        }
        try {
            content = this.getClass().getClassLoader().getResourceAsStream("META-INF/kettle-partition-plugins.xml");
            if (content != null) {
                this.readPluginFromResource(content, null, null, 1);
            }
            if ((content = this.getClass().getClassLoader().getResourceAsStream("kettle-partition-plugins.xml")) != null) {
                this.readPluginFromResource(content, null, null, 1);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to load plugins specified in 'META-INF/kettle-partition-plugins.xml' files", (Throwable)e);
        }
        for (int dirNr = 0; dirNr < this.pluginDirectory.length; ++dirNr) {
            try {
                File f = new File(this.pluginDirectory[dirNr]);
                if (f.isDirectory() && f.exists()) {
                    log.logDetailed(Messages.getString("StepLoader.Log.StepLoader.Title"), Messages.getString("StepLoader.Log.StepLoader.Description") + this.pluginDirectory[dirNr], new Object[0]);
                    String[] dirs = f.list();
                    for (int i = 0; i < dirs.length; ++i) {
                        String piDir = this.pluginDirectory[dirNr] + Const.FILE_SEPARATOR + dirs[i];
                        File pi = new File(piDir);
                        if (pi.isDirectory()) {
                            String pixml = pi.toString() + Const.FILE_SEPARATOR + "plugin.xml";
                            File fpixml = new File(pixml);
                            if (fpixml.canRead()) {
                                this.readPluginFromResource(new FileInputStream(fpixml), pi.getPath(), dirs[i], 2);
                                continue;
                            }
                            log.logDetailed(Messages.getString("StepLoader.Log.StepLoader.Title"), "Plugin file [" + fpixml + "] is not readable.", new Object[0]);
                            continue;
                        }
                        log.logDetailed(Messages.getString("StepLoader.Log.StepLoader.Title"), "Plugin directory [" + piDir + "] is not a directory.", new Object[0]);
                    }
                    continue;
                }
                log.logDebug(Messages.getString("StepLoader.Log.StepLoader.Title"), "Plugin directory not found, ignoring this: [" + this.pluginDirectory[dirNr] + "]", new Object[0]);
                continue;
            }
            catch (Exception e) {
                throw new KettleException(Messages.getString("StepLoader.RuntimeError.CouldNotFindDirectory.TRANS0002", this.pluginDirectory[dirNr]), (Throwable)e);
            }
        }
    }

    public StepMetaInterface getStepClass(String desc) throws KettleStepLoaderException {
        StepPlugin sp = this.findStepPluginWithDescription(desc);
        if (sp != null) {
            return this.getStepClass(sp);
        }
        throw new KettleStepLoaderException(Messages.getString("StepLoader.RuntimeError.UnableToLoadClass.TRANS0003", desc + "]." + Const.CR));
    }

    public StepMetaInterface getStepClass(StepPlugin sp) throws KettleStepLoaderException {
        if (sp != null) {
            try {
                Class<?> cl = null;
                switch (sp.getType()) {
                    case 1: {
                        cl = Class.forName(sp.getClassname());
                        break;
                    }
                    case 2: {
                        String[] jarfiles = sp.getJarfiles();
                        URL[] urls = new URL[jarfiles.length];
                        for (int i = 0; i < jarfiles.length; ++i) {
                            File jarfile = new File(jarfiles[i]);
                            urls[i] = jarfile.toURI().toURL();
                        }
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        URLClassLoader ucl = null;
                        if (sp.isSeparateClassloaderNeeded()) {
                            ucl = new KettleURLClassLoader(urls, classLoader, sp.getDescription());
                        } else {
                            ucl = this.classLoaders.get(sp.getID());
                            if (ucl == null) {
                                ucl = new KettleURLClassLoader(urls, classLoader, sp.getDescription());
                                this.classLoaders.put((String[])sp.getID(), ucl);
                            }
                        }
                        cl = ucl.loadClass(sp.getClassname());
                        break;
                    }
                    default: {
                        throw new KettleStepLoaderException(Messages.getString("StepLoader.RuntimeError.UnknownPluginType.TRANS0004") + sp.getType());
                    }
                }
                return (StepMetaInterface)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new KettleStepLoaderException(Messages.getString("StepLoader.RuntimeError.ClassNotFound.TRANS0005"), (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new KettleStepLoaderException(Messages.getString("StepLoader.RuntimeError.UnableToInstantiateClass.TRANS0006"), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new KettleStepLoaderException(Messages.getString("StepLoader.RuntimeError.IllegalAccessToClass.TRANS0007"), (Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new KettleStepLoaderException(Messages.getString("StepLoader.RuntimeError.MalformedURL.TRANS0008"), (Throwable)e);
            }
            catch (Throwable e) {
                throw new KettleStepLoaderException(Messages.getString("StepLoader.RuntimeError.UnExpectedErrorLoadingClass.TRANS0009"), e);
            }
        }
        throw new KettleStepLoaderException(Messages.getString("StepLoader.RuntimeError.NoValidStepOrPlugin.TRANS0010"));
    }

    public int nrStepsWithType(int type) {
        int nr = 0;
        for (int i = 0; i < this.pluginList.size(); ++i) {
            StepPlugin sp = this.pluginList.get(i);
            if (sp.getType() != type && type != 0) continue;
            ++nr;
        }
        return nr;
    }

    public StepPlugin getStepWithType(int type, int position) {
        int nr = 0;
        for (int i = 0; i < this.pluginList.size(); ++i) {
            StepPlugin sp = this.pluginList.get(i);
            if (sp.getType() != type && type != 0) continue;
            if (nr == position) {
                return sp;
            }
            ++nr;
        }
        return null;
    }

    public StepPlugin[] getStepsWithType(int type) {
        int nr = this.nrStepsWithType(type);
        StepPlugin[] steps = new StepPlugin[nr];
        for (int i = 0; i < steps.length; ++i) {
            StepPlugin sp;
            steps[i] = sp = this.getStepWithType(type, i);
        }
        return steps;
    }

    public StepPlugin findStepPluginWithID(String stepid) {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            StepPlugin sp = this.pluginList.get(i);
            if (!sp.handles(stepid)) continue;
            return sp;
        }
        return null;
    }

    public StepPlugin findStepPluginWithDescription(String description) {
        return this.findStepPluginWithDescription(description, LanguageChoice.getInstance().getDefaultLocale().toString().toLowerCase());
    }

    public StepPlugin findStepPluginWithDescription(String description, String locale) {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            StepPlugin sp = this.pluginList.get(i);
            if (!sp.getDescription(locale).equalsIgnoreCase(description)) continue;
            return sp;
        }
        return null;
    }

    public String[] getCategories(int type) {
        return this.getCategories(type, LanguageChoice.getInstance().getDefaultLocale().toString().toLowerCase());
    }

    public String[] getCategories(int type, String locale) {
        Hashtable<String, String> cat = new Hashtable<String, String>();
        for (int i = 0; i < this.nrStepsWithType(type); ++i) {
            StepPlugin sp = this.getStepWithType(type, i);
            if (sp == null) continue;
            cat.put(sp.getCategory(locale), sp.getCategory(locale));
        }
        Enumeration keys = cat.keys();
        String[] retval = new String[cat.size()];
        int i = 0;
        while (keys.hasMoreElements()) {
            retval[i] = (String)keys.nextElement();
            ++i;
        }
        for (int a = 0; a < retval.length; ++a) {
            for (int b = 0; b < retval.length - 1; ++b) {
                int idx1 = -1;
                for (int x = 0; x < StepCategory.STANDARD_CATEGORIES.length; ++x) {
                    StepCategory category = StepCategory.STANDARD_CATEGORIES[x];
                    if (!category.getName().equalsIgnoreCase(retval[b])) continue;
                    idx1 = x;
                    break;
                }
                int idx2 = -1;
                for (int x = 0; x < StepCategory.STANDARD_CATEGORIES.length; ++x) {
                    StepCategory category = StepCategory.STANDARD_CATEGORIES[x];
                    if (!category.getName().equalsIgnoreCase(retval[b + 1])) continue;
                    idx2 = x;
                    break;
                }
                if (idx1 <= idx2) continue;
                String dummy = retval[b];
                retval[b] = retval[b + 1];
                retval[b + 1] = dummy;
            }
        }
        return retval;
    }

    public int nrStepsWithCategory(String category) {
        int nr = 0;
        for (int i = 0; i < this.pluginList.size(); ++i) {
            StepPlugin sp = this.pluginList.get(i);
            if (!sp.getCategory().equalsIgnoreCase(category)) continue;
            ++nr;
        }
        return nr;
    }

    public StepPlugin getStepWithCategory(String category, int position) {
        int nr = 0;
        for (int i = 0; i < this.pluginList.size(); ++i) {
            StepPlugin sp = this.pluginList.get(i);
            if (!sp.getCategory().equalsIgnoreCase(category)) continue;
            if (nr == position) {
                return sp;
            }
            ++nr;
        }
        return null;
    }

    public StepPlugin[] getStepsWithCategory(String category) {
        int nr = this.nrStepsWithCategory(category);
        StepPlugin[] steps = new StepPlugin[nr];
        for (int i = 0; i < steps.length; ++i) {
            StepPlugin sp;
            steps[i] = sp = this.getStepWithCategory(category, i);
        }
        return steps;
    }

    public String getStepPluginID(StepMetaInterface sii) {
        for (StepPlugin sp : this.pluginList) {
            if (!sp.getClassname().equals(sii.getClass().getName())) continue;
            return ((String[])sp.getID())[0];
        }
        return null;
    }

    public StepPlugin getStepPlugin(StepMetaInterface sii) {
        for (StepPlugin sp : this.pluginList) {
            if (!sp.getClassname().equals(sii.getClass().getName())) continue;
            return sp;
        }
        return null;
    }

    public InputStream getInputStreamForFile(String filename) {
        StepPlugin[] stepPlugins = this.getStepsWithType(2);
        for (int i = 0; i < stepPlugins.length; ++i) {
            try {
                StepPlugin stepPlugin = stepPlugins[i];
                String[] jarfiles = stepPlugin.getJarfiles();
                if (jarfiles == null) continue;
                for (int j = 0; j < jarfiles.length; ++j) {
                    InputStream inputStream;
                    JarFile jarFile = new JarFile(jarfiles[j]);
                    JarEntry jarEntry = filename.startsWith("/") ? jarFile.getJarEntry(filename.substring(1)) : jarFile.getJarEntry(filename);
                    if (jarEntry == null || (inputStream = jarFile.getInputStream(jarEntry)) == null) continue;
                    return inputStream;
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public List<StepPlugin> getPluginList() {
        return this.pluginList;
    }

    public static Map<String, Partitioner> getPartitionerList() {
        return partitionerMap;
    }

    public static Partitioner getPartitioner(String id) {
        return partitionerMap.get(id);
    }

    public List<Object[]> getPluginInformation() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (StepPlugin plugin : this.pluginList) {
            list.add(plugin.getPluginInformation());
        }
        return list;
    }

    public String[] getPluginPackages() {
        ArrayList<String> list = new ArrayList<String>();
        for (StepPlugin stepPlugin : this.pluginList) {
            int lastIndex;
            String className = stepPlugin.getClassname();
            String packageName = className.substring(0, lastIndex = className.lastIndexOf("."));
            if (list.contains(packageName)) continue;
            list.add(packageName);
        }
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }
}

