/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import org.pentaho.di.trans.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KettleURLClassLoader
extends URLClassLoader {
    private String name;

    public KettleURLClassLoader(URL[] url, ClassLoader classLoader) {
        super(url, classLoader);
    }

    public KettleURLClassLoader(URL[] url, ClassLoader classLoader, String name) {
        this(url, classLoader);
        this.name = name;
    }

    public String toString() {
        return super.toString() + " : " + this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Class<?> loadClass(String name, ProtectionDomain protectionDomain) {
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded == null) {
            String newName = name.replace('.', '/');
            InputStream is = super.getResourceAsStream(newName);
            byte[] driverBytes = this.toBytes(is);
            loaded = super.defineClass(name, driverBytes, 0, driverBytes.length, protectionDomain);
        }
        return loaded;
    }

    private byte[] toBytes(InputStream is) {
        byte[] retval = new byte[]{};
        try {
            int a = is.available();
            while (a > 0) {
                int i;
                byte[] buffer = new byte[a];
                is.read(buffer);
                byte[] newretval = new byte[retval.length + a];
                for (i = 0; i < retval.length; ++i) {
                    newretval[i] = retval[i];
                }
                for (i = 0; i < a; ++i) {
                    newretval[retval.length + i] = buffer[i];
                }
                retval = newretval;
                a = is.available();
            }
            return retval;
        }
        catch (Exception e) {
            System.out.println(Messages.getString("KettleURLClassLoader.Exception.UnableToReadClass") + e.toString());
            return null;
        }
    }
}

