/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.log4j.Appender;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.gui.JobTracker;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.logging.Log4jStringAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobEntryResult;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobListener;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.Messages;
import org.pentaho.di.job.entries.special.JobEntrySpecial;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceUtil;
import org.pentaho.di.resource.TopLevelResource;
import org.pentaho.di.trans.StepLoader;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.WebResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Job
extends Thread
implements VariableSpace,
NamedParams {
    public static final String CONFIGURATION_IN_EXPORT_FILENAME = "__job_execution_configuration__.xml";
    private LogWriter log;
    private JobMeta jobMeta;
    private Repository rep;
    private int errors = 0;
    private VariableSpace variables = new Variables();
    private Job parentJob;
    private JobTracker jobTracker;
    private Date startDate;
    private Date endDate;
    private Date currentDate;
    private Date logDate;
    private Date depDate;
    private boolean active;
    private boolean stopped;
    private long batchId;
    private long passedBatchId;
    private List<RowMetaAndData> sourceRows;
    private Result result;
    private boolean initialized;
    private Log4jStringAppender stringAppender;
    private List<JobListener> jobListeners;
    private NamedParams namedParams = new NamedParamsDefault();
    private boolean finished;
    private SocketRepository socketRepository;

    public Job(LogWriter lw, String name, String file, String[] args) {
        this();
        this.init(lw, name, file, args);
    }

    public void init(LogWriter lw, String name, String file, String[] args) {
        this.log = lw;
        if (name != null) {
            this.setName(name + " (" + super.getName() + ")");
        }
        this.jobMeta = new JobMeta(this.log);
        this.jobMeta.setName(name);
        this.jobMeta.setFilename(file);
        this.jobMeta.setArguments(args);
        this.active = false;
        this.stopped = false;
        this.jobTracker = new JobTracker(this.jobMeta);
        this.initialized = false;
        this.batchId = -1L;
        this.passedBatchId = -1L;
        this.result = null;
    }

    public Job(LogWriter lw, StepLoader steploader, Repository rep, JobMeta ti) {
        this();
        this.open(lw, steploader, rep, ti);
        if (ti.getName() != null) {
            this.setName(ti.getName() + " (" + super.getName() + ")");
        }
    }

    public Job(LogWriter lw, Repository rep, JobMeta ti) {
        this();
        this.open(lw, null, rep, ti);
        if (ti.getName() != null) {
            this.setName(ti.getName() + " (" + super.getName() + ")");
        }
    }

    public Job() {
        this.jobListeners = new ArrayList<JobListener>();
        this.log = LogWriter.getInstance();
    }

    public void open(LogWriter lw, Repository rep, JobMeta ti) {
        this.open(lw, null, rep, ti);
    }

    public void open(LogWriter lw, StepLoader steploader, Repository rep, JobMeta ti) {
        this.log = lw;
        this.rep = rep;
        this.jobMeta = ti;
        if (ti.getName() != null) {
            this.setName(ti.getName() + " (" + super.getName() + ")");
        }
        this.active = false;
        this.stopped = false;
        this.jobTracker = new JobTracker(this.jobMeta);
    }

    public void open(Repository rep, String fname, String jobname, String dirname, OverwritePrompter prompter) throws KettleException {
        this.rep = rep;
        this.jobMeta = rep != null ? new JobMeta(this.log, rep, jobname, rep.getDirectoryTree().findDirectory(dirname)) : new JobMeta(this.log, fname, rep, prompter);
        if (this.jobMeta.getName() != null) {
            this.setName(this.jobMeta.getName() + " (" + super.getName() + ")");
        }
    }

    public static final Job createJobWithNewClassLoader() throws KettleException {
        try {
            Class<?> jobClass = Const.createNewClassLoader().loadClass(Job.class.getName());
            Job job = (Job)jobClass.newInstance();
            return job;
        }
        catch (Exception e) {
            String message = Messages.getString("Job.Log.ErrorAllocatingNewJob", e.toString());
            LogWriter.getInstance().logError("Create Job in new ClassLoader", message, new Object[0]);
            LogWriter.getInstance().logError("Create Job in new ClassLoader", Const.getStackTracker((Throwable)e), new Object[0]);
            throw new KettleException(message, (Throwable)e);
        }
    }

    public String getJobname() {
        if (this.jobMeta == null) {
            return null;
        }
        return this.jobMeta.getName();
    }

    public void setRepository(Repository rep) {
        this.rep = rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block9: {
            this.stopped = false;
            this.finished = false;
            this.initialized = true;
            this.variables.initializeVariablesFrom((VariableSpace)this.parentJob);
            this.setInternalKettleVariables(this.variables);
            this.copyParametersFrom(this.jobMeta);
            this.activateParameters();
            this.result = this.execute(false);
            Object var3_1 = null;
            try {
                this.endProcessing("end", this.result);
            }
            catch (KettleJobException e) {
                this.log.logError(this.toString(), Messages.getString("Job.Log.ErrorExecJob", e.getMessage()), new Object[0]);
                this.log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
            }
            this.fireJobListeners();
            {
                break block9;
                catch (Throwable je) {
                    this.log.logError(this.toString(), Messages.getString("Job.Log.ErrorExecJob", je.getMessage()), new Object[0]);
                    this.log.logError(this.toString(), Const.getStackTracker((Throwable)je), new Object[0]);
                    this.result = new Result();
                    this.result.setNrErrors(1L);
                    this.result.setResult(false);
                    this.addErrors(1);
                    this.active = false;
                    this.finished = true;
                    this.stopped = false;
                    Object var3_2 = null;
                    try {
                        this.endProcessing("end", this.result);
                    }
                    catch (KettleJobException e) {
                        this.log.logError(this.toString(), Messages.getString("Job.Log.ErrorExecJob", e.getMessage()), new Object[0]);
                        this.log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                    }
                    this.fireJobListeners();
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.endProcessing("end", this.result);
                }
                catch (KettleJobException e) {
                    this.log.logError(this.toString(), Messages.getString("Job.Log.ErrorExecJob", e.getMessage()), new Object[0]);
                    this.log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                }
                this.fireJobListeners();
                throw throwable;
            }
        }
    }

    public Result execute() throws KettleException {
        return this.execute(true);
    }

    private Result execute(boolean fireJobListeners) throws KettleException {
        this.finished = false;
        this.stopped = false;
        JobEntryResult jerStart = new JobEntryResult(null, Messages.getString("Job.Comment.JobStarted"), Messages.getString("Job.Reason.Started"), null);
        this.jobTracker.addJobTracker(new JobTracker(this.jobMeta, jerStart));
        this.active = true;
        this.beginProcessing();
        JobEntryCopy startpoint = this.jobMeta.findJobEntry("START", 0, false);
        if (startpoint == null) {
            throw new KettleJobException(Messages.getString("Job.Log.CounldNotFindStartingPoint"));
        }
        JobEntrySpecial jes = (JobEntrySpecial)startpoint.getEntry();
        Result res = null;
        boolean isFirst = true;
        while ((jes.isRepeat() || isFirst) && !this.isStopped()) {
            isFirst = false;
            res = this.execute(0, null, startpoint, null, Messages.getString("Job.Reason.Started"));
        }
        JobEntryResult jerEnd = new JobEntryResult(res, Messages.getString("Job.Comment.JobFinished"), Messages.getString("Job.Reason.Finished"), null);
        this.jobTracker.addJobTracker(new JobTracker(this.jobMeta, jerEnd));
        this.active = false;
        if (fireJobListeners) {
            this.fireJobListeners();
        }
        return res;
    }

    public Result execute(int nr, Result result) throws KettleException {
        JobEntryCopy startpoint;
        this.finished = false;
        if (this.getSourceRows() != null) {
            result.setRows(this.getSourceRows());
        }
        if ((startpoint = this.jobMeta.findJobEntry("START", 0, false)) == null) {
            throw new KettleJobException(Messages.getString("Job.Log.CounldNotFindStartingPoint"));
        }
        Result res = this.execute(nr, result, startpoint, null, Messages.getString("Job.Reason.StartOfJobentry"));
        this.fireJobListeners();
        return res;
    }

    private void fireJobListeners() {
        this.finished = true;
        for (JobListener jobListener : this.jobListeners) {
            jobListener.jobFinished(this);
        }
    }

    private Result execute(final int nr, Result prev_result, final JobEntryCopy startpoint, JobEntryCopy previous, String reason) throws KettleException {
        int i;
        Result res = null;
        if (this.stopped) {
            res = new Result(nr);
            res.stopped = true;
            return res;
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(this.toString(), "exec(" + nr + ", " + (prev_result != null ? prev_result.getNrErrors() : 0L) + ", " + (startpoint != null ? startpoint.toString() : "null") + ")", new Object[0]);
        }
        JobEntryInterface jei = startpoint.getEntry();
        JobEntryResult jerBefore = new JobEntryResult(null, Messages.getString("Job.Comment.JobStarted"), reason, startpoint);
        this.jobTracker.addJobTracker(new JobTracker(this.jobMeta, jerBefore));
        Result prevResult = null;
        prevResult = prev_result != null ? prev_result.clone() : new Result();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(jei.getClass().getClassLoader());
        JobEntryInterface cloneJei = (JobEntryInterface)jei.clone();
        ((VariableSpace)cloneJei).copyVariablesFrom((VariableSpace)this);
        final Result result = cloneJei.execute(prevResult, nr, this.rep, this);
        Thread.currentThread().setContextClassLoader(cl);
        this.addErrors((int)result.getNrErrors());
        JobEntryResult jerAfter = new JobEntryResult(result, Messages.getString("Job.Comment.JobFinished"), null, startpoint);
        this.jobTracker.addJobTracker(new JobTracker(this.jobMeta, jerAfter));
        ArrayList<Thread> threads = new ArrayList<Thread>();
        final ArrayList threadResults = new ArrayList();
        final ArrayList<KettleException> threadExceptions = new ArrayList<KettleException>();
        ArrayList<JobEntryCopy> threadEntries = new ArrayList<JobEntryCopy>();
        int nrNext = this.jobMeta.findNrNextJobEntries(startpoint);
        for (i = 0; i < nrNext && !this.isStopped(); ++i) {
            final JobEntryCopy nextEntry = this.jobMeta.findNextJobEntry(startpoint, i);
            JobHopMeta hi = this.jobMeta.findJobHop(startpoint, nextEntry);
            final String nextComment = hi.isUnconditional() ? Messages.getString("Job.Comment.FollowedUnconditional") : (result.getResult() ? Messages.getString("Job.Comment.FollowedSuccess") : Messages.getString("Job.Comment.FollowedFailure"));
            if (!hi.isUnconditional() && (!startpoint.evaluates() || hi.getEvaluation() ^ result.getResult())) continue;
            if (this.log.isBasic()) {
                this.log.logBasic(this.jobMeta.toString(), Messages.getString("Job.Log.StartingEntry", nextEntry.getName()), new Object[0]);
            }
            if (nextEntry.resetErrorsBeforeExecution()) {
                result.setNrErrors(0L);
            }
            if (startpoint.isLaunchingInParallel()) {
                threadEntries.add(nextEntry);
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            Result threadResult = Job.this.execute(nr + 1, result, nextEntry, startpoint, nextComment);
                            threadResults.add(threadResult);
                        }
                        catch (Throwable e) {
                            Job.this.log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                            threadExceptions.add(new KettleException(Messages.getString("Job.Log.UnexpectedError", nextEntry.toString()), e));
                            Result threadResult = new Result();
                            threadResult.setResult(false);
                            threadResult.setNrErrors(1L);
                            threadResults.add(threadResult);
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                threads.add(thread);
                thread.start();
                if (!this.log.isBasic()) continue;
                this.log.logBasic(this.jobMeta.toString(), Messages.getString("Job.Log.LaunchedJobEntryInParallel", nextEntry.getName()), new Object[0]);
                continue;
            }
            try {
                res = this.execute(nr + 1, result, nextEntry, startpoint, nextComment);
            }
            catch (Throwable e) {
                this.log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                throw new KettleException(Messages.getString("Job.Log.UnexpectedError", nextEntry.toString()), e);
            }
            if (!this.log.isBasic()) continue;
            this.log.logBasic(this.jobMeta.toString(), Messages.getString("Job.Log.FinishedJobEntry", nextEntry.getName(), res.getResult() + ""), new Object[0]);
        }
        if (startpoint.isLaunchingInParallel()) {
            for (i = 0; i < threads.size(); ++i) {
                Thread thread = (Thread)threads.get(i);
                JobEntryCopy nextEntry = (JobEntryCopy)threadEntries.get(i);
                try {
                    thread.join();
                    continue;
                }
                catch (InterruptedException e) {
                    this.log.logError(this.jobMeta.toString(), Messages.getString("Job.Log.UnexpectedErrorWhileWaitingForJobEntry", nextEntry.getName()), new Object[0]);
                    threadExceptions.add(new KettleException(Messages.getString("Job.Log.UnexpectedErrorWhileWaitingForJobEntry", nextEntry.getName()), (Throwable)e));
                }
            }
        }
        if (res == null) {
            res = prevResult;
        }
        if (threadExceptions.size() > 0) {
            res.setResult(false);
            res.setNrErrors((long)threadExceptions.size());
            for (KettleException e : threadExceptions) {
                this.log.logError(this.jobMeta.toString(), e.getMessage(), (Throwable)e);
            }
            throw (KettleException)((Object)threadExceptions.get(0));
        }
        for (Result threadResult : threadResults) {
            res.add(threadResult);
        }
        if (res.getNrErrors() > 0L) {
            res.setResult(false);
        }
        return res;
    }

    public void waitUntilFinished() {
        this.waitUntilFinished(-1L);
    }

    public void waitUntilFinished(long maxMiliseconds) {
        try {
            while (this.isAlive()) {
                Thread.sleep(0L, 1);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getErrors() {
        return this.errors;
    }

    public void resetErrors() {
        this.errors = 0;
    }

    public void addErrors(int nrToAdd) {
        if (nrToAdd > 0) {
            this.errors += nrToAdd;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean beginProcessing() throws KettleJobException {
        this.currentDate = new Date();
        this.logDate = new Date();
        this.startDate = Const.MIN_DATE;
        this.endDate = this.currentDate;
        this.resetErrors();
        DatabaseMeta logcon = this.jobMeta.getLogConnection();
        if (logcon != null && !Const.isEmpty((String)this.jobMeta.getLogTable())) {
            Database ldb = new Database(logcon);
            ldb.shareVariablesWith((VariableSpace)this);
            try {
                try {
                    Object[] lastr;
                    boolean lockedTable = false;
                    ldb.connect();
                    ldb.setCommit(100);
                    Long id_batch = new Long(1L);
                    if (this.jobMeta.isBatchIdUsed()) {
                        ldb.lockTables(new String[]{this.jobMeta.getLogTable()});
                        lockedTable = true;
                        String sql = "INSERT INTO " + logcon.quoteField(this.jobMeta.getLogTable()) + "(" + logcon.quoteField("ID_JOB") + ") values (-1)";
                        ldb.execStatement(sql);
                        id_batch = ldb.getNextValue(null, this.jobMeta.getLogTable(), "ID_JOB");
                        this.setBatchId(id_batch);
                        if (this.getPassedBatchId() <= 0L) {
                            this.setPassedBatchId(id_batch);
                        }
                    }
                    if (!Const.isEmpty((Object[])(lastr = ldb.getLastLogDate(this.jobMeta.getLogTable(), this.jobMeta.getName(), true, "end")))) {
                        Date last;
                        try {
                            last = ldb.getReturnRowMeta().getDate(lastr, 0);
                        }
                        catch (KettleValueException e) {
                            throw new KettleJobException(Messages.getString("Job.Log.ConversionError", "" + this.jobMeta.getLogTable()), (Throwable)e);
                        }
                        if (last != null) {
                            this.startDate = last;
                        }
                    }
                    this.depDate = this.currentDate;
                    ldb.writeLogRecord(this.jobMeta.getLogTable(), this.jobMeta.isBatchIdUsed(), this.getBatchId(), true, this.jobMeta.getName(), "start", 0L, 0L, 0L, 0L, 0L, 0L, this.startDate, this.endDate, this.logDate, this.depDate, this.currentDate, null);
                    if (lockedTable) {
                        String sql = "DELETE FROM " + logcon.quoteField(this.jobMeta.getLogTable()) + " WHERE " + logcon.quoteField("ID_JOB") + "= -1";
                        ldb.execStatement(sql);
                        ldb.unlockTables(new String[]{this.jobMeta.getLogTable()});
                    }
                    ldb.disconnect();
                }
                catch (KettleDatabaseException dbe) {
                    this.addErrors(1);
                    throw new KettleJobException(Messages.getString("Job.Log.UnableToProcessLoggingStart", "" + this.jobMeta.getLogTable()), (Throwable)dbe);
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                ldb.disconnect();
                throw throwable;
            }
            ldb.disconnect();
        }
        if (this.jobMeta.isLogfieldUsed()) {
            this.stringAppender = LogWriter.createStringAppender();
            String logLimit = this.environmentSubstitute(this.jobMeta.getLogSizeLimit());
            if (Const.isEmpty((String)logLimit)) {
                logLimit = this.environmentSubstitute("KETTLE_LOG_SIZE_LIMIT");
            }
            this.stringAppender.setMaxNrLines(Const.toInt((String)logLimit, (int)0));
            this.log.addAppender((Appender)this.stringAppender);
            this.stringAppender.setBuffer(new StringBuffer("START" + Const.CR));
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean endProcessing(String status, Result res) throws KettleJobException {
        try {
            DatabaseMeta logcon;
            long read = res.getNrLinesRead();
            long written = res.getNrLinesWritten();
            long updated = res.getNrLinesUpdated();
            long errors = res.getNrErrors();
            long input = res.getNrLinesInput();
            long output = res.getNrLinesOutput();
            if (errors == 0L && !res.getResult()) {
                errors = 1L;
            }
            this.logDate = new Date();
            String log_string = null;
            if (this.jobMeta.isLogfieldUsed()) {
                log_string = this.stringAppender.getBuffer().append(Const.CR + "END" + Const.CR).toString();
                this.log.removeAppender((Appender)this.stringAppender);
            }
            if ((logcon = this.jobMeta.getLogConnection()) == null) return true;
            Database ldb = new Database(logcon);
            ldb.shareVariablesWith((VariableSpace)this);
            try {
                try {
                    ldb.connect();
                    ldb.writeLogRecord(this.jobMeta.getLogTable(), this.jobMeta.isBatchIdUsed(), this.getBatchId(), true, this.jobMeta.getName(), status, read, written, updated, input, output, errors, this.startDate, this.endDate, this.logDate, this.depDate, this.currentDate, log_string);
                }
                catch (KettleDatabaseException dbe) {
                    this.addErrors(1);
                    throw new KettleJobException("Unable to end processing by writing log record to table " + this.jobMeta.getLogTable(), (Throwable)dbe);
                }
                Object var20_13 = null;
            }
            catch (Throwable throwable) {
                Object var20_14 = null;
                ldb.disconnect();
                throw throwable;
            }
            ldb.disconnect();
            return true;
        }
        catch (Exception e) {
            throw new KettleJobException((Throwable)e);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void stopAll() {
        this.stopped = true;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public Date getDepDate() {
        return this.depDate;
    }

    public Date getLogDate() {
        return this.logDate;
    }

    public JobMeta getJobMeta() {
        return this.jobMeta;
    }

    public LogWriter getLog() {
        return this.log;
    }

    public Repository getRep() {
        return this.rep;
    }

    public Thread getThread() {
        return this;
    }

    public JobTracker getJobTracker() {
        return this.jobTracker;
    }

    public void setJobTracker(JobTracker jobTracker) {
        this.jobTracker = jobTracker;
    }

    public void setSourceRows(List<RowMetaAndData> sourceRows) {
        this.sourceRows = sourceRows;
    }

    public List<RowMetaAndData> getSourceRows() {
        return this.sourceRows;
    }

    public Job getParentJob() {
        return this.parentJob;
    }

    public void setParentJob(Job parentJob) {
        this.parentJob = parentJob;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(long batchId) {
        this.batchId = batchId;
    }

    public long getPassedBatchId() {
        return this.passedBatchId;
    }

    public void setPassedBatchId(long jobBatchId) {
        this.passedBatchId = jobBatchId;
    }

    public void setInternalKettleVariables(VariableSpace var) {
        if (this.jobMeta != null && this.jobMeta.getFilename() != null) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.jobMeta.getFilename());
                FileName fileName = fileObject.getName();
                var.setVariable("Internal.Job.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                var.setVariable("Internal.Job.Filename.Directory", fileDir.getURI());
            }
            catch (IOException e) {
                var.setVariable("Internal.Job.Filename.Directory", "");
                var.setVariable("Internal.Job.Filename.Name", "");
            }
        } else {
            var.setVariable("Internal.Job.Filename.Directory", "");
            var.setVariable("Internal.Job.Filename.Name", "");
        }
        var.setVariable("Internal.Job.Name", Const.NVL((String)this.jobMeta.getName(), (String)""));
        var.setVariable("Internal.Transformation.Repository.Directory", this.jobMeta.getDirectory() != null ? this.jobMeta.getDirectory().getPath() : "");
        var.setVariable("Internal.Transformation.Filename.Directory", null);
        var.setVariable("Internal.Transformation.Filename.Name", null);
        var.setVariable("Internal.Transformation.Filename.Directory", null);
        var.setVariable("Internal.Transformation.Filename.Name", null);
        var.setVariable("Internal.Transformation.Name", null);
        var.setVariable("Internal.Transformation.Repository.Directory", null);
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public String getStatus() {
        String message;
        if (!this.initialized) {
            message = "Waiting";
        } else if (this.active) {
            message = this.stopped ? "Halting" : "Running";
        } else {
            message = this.stopped ? "Stopped" : "Finished";
            if (this.result != null && this.result.getNrErrors() > 0L) {
                message = message + " (with errors)";
            }
        }
        return message;
    }

    public static void sendToSlaveServer(JobMeta jobMeta, JobExecutionConfiguration executionConfiguration, Repository repository) throws KettleException {
        SlaveServer slaveServer = executionConfiguration.getRemoteServer();
        if (slaveServer == null) {
            throw new KettleException(Messages.getString("Job.Log.NoSlaveServerSpecified"));
        }
        if (Const.isEmpty((String)jobMeta.getName())) {
            throw new KettleException(Messages.getString("Job.Log.UniqueJobName"));
        }
        try {
            for (String var : Const.INTERNAL_TRANS_VARIABLES) {
                executionConfiguration.getVariables().put(var, jobMeta.getVariable(var));
            }
            for (String var : Const.INTERNAL_JOB_VARIABLES) {
                executionConfiguration.getVariables().put(var, jobMeta.getVariable(var));
            }
            if (executionConfiguration.isPassingExport()) {
                FileObject tempFile = KettleVFS.createTempFile((String)"jobExport", (String)".zip", (String)System.getProperty("java.io.tmpdir"));
                TopLevelResource topLevelResource = ResourceUtil.serializeResourceExportInterface(tempFile.getName().toString(), jobMeta, jobMeta, repository, executionConfiguration.getXML(), CONFIGURATION_IN_EXPORT_FILENAME);
                String result = slaveServer.sendExport(topLevelResource.getArchiveName(), "job", topLevelResource.getBaseResourceName());
                WebResult webResult = WebResult.fromXMLString(result);
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    throw new KettleException("There was an error passing the exported job to the remote server: " + Const.CR + webResult.getMessage());
                }
                String remoteFile = webResult.getMessage();
                LogWriter.getInstance().logBasic(jobMeta.getName(), "Added the remote job to slave server [" + slaveServer.getName() + "] for remote file: " + remoteFile, new Object[0]);
            } else {
                String xml = new JobConfiguration(jobMeta, executionConfiguration).getXML();
                String reply = slaveServer.sendXML(xml, "/kettle/addJob/?xml=Y");
                WebResult webResult = WebResult.fromXMLString(reply);
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    throw new KettleException("There was an error posting the job on the remote server: " + Const.CR + webResult.getMessage());
                }
            }
            String reply = slaveServer.getContentFromServer("/kettle/startJob/?name=" + URLEncoder.encode(jobMeta.getName(), "UTF-8") + "&xml=Y");
            WebResult webResult = WebResult.fromXMLString(reply);
            if (!webResult.getResult().equalsIgnoreCase("OK")) {
                throw new KettleException("There was an error starting the job on the remote server: " + Const.CR + webResult.getMessage());
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public List<JobListener> getJobListeners() {
        return this.jobListeners;
    }

    public void setJobListeners(List<JobListener> jobListeners) {
        this.jobListeners = jobListeners;
    }

    public void addJobListener(JobListener jobListener) {
        this.jobListeners.add(jobListener);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
        if (finished) {
            System.out.println("--------------------- Finished ---------------------------");
        }
    }

    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        this.namedParams.addParameterDefinition(key, defValue, description);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        return this.namedParams.getParameterDescription(key);
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        return this.namedParams.getParameterDefault(key);
    }

    public String getParameterValue(String key) throws UnknownParamException {
        return this.namedParams.getParameterValue(key);
    }

    public String[] listParameters() {
        return this.namedParams.listParameters();
    }

    public void setParameterValue(String key, String value) throws UnknownParamException {
        this.namedParams.setParameterValue(key, value);
    }

    public void eraseParameters() {
        this.namedParams.eraseParameters();
    }

    public void clearParameters() {
        this.namedParams.clearParameters();
    }

    public void activateParameters() {
        String[] keys;
        for (String key : keys = this.listParameters()) {
            String defValue;
            String value;
            try {
                value = this.getParameterValue(key);
            }
            catch (UnknownParamException e) {
                value = "";
            }
            try {
                defValue = this.getParameterDefault(key);
            }
            catch (UnknownParamException e) {
                defValue = "";
            }
            if (Const.isEmpty((String)value)) {
                this.setVariable(key, Const.NVL((String)defValue, (String)""));
                continue;
            }
            this.setVariable(key, Const.NVL((String)value, (String)""));
        }
    }

    public void copyParametersFrom(NamedParams params) {
        this.namedParams.copyParametersFrom(params);
    }

    public void setSocketRepository(SocketRepository socketRepository) {
        this.socketRepository = socketRepository;
    }

    public SocketRepository getSocketRepository() {
        return this.socketRepository;
    }
}

